/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.MapBuilder;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ObjectUtils {
    private static final Map<Class<?>, Object> DEFAULT_VALUES = MapBuilder.get().put(Byte.TYPE, (byte)0).put(Short.TYPE, (Byte)((short)0)).put(Integer.TYPE, (Byte)0).put(Long.TYPE, (Byte)0L).put(Float.TYPE, (Byte)((Object)Float.valueOf(0.0f))).put(Double.TYPE, (Byte)0.0).put(Character.TYPE, (Byte)((Object)Character.valueOf('\u0000'))).put(Boolean.TYPE, (Byte)((Object)Boolean.valueOf(false))).build();

    private ObjectUtils() {
    }

    public static <T extends Comparable<T>> boolean between(T value, T min, T max) {
        return ObjectUtils.between(value, min, max, true, true);
    }

    public static <T extends Comparable<T>> boolean between(T value, T min, T max, boolean includeMin, boolean includeMax) {
        return ObjectUtils.compare(value, min) + (includeMin ? 1 : 0) > 0 && ObjectUtils.compare(value, max) - (includeMax ? 1 : 0) < 0;
    }

    public static <T extends Comparable<T>> int compare(T obj1, T obj2) {
        return ObjectUtils.compare(obj1, obj2, Comparator.naturalOrder());
    }

    public static <T> int compare(T obj1, T obj2, Comparator<T> comparator) {
        Validation.notNull(comparator, "The comparator to compare objects cannot be null.", new Object[0]);
        if (obj1 == null) {
            if (obj2 == null) {
                return 0;
            }
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        return comparator.compare(obj1, obj2);
    }

    public static <T> T defaultValue(Class<T> clazz) {
        Validation.notNull(clazz, "The class to look up default value cannot be null.", new Object[0]);
        return (T)DEFAULT_VALUES.get(clazz);
    }

    public static <T> T getIfNull(T value, Supplier<T> factory) {
        Validation.notNull(factory, "The factory to create default value cannot be null.", new Object[0]);
        return value == null ? factory.get() : value;
    }

    public static <T, R> R mapIfNotNull(T value, Function<T, R> mapper) {
        Validation.notNull(mapper, "The mapper cannot be null.", new Object[0]);
        return value == null ? null : (R)mapper.apply(value);
    }

    public static <T> T nullIf(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static <T> T cast(Object value) {
        return (T)value;
    }

    public static String toNormalizedString(Object obj) {
        return StringUtils.normalize(ObjectUtils.toString(obj));
    }

    public static String toString(Object obj) {
        return ObjectUtils.mapIfNotNull(obj, Object::toString);
    }
}

