/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.parameterization.ParameterizedString;
import com.huawei.fitframework.core.common.parameterization.ParameterizedStringResolver;
import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.Equalizer;
import com.huawei.fitframework.core.common.util.IntegerUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.ArrayIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class StringUtils {
    public static final String EMPTY = "";
    private static final ParameterizedStringResolver FORMATTER = ParameterizedStringResolver.create("{", "}", '/');

    private StringUtils() {
    }

    public static int compare(String str1, String str2) {
        return ObjectUtils.compare(str1, str2);
    }

    public static int compareIgnoreCase(String str1, String str2) {
        return ObjectUtils.compare(str1, str2, String::compareToIgnoreCase);
    }

    public static <T> String concat(Function<T, String> mapper, Iterator<T> iterator) {
        return StringUtils.join(EMPTY, mapper, iterator);
    }

    public static <T> String concat(Function<T, String> mapper, List<T> list) {
        return StringUtils.concat(mapper, CollectionUtils.iterator(list));
    }

    @SafeVarargs
    public static <T> String concat(Function<T, String> mapper, T ... array) {
        return StringUtils.concat(mapper, new ArrayIterator<T>(array));
    }

    public static <T> String concat(Iterator<T> iterator) {
        return StringUtils.concat(null, iterator);
    }

    public static <T> String concat(List<T> list) {
        return StringUtils.concat(null, CollectionUtils.iterator(list));
    }

    @SafeVarargs
    public static <T> String concat(T ... array) {
        return StringUtils.concat(null, new ArrayIterator<T>(array));
    }

    public static boolean endsWithIgnoreCase(String source, String suffix) {
        if (source == null) {
            return suffix == null;
        }
        if (suffix == null || source.length() < suffix.length()) {
            return false;
        }
        return source.regionMatches(true, source.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static Equalizer<String> equalizer(boolean ignoreCase) {
        return ignoreCase ? StringUtils::equalsIgnoreCase : StringUtils::equals;
    }

    public static boolean equals(String str1, String str2) {
        return Objects.equals(str1, str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String format(String format, Object ... args) {
        if (StringUtils.isBlank(format)) {
            return format;
        }
        ParameterizedString parameterizedString = FORMATTER.resolve(format);
        HashMap<String, Object> params = new HashMap<String, Object>(args.length);
        for (int i = 0; i < args.length; ++i) {
            params.put(Integer.toString(i), args[i]);
        }
        return parameterizedString.format(params);
    }

    public static boolean isBlank(String source) {
        if (StringUtils.isEmpty(source)) {
            return true;
        }
        for (int i = 0; i < source.length(); ++i) {
            if (Character.isWhitespace(source.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String source) {
        return source == null || source.isEmpty();
    }

    public static boolean isNotBlank(String source) {
        return !StringUtils.isBlank(source);
    }

    public static boolean isNotEmpty(String source) {
        return !StringUtils.isEmpty(source);
    }

    public static <T> String join(char separator, Function<T, String> mapper, Iterator<T> iterator) {
        return StringUtils.join(Character.toString(separator), mapper, iterator);
    }

    public static <T> String join(char separator, Function<T, String> mapper, List<T> list) {
        return StringUtils.join(Character.toString(separator), mapper, CollectionUtils.iterator(list));
    }

    @SafeVarargs
    public static <T> String join(char separator, Function<T, String> mapper, T ... array) {
        return StringUtils.join(Character.toString(separator), mapper, ArrayUtils.iterator(array));
    }

    public static <T> String join(char separator, Iterator<T> iterator) {
        return StringUtils.join(Character.toString(separator), null, iterator);
    }

    public static <T> String join(char separator, List<T> list) {
        return StringUtils.join(Character.toString(separator), null, CollectionUtils.iterator(list));
    }

    @SafeVarargs
    public static <T> String join(char separator, T ... array) {
        return StringUtils.join(Character.toString(separator), null, ArrayUtils.iterator(array));
    }

    public static <T> String join(String separator, Function<T, String> mapper, Iterator<T> iterator) {
        StringBuilder builder = new StringBuilder();
        if (iterator != null && iterator.hasNext()) {
            Function<Object, String> actualMapper = ObjectUtils.nullIf(mapper, ObjectUtils::toNormalizedString);
            builder.append(actualMapper.apply(iterator.next()));
            while (iterator.hasNext()) {
                builder.append(separator).append(actualMapper.apply(iterator.next()));
            }
        }
        return builder.toString();
    }

    public static <T> String join(String separator, Function<T, String> mapper, List<T> list) {
        return StringUtils.join(separator, mapper, CollectionUtils.iterator(list));
    }

    @SafeVarargs
    public static <T> String join(String separator, Function<T, String> mapper, T ... array) {
        return StringUtils.join(separator, mapper, ArrayUtils.iterator(array));
    }

    public static <T> String join(String separator, Iterator<T> iterator) {
        return StringUtils.join(separator, null, iterator);
    }

    public static <T> String join(String separator, List<T> list) {
        return StringUtils.join(separator, null, CollectionUtils.iterator(list));
    }

    @SafeVarargs
    public static <T> String join(String separator, T ... array) {
        return StringUtils.join(separator, null, ArrayUtils.iterator(array));
    }

    public static boolean lengthBetween(String source, int min, int max) {
        return StringUtils.lengthBetween(source, min, max, true, false);
    }

    public static boolean lengthBetween(String source, int min, int max, boolean allowMinimum, boolean allowMaximum) {
        if (source == null) {
            return false;
        }
        return IntegerUtils.between(source.length(), min, max, allowMinimum, allowMaximum);
    }

    public static <T> T mapIfNotBlank(String value, Function<String, T> mapper) {
        Validation.notNull(mapper, "The mapper cannot be null.", new Object[0]);
        return StringUtils.isBlank(value) ? null : (T)mapper.apply(value);
    }

    public static String normalize(String source) {
        return ObjectUtils.nullIf(source, EMPTY);
    }

    public static String padLeft(String source, char padding, int length) {
        if (length < 0) {
            return source;
        }
        String actual = StringUtils.normalize(source);
        if (length > actual.length()) {
            StringBuilder builder = new StringBuilder();
            for (int i = actual.length(); i < length; ++i) {
                builder.append(padding);
            }
            builder.append(actual);
            return builder.toString();
        }
        return actual;
    }

    public static String padRight(String source, char padding, int length) {
        if (length < 0) {
            return source;
        }
        String actual = StringUtils.normalize(source);
        if (length > actual.length()) {
            StringBuilder builder = new StringBuilder();
            builder.append(actual);
            for (int i = actual.length(); i < length; ++i) {
                builder.append(padding);
            }
            return builder.toString();
        }
        return actual;
    }

    public static String replace(String source, char oldChar, char newChar) {
        if (StringUtils.isEmpty(source)) {
            return source;
        }
        return source.replace(oldChar, newChar);
    }

    public static String[] split(String source, char separator) {
        ArrayList parts = StringUtils.split(source, separator, ArrayList::new);
        return parts.toArray(new String[0]);
    }

    public static <C extends Collection<String>> C split(String source, char separator, Supplier<C> collectionSupplier) {
        return StringUtils.split(source, separator, collectionSupplier, null);
    }

    public static <C extends Collection<String>> C split(String source, char separator, Supplier<C> collectionSupplier, Predicate<String> partPredicator) {
        return StringUtils.split(source, Character.toString(separator), collectionSupplier, partPredicator);
    }

    public static String[] split(String source, String separator) {
        ArrayList parts = StringUtils.split(source, separator, ArrayList::new);
        return parts.toArray(new String[0]);
    }

    public static <C extends Collection<String>> C split(String source, String separator, Supplier<C> collectionSupplier) {
        return StringUtils.split(source, separator, collectionSupplier, null);
    }

    public static <C extends Collection<String>> C split(String source, String separator, Supplier<C> collectionSupplier, Predicate<String> partPredicator) {
        String part;
        int stop;
        Validation.notNull(source, "The string to be split cannot be null.", new Object[0]);
        Validation.notNull(collectionSupplier, "The collectionSupplier cannot be null.", new Object[0]);
        Collection parts = (Collection)collectionSupplier.get();
        Predicate<String> actualPartPredicator = ObjectUtils.nullIf(partPredicator, value -> true);
        if (StringUtils.isEmpty(separator)) {
            return StringUtils.splitWithEmptySeparator(source, collectionSupplier, actualPartPredicator);
        }
        int start = 0;
        int limit = separator.length();
        while ((stop = source.indexOf(separator, start)) != -1) {
            part = source.substring(start, stop);
            StringUtils.appendParts(parts, part, actualPartPredicator);
            start = stop + limit;
        }
        part = source.substring(start);
        StringUtils.appendParts(parts, part, actualPartPredicator);
        return (C)parts;
    }

    private static <C extends Collection<String>> C splitWithEmptySeparator(String source, Supplier<C> collectionSupplier, Predicate<String> partPredicator) {
        return (C)source.chars().mapToObj(ch -> Character.valueOf((char)ch)).map(String::valueOf).filter(partPredicator).collect(collectionSupplier, Collection::add, Collection::addAll);
    }

    private static <C extends Collection<String>> void appendParts(C parts, String part, Predicate<String> partPredicator) {
        if (partPredicator.test(part)) {
            parts.add((String)part);
        }
    }

    public static List<String> splitToList(String source, char separator) {
        return StringUtils.split(source, separator, ArrayList::new);
    }

    public static List<String> splitToList(String source, String separator) {
        return StringUtils.split(source, separator, ArrayList::new);
    }

    public static Set<String> splitToSet(String source, char separator) {
        return StringUtils.split(source, separator, HashSet::new);
    }

    public static Set<String> splitToSet(String source, String separator) {
        return StringUtils.split(source, separator, HashSet::new);
    }

    public static String substring(String source, int startIndex, int endIndex) {
        Validation.notNull(source, "The source string is null.", new Object[0]);
        int start = Validation.greaterThanOrEquals(StringUtils.canonicalizeIndex(source, startIndex), 0, () -> new IllegalStateException(StringUtils.format("The start index is out of range: {0}.", startIndex)));
        int end = Validation.greaterThanOrEquals(StringUtils.canonicalizeIndex(source, endIndex), 0, () -> new IllegalStateException(StringUtils.format("The end index is out of range: {0}.", endIndex)));
        if (start > end) {
            String format = "The canonical start index is greater than the canonical end index. [startIndex={0}, endIndex={1}, canonicalStartIndex={2}, canonicalEndIndex={3}]";
            String message = StringUtils.format(format, startIndex, endIndex, start, end);
            throw new IllegalStateException(message);
        }
        return source.substring(start, end);
    }

    private static int canonicalizeIndex(String value, int index) {
        int canonical = index;
        if (canonical < 0) {
            canonical += value.length();
        }
        if (canonical < 0 || canonical > value.length()) {
            return -1;
        }
        return canonical;
    }

    public static String substringAfter(String source, String separator) {
        if (StringUtils.isEmpty(source) || StringUtils.isEmpty(separator)) {
            return source;
        }
        int index = source.indexOf(separator);
        return index == -1 ? EMPTY : source.substring(index + separator.length());
    }

    public static String surround(String source, char surroundWith) {
        return StringUtils.surround(source, surroundWith, surroundWith);
    }

    public static String surround(String source, char prefix, char suffix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        if (StringUtils.isNotEmpty(source)) {
            builder.append(source);
        }
        builder.append(suffix);
        return builder.toString();
    }

    public static String toLowerCase(String source) {
        return StringUtils.toLowerCase(source, Locale.ROOT);
    }

    public static String toLowerCase(String source, Locale locale) {
        return StringUtils.isBlank(source) ? source : source.toLowerCase(ObjectUtils.nullIf(locale, Locale.ROOT));
    }

    public static String toUpperCase(String source) {
        return StringUtils.toUpperCase(source, Locale.ROOT);
    }

    public static String toUpperCase(String source, Locale locale) {
        return StringUtils.isBlank(source) ? source : source.toUpperCase(ObjectUtils.nullIf(locale, Locale.ROOT));
    }

    public static String trim(String source) {
        if (source == null) {
            return null;
        }
        return source.trim();
    }

    public static String trim(String source, char ch) {
        return StringUtils.trim(source, ch, ch);
    }

    public static String trim(String source, char startCh, char endCh) {
        return StringUtils.trimEnd(StringUtils.trimStart(source, startCh), endCh);
    }

    public static String trimEnd(String source) {
        int index;
        if (source == null) {
            return null;
        }
        for (index = source.length() - 1; index >= 0 && Character.isWhitespace(source.charAt(index)); --index) {
        }
        return source.substring(0, index + 1);
    }

    public static String trimEnd(String source, char ch) {
        int index;
        if (source == null) {
            return null;
        }
        for (index = source.length() - 1; index >= 0 && source.charAt(index) == ch; --index) {
        }
        return source.substring(0, index + 1);
    }

    public static String trimStart(String source) {
        int index;
        if (source == null) {
            return null;
        }
        for (index = 0; index < source.length() && Character.isWhitespace(source.charAt(index)); ++index) {
        }
        return source.substring(index);
    }

    public static String trimStart(String source, char ch) {
        int index;
        if (source == null) {
            return null;
        }
        for (index = 0; index < source.length() && source.charAt(index) == ch; ++index) {
        }
        return source.substring(index);
    }

    public static String bytesToString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length << 1);
        for (byte aByte : bytes) {
            String text = Integer.toHexString(Byte.toUnsignedInt(aByte));
            if (text.length() == 1) {
                builder.append('0');
            }
            builder.append(text);
        }
        return builder.toString();
    }

    public static byte[] stringToBytes(String text) {
        byte[] genericId = new byte[text.length() >> 1];
        int index = 0;
        for (int i = 0; i < text.length(); ++i) {
            char high = text.charAt(i++);
            char low = text.charAt(i);
            int value = StringUtils.valueChar(high) << 4 | StringUtils.valueChar(low);
            genericId[index++] = (byte)value;
        }
        return genericId;
    }

    private static int valueChar(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalStateException(StringUtils.format("Char is out of range, legal char range is [0-9A-Fa-f]. [ch='{0}']", Character.valueOf(ch)));
    }
}

