/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.composite;

import com.huawei.fitframework.core.common.util.composite.support.ConsumerCompositeConcurrentDecorator;
import com.huawei.fitframework.core.common.util.composite.support.DefaultConsumerComposite;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public interface ConsumerComposite<T>
extends Consumer<T> {
    public static <T> ConsumerComposite<T> createDefault() {
        return new DefaultConsumerComposite();
    }

    public static <T> ConsumerComposite<T> createConcurrent() {
        ConsumerComposite<T> defaultComposite = ConsumerComposite.createDefault();
        return defaultComposite.concurrent();
    }

    @Override
    default public void accept(T object) {
        this.getConsumers().stream().filter(Objects::nonNull).forEach(consumer -> consumer.accept(object));
    }

    default public ConsumerComposite<T> concurrent() {
        return new ConsumerCompositeConcurrentDecorator(this);
    }

    public List<Consumer<T>> getConsumers();

    public void add(Consumer<T> var1);

    public void addAll(Collection<Consumer<T>> var1);

    public void remove(Consumer<T> var1);

    public void removeAll(Collection<Consumer<T>> var1);
}

