/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.Validation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyKey {
    private static final Pattern PATTERN = Pattern.compile("^([\\w-]+)(\\[([1-9]\\d*|0)])?$");
    private final String actualKey;
    private final boolean isArray;
    private final int arrayIndex;

    public PropertyKey(String key) {
        Validation.notBlank(key, "Property key cannot be blank.", new Object[0]);
        Matcher matcher = PATTERN.matcher(key);
        Validation.isTrue(matcher.matches(), "Illegal property key pattern. [key={0}]", key);
        this.actualKey = matcher.group(1);
        String index = matcher.group(3);
        if (index != null) {
            this.isArray = true;
            this.arrayIndex = Integer.parseInt(index);
        } else {
            this.isArray = false;
            this.arrayIndex = -1;
        }
    }

    public String getActualKey() {
        return this.actualKey;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }
}

