/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.FunctionUtils;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.AbstractZip;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip
extends AbstractZip<Zip> {
    private static final String ENTRY_SEPARATOR = "/";
    private final List<File> targets = new ArrayList<File>();
    private Predicate<File> predicate;

    public Zip(File zipFile, Charset charset) {
        super(zipFile, charset);
    }

    public Zip add(File target) {
        Validation.notNull(target, "The file to zip cannot be null.", new Object[0]);
        this.targets.add(target);
        return this;
    }

    public Zip filter(Predicate<File> predicate) {
        this.predicate = FunctionUtils.and(this.predicate, predicate);
        return this;
    }

    @Override
    public void start() throws IOException {
        this.deleteZipFile();
        try (FileOutputStream out = new FileOutputStream(this.file());
             ZipOutputStream zip = new ZipOutputStream((OutputStream)out, this.charset());){
            for (File target : this.targets) {
                this.zip(zip, target);
            }
        }
    }

    private void deleteZipFile() throws IOException {
        if (this.file().exists()) {
            if (this.override()) {
                Files.delete(this.file().toPath());
            } else {
                throw new IOException(StringUtils.format("The output file of zip already exists. [name={0}]", this.file().getName()));
            }
        }
    }

    private boolean filter(File file) {
        return FunctionUtils.test(this.predicate, file, true);
    }

    private String getEntryName(File target) {
        return target.isDirectory() ? target.getName() + ENTRY_SEPARATOR : target.getName();
    }

    private void zip(ZipOutputStream zip, File target) throws IOException {
        this.zip(zip, target, this.getEntryName(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zip(ZipOutputStream zip, File target, String entryName) throws IOException {
        if (!this.filter(target)) {
            return;
        }
        BasicFileAttributeView view = Files.getFileAttributeView(target.toPath(), BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        BasicFileAttributes attributes = view.readAttributes();
        zip.putNextEntry(new ZipEntry(entryName).setCreationTime(attributes.creationTime()).setLastModifiedTime(attributes.lastModifiedTime()).setLastAccessTime(attributes.lastAccessTime()));
        if (target.isDirectory()) {
            zip.closeEntry();
            this.zip(zip, FileUtils.list(target), entryName);
            return;
        }
        try {
            IoUtils.copy(target, (OutputStream)zip);
        }
        finally {
            zip.closeEntry();
        }
    }

    private void zip(ZipOutputStream zip, List<File> targets, String path) throws IOException {
        for (File target : targets) {
            this.zip(zip, target, path + this.getEntryName(target));
        }
    }
}

