/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack;

import com.huawei.ism.tool.bizpack.IProcessEnvCreator;
import com.huawei.ism.tool.bizpack.IProcessFilter;
import com.huawei.ism.tool.bizpack.IProcessListener;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.ProcessInstance;
import com.huawei.ism.tool.bizpack.support.ProcessExecutor;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceBuilder.class);
    private List<IProcessListener> processListeners = new ArrayList<IProcessListener>();
    private IProcessEnvCreator envCreator = null;
    private List<String> scriptPaths = new ArrayList<String>();
    private List<IProcessFilter> processFilters = new ArrayList<IProcessFilter>();

    public void addProcessListener(IProcessListener listener) {
        this.processListeners.add(listener);
    }

    public void setEnvCreator(IProcessEnvCreator envCreator) {
        this.envCreator = envCreator;
    }

    public void addProcessFilter(IProcessFilter filter) {
        this.processFilters.add(filter);
    }

    public void addScriptPath(List<String> pythonPaths) {
        this.scriptPaths.addAll(pythonPaths);
    }

    public ProcessInstance construct(ProcessInfo processInfo) throws ToolException {
        ProcessInstance instance = new ProcessInstance(processInfo);
        instance.setProcessEnv(this.envCreator.createEnv(processInfo.getEnvParamNames()));
        instance.setExecutor(this.createProcessExecutor(processInfo.getScriptPath()));
        instance.addProcessListeners(this.processListeners);
        instance.setProcessFilters(this.processFilters);
        return instance;
    }

    private ProcessExecutor createProcessExecutor(String bizScriptPath) {
        ArrayList<File> scriptDirs = new ArrayList<File>();
        if (!this.scriptPaths.contains(bizScriptPath)) {
            this.scriptPaths.add(bizScriptPath);
        }
        for (String scriptPath : this.scriptPaths) {
            File scriptDir;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("python script path:" + scriptPath);
            }
            if (!(scriptDir = new File(scriptPath)).exists() || !scriptDir.isDirectory()) continue;
            scriptDirs.add(scriptDir);
        }
        ProcessExecutor executor = new ProcessExecutor(scriptDirs);
        return executor;
    }
}

