/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.parse;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.parse.ConfigParser;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageConfigParser
implements ConfigParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageConfigParser.class);
    private static final String PACKAGE_NAME_KEY = "package.name";
    private static final String PACKAGE_VERSION_KEY = "package.version";
    private static final String PACKAGE_TYPE_KEY = "package.type";
    private static final String PACKAGE_DATE_KEY = "date";
    private File iniConfigFile = null;

    public PackageConfigParser(File iniFile) {
        this.iniConfigFile = iniFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean parse(BizPackage bizPackage) {
        boolean bl;
        if (!this.iniConfigFile.exists() || this.iniConfigFile.isDirectory()) {
            return false;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.iniConfigFile);
            Properties pro = new Properties();
            pro.load(is);
            bizPackage.setName(pro.getProperty(PACKAGE_NAME_KEY));
            bizPackage.setType(pro.getProperty(PACKAGE_TYPE_KEY));
            bizPackage.setVersion(pro.getProperty(PACKAGE_VERSION_KEY));
            String dateString = pro.getProperty(PACKAGE_DATE_KEY);
            if (!StringUtils.isNULLStr((String)dateString)) {
                Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateString);
                bizPackage.setPublishDate(date);
            }
            bl = true;
        }
        catch (IOException e) {
            LOGGER.error("package.ini file io failed!!!!", (Throwable)e);
            boolean bl2 = false;
            StreamUtils.closeStream(null, is);
            return bl2;
        }
        catch (ParseException e2) {
            LOGGER.error("pacakge.ini publish date format error.", (Throwable)e2);
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, is);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, is);
            return bl3;
        }
        StreamUtils.closeStream(null, is);
        return bl;
    }
}

