/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.entity;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConditionCfg;
import com.huawei.ism.tool.bizpack.wizardparse.entity.ProcessStepType;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink.GuideLink;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink.GuideLinkGroup;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class BizStepConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BizStepConfig.class);
    private static final Dimension DEFAULT_DEVGRAPH_SIZE = new Dimension(250, 525);
    private String description;
    private String id;
    private String processId = "";
    private String insertPoint = "";
    private String mainMethod = "";
    private boolean failExit = true;
    private String scriptFile = "";
    private String cancelScript = "";
    private ProcessStepType type;
    private String title = "";
    private String prompt = "";
    private String tailPrompt = "";
    private String promise = "";
    private String stepClazPathName = "";
    private boolean backward = true;
    private String param = "";
    private boolean auto = false;
    private GuideLinkGroup guideLinkGroup = new GuideLinkGroup();
    private BizStepConditionCfg conditionCfg = new BizStepConditionCfg();
    private boolean needDeviceGraph = false;
    private Dimension devGraphSize;
    private Dimension wizardSize;
    private Map<String, Object> allAtributeMap = null;
    private boolean onceCheckAll;

    public boolean isOnceCheckAll() {
        return this.onceCheckAll;
    }

    public void setOnceCheckAll(boolean onceCheckAll) {
        this.onceCheckAll = onceCheckAll;
    }

    public abstract void loadConfig(Element var1);

    public Map<String, Object> getAllAtributeMap() {
        return this.allAtributeMap;
    }

    public void setAllAtributeMap(Map<String, Object> allAtributeMap) {
        this.allAtributeMap = allAtributeMap;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isFailExit() {
        return this.failExit;
    }

    public void setFailExit(boolean failExit) {
        this.failExit = failExit;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Dimension getWizardSize() {
        return this.wizardSize;
    }

    public void setWizardSize(Dimension wizardSize) {
        this.wizardSize = wizardSize;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMainMethod() {
        return this.mainMethod;
    }

    public void setMainMethod(String mainMethod) {
        this.mainMethod = mainMethod;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFilePath) {
        this.scriptFile = scriptFilePath;
    }

    public ProcessStepType getType() {
        return this.type;
    }

    public void setType(ProcessStepType type) {
        this.type = type;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPromise() {
        return this.promise;
    }

    public void setPromise(String promise) {
        this.promise = promise;
    }

    public String getStepClazPathName() {
        return this.stepClazPathName;
    }

    public void setStepClazPathName(String stepClazPathName) {
        this.stepClazPathName = stepClazPathName;
    }

    protected String getAttribute(Element element, String attriName, String defaultValue) {
        String attribute = element.getAttribute(attriName);
        if (StringUtils.isNULLStr((String)attribute)) {
            attribute = defaultValue;
        }
        return attribute.trim();
    }

    protected Map<String, Object> getAllAtributeMap(Element element) {
        NamedNodeMap namedAttrMap = element.getAttributes();
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        for (int j = 0; j < namedAttrMap.getLength(); ++j) {
            Node node = namedAttrMap.item(j);
            attrMap.put(node.getNodeName(), node.getNodeValue());
        }
        return attrMap;
    }

    protected void parseGuideLink(Element node) {
        List<GuideLink> links = this.getGuideLinkGroup().getLinks();
        Element docNode = XmlUtils.getChild(node, "doc");
        if (null != docNode) {
            String showInContextStr = this.getAttribute(docNode, "showInContext", "");
            this.getGuideLinkGroup().setShowInContext("true".equals(showInContextStr));
        }
        Collection<Element> docItems = XmlUtils.getChildren(docNode, "doc-item");
        for (Element docItem : docItems) {
            String name = this.getAttribute(docItem, "name", "");
            String url = this.getAttribute(docItem, "url", "");
            String linkScript = this.getAttribute(docItem, "linkScript", "");
            String linkScriptParam = this.getAttribute(docItem, "param", "");
            GuideLink link = new GuideLink(name);
            link.setName(name);
            if ("".equals(linkScript)) {
                link.setUrl(url);
            } else {
                link.setSelfDefine(true);
                link.setLinkScript(linkScript);
                link.setLinkScriptParam(linkScriptParam);
            }
            links.add(link);
        }
    }

    protected void parseDeviceGraph(Element node) {
        String needDeviceGraphStr = this.getAttribute(node, "needDeviceGraph", "");
        if (needDeviceGraphStr.equalsIgnoreCase("true")) {
            this.setNeedDeviceGraph(true);
        }
        String devGraphSizeStr = this.getAttribute(node, "devGraphSize", "");
        Dimension size = DEFAULT_DEVGRAPH_SIZE;
        try {
            if (!StringUtils.isNULLStr((String)devGraphSizeStr)) {
                String[] sizeList = devGraphSizeStr.split(",");
                int xi = Integer.parseInt(sizeList[0].trim());
                int yi = Integer.parseInt(sizeList[1].trim());
                size = new Dimension(xi, yi);
            }
        }
        catch (Exception e) {
            LOGGER.error("Load Dev Graph Size ERR", (Throwable)e);
            size = DEFAULT_DEVGRAPH_SIZE;
        }
        this.setDevGraphSize(size);
    }

    protected void parseConditionCfg(Element node) {
        Element conNode = XmlUtils.getChild(node, "condition");
        if (null == conNode) {
            return;
        }
        String conScript = this.getAttribute(conNode, "script", "");
        String conScriptparam = this.getAttribute(conNode, "param", "");
        this.conditionCfg.setHasCondition(true);
        this.conditionCfg.setScript(conScript);
        this.conditionCfg.setParam(conScriptparam);
    }

    protected void parseCommon(Element node) {
        this.parseGuideLink(node);
        this.parseConditionCfg(node);
        this.parseDeviceGraph(node);
    }

    protected void setBackwardValue(String backwardStr) {
        if (backwardStr.equals("disable")) {
            this.setBackward(false);
        } else {
            this.setBackward(true);
        }
    }

    public boolean isBackward() {
        return this.backward;
    }

    public void setBackward(boolean backward) {
        this.backward = backward;
    }

    public String getCancelScript() {
        return this.cancelScript;
    }

    public void setCancelScript(String cancelScript) {
        this.cancelScript = cancelScript;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public GuideLinkGroup getGuideLinkGroup() {
        return this.guideLinkGroup;
    }

    public void setGuideLinkGroup(GuideLinkGroup guideLinkGroup) {
        this.guideLinkGroup = guideLinkGroup;
    }

    public BizStepConditionCfg getConditionCfg() {
        return this.conditionCfg;
    }

    public void setConditionCfg(BizStepConditionCfg conditionCfg) {
        this.conditionCfg = conditionCfg;
    }

    public boolean isNeedDeviceGraph() {
        return this.needDeviceGraph;
    }

    public void setNeedDeviceGraph(boolean needDeviceGraph) {
        this.needDeviceGraph = needDeviceGraph;
    }

    public Dimension getDevGraphSize() {
        return this.devGraphSize;
    }

    public void setDevGraphSize(Dimension devGraphSize) {
        this.devGraphSize = devGraphSize;
    }

    public String getTailPrompt() {
        return this.tailPrompt;
    }

    public void setTailPrompt(String tailPrompt) {
        this.tailPrompt = tailPrompt;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getInsertPoint() {
        return this.insertPoint;
    }

    public void setInsertPoint(String insertPoint) {
        this.insertPoint = insertPoint;
    }
}

