/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.factory;

import com.huawei.common.devmgr.DeviceLocator;
import com.huawei.ism.tool.bizpack.wizardparse.factory.RestConnector;
import com.huawei.ism.tool.bizpack.wizardparse.factory.SftpConnector;
import com.huawei.ism.tool.bizpack.wizardparse.factory.SshConnector;
import com.huawei.ism.tool.bizpack.wizardparse.factory.SshForwardConnector;
import com.huawei.ism.tool.bizpack.wizardparse.factory.TlvConnector;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import java.util.List;

public final class ConnectorFactory {
    private static final ConnectorFactory INSTANCE = new ConnectorFactory();

    private ConnectorFactory() {
    }

    public static ConnectorFactory getInstance() {
        return INSTANCE;
    }

    public SshForwardConnector createSshForwardConnector(DevNode dev) {
        return new SshForwardConnector(dev);
    }

    public SshConnector createSshConnector(String sshHostname, int port, String username, String password) {
        return new SshConnector(sshHostname, port, username, password);
    }

    public TlvConnector createTlvConnector(String ip, int port, String username, String password, Boolean isSSL) {
        return new TlvConnector(ip, port, username, password, isSSL);
    }

    public TlvConnector createTlvConnectorSVP(String svpIp, String svpPort, String svpSession, String deviceType, String sn) {
        return new TlvConnector(svpIp, svpPort, svpSession, deviceType, sn);
    }

    public TlvConnector createTlvConnector(List<String> ipList, int port, String username, String password, Boolean isSSL) {
        return new TlvConnector(ipList, port, username, password, isSSL);
    }

    public TlvConnector createTlvConnector(String ip, int port, String username, String password, String sslVersion) {
        return new TlvConnector(ip, port, username, password, sslVersion);
    }

    public TlvConnector createTlvConnector(List<String> ipList, int port, String username, String password, String sslVersion) {
        return new TlvConnector(ipList, port, username, password, sslVersion);
    }

    public TlvConnector createForwardTlvConnector(DevNode dev) {
        return new TlvConnector(dev);
    }

    public SftpConnector createSftpConnector(String ip, int port, String username, String password) {
        DevNode devNode = DeviceLocator.getDevNodeByKey((String)ip);
        if (devNode != null) {
            return new SftpConnector(EntityUtils.toOldDev((DevNode)devNode));
        }
        return new SftpConnector(ip, port, username, password);
    }

    public SftpConnector createSftpConnector(String ip, int port, String username, String password, String sn) {
        DevNode devNode = DeviceLocator.getDevNodeByKey((String)ip);
        if (devNode != null) {
            return new SftpConnector(EntityUtils.toOldDev((DevNode)devNode));
        }
        return new SftpConnector(ip, port, username, password, sn);
    }

    public SftpConnector createSftpConnector(DevNode devNode) {
        return new SftpConnector(EntityUtils.toOldDev((DevNode)devNode));
    }

    public SftpConnector createSftpConnector(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return new SftpConnector(devNode);
    }

    @Deprecated
    public RestConnector createRestConnector(String uri, String username, String password, String scope) {
        return new RestConnector(uri, username, password, scope);
    }
}

