/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.task;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.parse.CheckItemPlatformAdapterInBizPackage;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.task.TaskManager;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.DoItemsUiObserver;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoItemsTask
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoItemsTask.class);
    private DevNode devNode;
    private List<Item> items = null;
    private DoItemsUiObserver obser = null;
    private String doScriptPath = "";
    private JythonContext ssEnv;
    private int startIndex;
    private int endIndex;

    public DoItemsTask(List<Item> items, DoItemsUiObserver obser, String doScriptPath, int startIndex) {
        this.items = items;
        this.obser = obser;
        this.doScriptPath = doScriptPath;
        this.startIndex = startIndex;
        this.ssEnv = BizPackageContext.getInstance().getJythonContext();
        this.devNode = BizPackageContext.getInstance().getJythonContext().getDevNode();
    }

    public DoItemsTask(List<Item> items, DoItemsUiObserver obser, String doScriptPath, JythonContext context, DevNode devNode) {
        this(items, obser, doScriptPath, 0);
        this.ssEnv = context;
        this.devNode = devNode;
    }

    @Override
    public void run() {
        boolean onceCheckAll;
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        BizStepConfig stepConfig = BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(BizPackageContext.getInstance().getCurStepId());
        boolean bl = onceCheckAll = stepConfig != null ? stepConfig.isOnceCheckAll() : false;
        if (BizPackageContext.getInstance().getCurBizWizardCfg().isOnlyExecutePsdk()) {
            onceCheckAll = true;
        }
        JythonExecuter jythonExecuter = new JythonExecuter(new File(this.doScriptPath));
        this.ssEnv.getDict().put("logger", LOGGER);
        String pyDir = this.getScriptDir();
        for (int i = this.startIndex; i < this.items.size(); ++i) {
            Item item = this.items.get(i);
            boolean showDetail = item.isShowDetail();
            QueryItemDetailTask qryItemDetailThread = null;
            if (showDetail) {
                qryItemDetailThread = new QueryItemDetailTask();
                qryItemDetailThread.setUncaughtExceptionHandler((thd, throwable) -> LOGGER.error("thread {} execute error.", (Object)thd.getName(), (Object)throwable));
                qryItemDetailThread.start();
            }
            boolean execResult = this.execOneItem(jythonExecuter, item, pyDir, resource, i);
            if (null != qryItemDetailThread) {
                qryItemDetailThread.cancel();
            }
            if (!execResult && !onceCheckAll) {
                String itemDesc = StringUtils.isNULLStr(item.getParam()) ? item.getId() : item.getId() + ":" + item.getParam();
                BizPackageContext.getInstance().getBizpackageUserOpData().getFailedItems().add(itemDesc);
                break;
            }
            ++this.endIndex;
        }
        if (this.endIndex + this.startIndex == this.items.size()) {
            this.obser.fireAllFinish();
        }
        this.removeTask();
    }

    private void removeTask() {
        if (this.items != null && this.items.size() == 1) {
            TaskManager.removeFinishedTask(this.items.get(0).getTitle());
        }
    }

    private boolean execOneItem(JythonExecuter jythonExecuter, Item item, String pyDir, PackagesResource resource, int curIndex) {
        String itemDesc = StringUtils.isNULLStr(item.getParam()) ? item.getId() : item.getId() + ":" + item.getParam();
        BizPackageContext.getInstance().getBizpackageUserOpData().getEachItemStratTime().put(String.valueOf(DateUtil.toBeiJingTimeMillis(new Date())), itemDesc);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("item title:" + item.getTitle());
        }
        String pyName = item.getScriptName();
        String pyPath = pyDir + File.separator + pyName;
        boolean isFromJar = false;
        File pyFile = new File(pyPath);
        this.obser.setCurrentStatusTxt(item.getTitleRes(resource) + "...");
        if (BizPackageSceneUtils.isFruEvalScene()) {
            this.obser.setCurrentStatusIcon(resource.getImage("loading.gif"));
        }
        this.setObserDescTxt(item, resource);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("CurIndex:" + curIndex);
        }
        Date date = new Date();
        item.setDate(date);
        this.obser.refreshItemLoading(item, curIndex);
        String param = item.getParam();
        LOGGER.info("after refresh....");
        if (BizPackageContext.getInstance().getCurBizWizardCfg().isOnlyExecutePsdk()) {
            return !this.clearProgressInfo(jythonExecuter, item, curIndex, pyName, pyFile, date, param);
        }
        if (!pyFile.exists()) {
            LOGGER.info("jython File not found, will search in pyframe");
            pyFile = ExecPyUtils.getPyframeFile(pyName);
            if (pyFile == null) {
                this.obser.fireException(new FileNotFoundException(), item, curIndex);
                LOGGER.error("jython File not found");
                return false;
            }
        }
        return !this.clearProgressInfo(jythonExecuter, item, curIndex, pyName, pyFile, date, param);
    }

    private boolean clearProgressInfo(JythonExecuter jythonExecuter, Item item, int curIndex, String pyName, File pyFile, Date date, String param) {
        try {
            this.ssEnv.getDict().put("curProgressPer", null);
            this.ssEnv.getDict().put("remainTime", null);
            this.ssEnv.getDict().put("detailInfo", null);
            Thread.sleep(200L);
            if (item.getConfigItem() != null) {
                CheckItemPlatformAdapterInBizPackage.getInstance().runConfigItem(this.devNode, item, this.ssEnv.getDict());
            } else {
                LOGGER.info("compile.....");
                boolean isFromJar = ExecPyUtils.isJarFile(pyName);
                if (isFromJar) {
                    jythonExecuter.compileScriptWithoutSign(pyFile);
                } else {
                    jythonExecuter.compileScript(pyFile);
                }
                this.ssEnv.clearMsgData();
                this.excJython(jythonExecuter, param);
                LOGGER.info("complete.....");
                boolean reslult = (Boolean)this.ssEnv.getDict().get("succ");
                this.execJython(jythonExecuter, item, param, reslult);
            }
            item.setDate(date);
            this.obser.fireFinish(item, curIndex);
            if (!((Boolean)this.ssEnv.getDict().get("succ")).booleanValue()) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            this.obser.fireException(new FileNotFoundException("jython File not found"), item, curIndex);
            LOGGER.error("jython File {} not found", (Object)pyFile.getName());
            return true;
        }
        catch (SignException e) {
            this.obser.fireException(e, item, curIndex);
            LOGGER.error("python file has no sign", (Throwable)e);
            return true;
        }
        catch (ToolException e) {
            this.obser.fireException((Exception)((Object)e), item, curIndex);
            LOGGER.error("jython exec err", (Throwable)e);
            return true;
        }
        catch (Exception e) {
            this.obser.fireException(e, item, curIndex);
            LOGGER.error(item.getTitle() + " occur exception...", (Throwable)e);
            return true;
        }
        return false;
    }

    private void execJython(JythonExecuter jythonExecuter, Item item, String param, boolean reslult) throws ToolException {
        String checkItemTitle;
        if (!(reslult || !(checkItemTitle = item.getTitle()).equals("manageBoard.postcheck.checkHealth.title") && !checkItemTitle.equals("manageBoard.postcheck.checkManageCable.title") && !checkItemTitle.contains("controller.precheck") || checkItemTitle.contains("serviceProtocolCheck") || checkItemTitle.contains("nvmeFruRiskChk") || checkItemTitle.contains("businessPress"))) {
            LOGGER.info("retry exc the item......");
            this.excJython(jythonExecuter, param);
        }
    }

    private void setObserDescTxt(Item item, PackagesResource resource) {
        if ("".equals(item.getDesc().trim())) {
            this.obser.setCurrentDescTxt("");
        } else {
            this.obser.setCurrentDescTxt(item.getDescRes(resource));
        }
    }

    private void excJython(JythonExecuter jythonExecuter, String param) throws ToolException {
        if ("".equals(param.trim())) {
            LOGGER.info("zero.....");
            Object[] paramList = new Object[]{this.ssEnv.getDict()};
            jythonExecuter.invokeFunction("execute", paramList);
        } else {
            LOGGER.info("not ZROE....");
            jythonExecuter.invokeFunction("execute", new Object[]{this.ssEnv.getDict(), param});
        }
    }

    private String getScriptDir() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        String processPath = BizPackageContext.getInstance().getCurBizWizardCfg().getId();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append("process");
        scriptPath.append(File.separator);
        scriptPath.append(processPath);
        scriptPath.append(File.separator);
        scriptPath.append("script");
        return scriptPath.toString();
    }

    private class QueryItemDetailTask
    extends Thread {
        private volatile boolean isCancelled = false;

        private QueryItemDetailTask() {
        }

        @Override
        public void run() {
            String id = "qryDetailTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("qryDetailTask id[" + id + "] start");
            }
            while (!this.isCancelled) {
                String detailInfo = (String)DoItemsTask.this.ssEnv.getDict().get("detailInfo");
                if (null != detailInfo) {
                    DoItemsTask.this.obser.setCurrentDescTxt(detailInfo);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("detail info:" + detailInfo);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("query item detail info sleep err", (Throwable)e);
                }
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("qryDetailTask id[" + id + "] end");
            }
        }

        public void cancel() {
            this.isCancelled = true;
        }
    }
}

