/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink.OpenChmTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.PicDialog;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideLink {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuideLink.class);
    private static final String PROCESS = "Process";
    private static final String INIT_EXEC = "execute";
    private static final String CHM_CMD = "hh.exe ";
    private static final String CHM = ".chm";
    private static final ImageIcon BOOK = ResourceUtil.getImage("book_open.png");
    private static final Font TITLE_FONT_ZH = new Font("\u5b8b\u4f53", 0, 14);
    private static final Font TITLE_FONT_EN = new Font("Arail", 0, 14);
    private static final String HTML = ".html";
    private static final String LINE_DOWN = "_";
    private static final String IMAGE_LINK = "#imagelink#";
    private static final int CHM_CMD_TIME = 2;
    private String name = "";
    private String url = "";
    private String linkScript = "";
    private String getLinkErrMsg = "";
    private Window parent = null;
    private String linkScriptParam = "";
    private boolean selfDefine = false;
    private ToolHyperLinkLabel linkLabel = new ToolHyperLinkLabel();
    private PackagesResource util;
    private Boolean isFirstTimeInit = true;
    private String lan = LanguageManager.getInstance().getCurrentLanguage().getLanguage();

    public GuideLink() {
        this.linkLabel.setIcon((Icon)BOOK);
        Locale localeLanguage = LanguageManager.getInstance().getCurrentLanguage();
        UiMethod.setFont((JComponent)this.linkLabel, (Font)TITLE_FONT_EN, (Font)TITLE_FONT_ZH, (Locale)localeLanguage);
        this.util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
    }

    public GuideLink(String name) {
        this.linkLabel.setIcon((Icon)BOOK);
        Locale localeLanguage = LanguageManager.getInstance().getCurrentLanguage();
        UiMethod.setFont((JComponent)this.linkLabel, (Font)TITLE_FONT_EN, (Font)TITLE_FONT_ZH, (Locale)localeLanguage);
        this.util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        AutomateUtils.setNameAttribute((Component)this.linkLabel, name);
    }

    public void initListener() {
        if (!this.isFirstTimeInit.booleanValue()) {
            return;
        }
        StringBuilder urlPath = new StringBuilder();
        urlPath.append(BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath());
        urlPath.append(File.separator);
        urlPath.append("res");
        urlPath.append(File.separator);
        urlPath.append(this.url);
        urlPath.append(LINE_DOWN);
        urlPath.append(this.lan);
        urlPath.append(HTML);
        final String urlPathStr = urlPath.toString();
        this.linkLabel.addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = 5622923149032824799L;

            public void clickLink(MouseEvent e) {
                BizPackageContext.getInstance().getBizpackageUserOpData().getCheckedGuideFile().add(GuideLink.this.name);
                new Thread(new OpenChmTask(GuideLink.this, urlPathStr)).start();
            }
        });
        this.isFirstTimeInit = false;
    }

    public void clickLink() {
        StringBuilder urlPath = new StringBuilder();
        urlPath.append(BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath());
        urlPath.append(File.separator);
        urlPath.append("res");
        urlPath.append(File.separator);
        urlPath.append(this.url);
        urlPath.append(LINE_DOWN);
        urlPath.append(this.lan);
        urlPath.append(HTML);
        String urlPathStr = urlPath.toString();
        BizPackageContext.getInstance().getBizpackageUserOpData().getCheckedGuideFile().add(this.name);
        new Thread(new OpenChmTask(this, urlPathStr)).start();
    }

    void selfDefineResponse() {
        this.getLinkErrMsg = "";
        if (this.execInitScript(this.linkScript, this.linkScriptParam)) {
            JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
            if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
                this.getLinkErrMsg = (String)ssEnv.getDict().get("errMsg");
                DialogUtils.showErrorDialog((Window)this.parent, (String)this.getLinkErrMsg);
            } else {
                this.url = (String)ssEnv.getDict().get("doc_link");
                this.executeChmLink();
            }
        } else {
            if ("".equals(this.getLinkErrMsg)) {
                this.getLinkErrMsg = ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr");
            }
            DialogUtils.showErrorDialog((Window)this.parent, (String)this.getLinkErrMsg);
        }
    }

    private void executeChmLink() {
        String contentUrl = this.url;
        int type = 0;
        if (this.url.startsWith(IMAGE_LINK)) {
            String imgPath;
            type = 3;
            String jsonStr = this.url.replace(IMAGE_LINK, "").trim();
            JSONObject json = new JSONObject(jsonStr);
            contentUrl = imgPath = json.getString("imagepath");
            this.openPicDialog(json);
        } else if (this.url.contains(CHM)) {
            type = 2;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("cmd=hh.exe " + this.url);
            }
            OSCmdUtils.exeExportByCmd(CHM_CMD + this.url, 2);
        } else if (this.url.contains(HTML)) {
            type = 1;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("cmd=" + this.url);
            }
            OSCmdUtils.explorerFile(this.url);
        } else {
            LOGGER.error("execute cmd err,url=" + this.url);
        }
        if (BizPackageSceneUtils.isScene() && 0 != type) {
            BizPackageSceneUtils.openDataRecord(new Date(), contentUrl, StringUtils.toString(type));
        }
    }

    private void openPicDialog(JSONObject json) {
        String imgPath = json.getString("imagepath");
        String imgStartPath = json.getString("startimagepath");
        int height = Integer.parseInt(json.getString("dialogheight"));
        int width = Integer.parseInt(json.getString("dialogwidth"));
        String title = json.getString("dialogtitle");
        String imageDesc = "";
        try {
            imageDesc = json.getString("dialogdesc");
        }
        catch (JSONException e) {
            LOGGER.error("no description about image.");
        }
        PicDialog dialog = new PicDialog(title, imageDesc, new Dimension(width, height), imgPath, imgStartPath, BizPackageContext.getInstance().getWizard());
        dialog.setVisible(true);
    }

    private boolean execInitScript(String pyName, String param) {
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        ssEnv.clearMsgData();
        String processPath = this.getScriptLinkPath();
        try {
            ExecPyScriptTask pyTask = new ExecPyScriptTask(processPath, pyName);
            return pyTask.execFunc(INIT_EXEC, param);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("jython File not found");
            this.getLinkErrMsg = ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound");
            return false;
        }
        catch (SignException e) {
            LOGGER.error("python file has no sign", (Throwable)e);
            this.getLinkErrMsg = ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned");
            return false;
        }
    }

    private String getScriptLinkPath() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append(PROCESS);
        return scriptPath.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.linkLabel.setText(this.util.getString(name));
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ToolHyperLinkLabel getLinkLabel() {
        return this.linkLabel;
    }

    public String getLinkScript() {
        return this.linkScript;
    }

    public void setLinkScript(String linkScript) {
        this.linkScript = linkScript;
    }

    public String getLinkScriptParam() {
        return this.linkScriptParam;
    }

    public void setLinkScriptParam(String linkScriptParam) {
        this.linkScriptParam = linkScriptParam;
    }

    public boolean isSelfDefine() {
        return this.selfDefine;
    }

    public void setSelfDefine(boolean selfDefine) {
        this.selfDefine = selfDefine;
    }

    public String getGetLinkErrMsg() {
        return this.getLinkErrMsg;
    }

    public void setGetLinkErrMsg(String getLinkErrMsg) {
        this.getLinkErrMsg = getLinkErrMsg;
    }

    public Window getParent() {
        return this.parent;
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }
}

