/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.action.AddDeviceAction;
import com.huawei.ism.tool.bizpack.wizardparse.ui.action.ConfirmAction;
import com.huawei.ism.tool.bizpack.wizardparse.ui.action.QuerySupportProductAction;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectDeviceDialogLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.ParseAllProductsWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDeviceDialog
extends JDialog
implements INodeObserver,
IAutoProcess {
    private static final long serialVersionUID = -7550006512520040055L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectDeviceDialog.class);
    private static final Dimension DIALOG_SIZE_550X651 = new Dimension(550, 651);
    private static final String PNG = ".png";
    private SelectDeviceDialogLayout sddLayout = new SelectDeviceDialogLayout();
    private List<ArrayList<Object>> failRet = new ArrayList<ArrayList<Object>>();
    private Map<String, String> failMap = new HashMap<String, String>();
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();

    public SelectDeviceDialog(Window parent) {
        super(parent);
        this.setLayout(new BorderLayout());
        this.add((Component)this.sddLayout, "Center");
        this.setTitle(ResourceUtil.getString("bizpack.selectdevice.title"));
        String toolName = BizPackageContext.getInstance().getCurToolName();
        if (BizPackageContext.getInstance().isSelfDefine()) {
            this.setIconImage(BizPackageContext.getInstance().getMultiModeRuningImg().getImage());
        } else {
            this.setIconImage(ResourceUtil.getImage(toolName + PNG).getImage());
        }
        this.sddLayout.getConfirmButton().setEnabled(false);
        this.initListener();
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE_550X651, (Component[])new Component[]{this});
    }

    public void loadProducts() {
        try {
            List fs = AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{new ParseAllProductsWaitDialog()});
            Boolean markSign = (Boolean)fs.get(0);
            if (!markSign.booleanValue()) {
                DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString("bizpackage.error.parseproductsfailed"));
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("loadProducts faild" + e);
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString("bizpackage.error.parseproductsfailed"));
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectDeviceDialog.this.initDefaultTableData();
            }
        });
    }

    @Override
    public void requestFocus() {
        this.sddLayout.getConfirmButton().requestFocus();
    }

    public List<DevNode> getDevManagerList() {
        IDeviceManage devMng = PublicServiceManage.getInstance().getService(IDeviceManage.class);
        if (null == devMng) {
            LOGGER.error("get DeviceManage =NULL");
            return new ArrayList<DevNode>();
        }
        List<DevNode> devs = devMng.getNodeList();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("devs num=" + devs.size());
        }
        this.filterDevices(devMng, devs);
        return devs;
    }

    private void filterDevices(IDeviceManage devMng, List<DevNode> devs) {
        BizPackageContext context = BizPackageContext.getInstance();
        String errorMes = "";
        Iterator<DevNode> iter = devs.iterator();
        while (iter.hasNext()) {
            boolean isDevSsh;
            String toolName;
            DevNode dev = iter.next();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("devs ip=" + dev.getIp());
            }
            if (!context.isSupportDev(dev)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("devs ip=" + dev.getIp() + "is ignored");
                }
                iter.remove();
                if (!devMng.deleteOneDevice(dev.getIp())) {
                    LOGGER.error("not support and delete one device[" + dev.getIp() + "] in devMng failed");
                }
            }
            if ((toolName = UserOpDataSaveUtil.getToolIniProp("tool.name")) == null) {
                toolName = "";
            }
            boolean isFruTool = UserOpDataSaveUtil.FRU_TOOL_NAMES.contains(toolName.toUpperCase(Locale.ENGLISH));
            boolean isDevSocks5 = dev.getSocks5Proxy() != null;
            boolean bl = isDevSsh = dev.getSshForwardList() != null && !dev.getSshForwardList().isEmpty();
            if (isFruTool || !isDevSocks5 && !isDevSsh) continue;
            errorMes = "";
            String string = errorMes = isDevSocks5 ? ResourceUtil.getString("devicemanager.layout.device.errormsg.reason.socket5") : "";
            if (errorMes.equals("")) {
                errorMes = ResourceUtil.getString("devicemanager.layout.device.errormsg.reason.ssh");
            }
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(dev.getIp());
            tmp.add(errorMes);
            this.failRet.add(tmp);
            this.failMap.put(dev.getIp(), errorMes);
            iter.remove();
            if (devMng.deleteOneDevice(dev.getIp())) continue;
            LOGGER.error("socket one device[" + dev.getIp() + "] in devMng failed");
        }
    }

    public void refreshDevTable() {
        this.sddLayout.getTableModel().removeAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectDeviceDialog.this.initDefaultTableData();
            }
        });
    }

    private void initDefaultTableData() {
        List<DevNode> devManagerdevs = this.getDevManagerList();
        for (DevNode node : devManagerdevs) {
            TableRow<?, ?> row = this.createRow(node);
            this.sddLayout.getTableModel().addRow(new TableRow[]{row});
        }
        if (!this.failRet.isEmpty()) {
            IDeviceManageUI connUi = PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
            boolean flag = connUi.showMultiInfoDialog(this, ResourceUtil.getString("devicemanager.layout.device.import.deviceadddialog.batcherror"), new String[]{ResourceUtil.getString("devicemanager.layout.device.errormsg.ip"), ResourceUtil.getString("devicemanager.layout.device.errormsg.reason")}, this.failMap);
            if (!flag) {
                LOGGER.error("show add device dialog err.");
            }
        }
        this.sceneSelectDev(devManagerdevs);
    }

    private void sceneSelectDev(List<DevNode> devManagerdevs) {
        int rowNum = 0;
        String toolId = BizPackageContext.getInstance().getCurToolName();
        for (DevNode node : devManagerdevs) {
            if (BizPackageSceneUtils.isScene() && BizPackageSceneUtils.sceneSelectDevNode(node.getDeviceSerialNumber(), toolId)) {
                this.sddLayout.getDeviceTable().addRowSelectionInterval(rowNum, rowNum);
            }
            ++rowNum;
        }
    }

    private TableRow<?, ?> createRow(DevNode node) {
        DefaultTableRow row = new DefaultTableRow(this.sddLayout.getTableHeader().length, (Object)node, (Object)node);
        int index = 0;
        if (ApplicationContext.getInstance().isOEM()) {
            row.setValueAt(index++, (Object)node.getOemModel());
        } else {
            row.setValueAt(index++, (Object)node.getDeviceType());
        }
        row.setValueAt(index++, (Object)node.getProductVersion());
        row.setValueAt(index++, (Object)new IpAddressStrategy(node.getIp()));
        row.setValueAt(index++, (Object)node.getDeviceName());
        row.setValueAt(index++, (Object)node.getDeviceSerialNumber());
        return row;
    }

    private void initListener() {
        if (!SceneUtils.isScene()) {
            this.sddLayout.getAddDeviceLink().addClickListener((ToolHyperLinkLabel.ClickListener)new AddDeviceAction(this));
        }
        this.sddLayout.getSupportProductList().addClickListener((ToolHyperLinkLabel.ClickListener)new QuerySupportProductAction(this));
        this.sddLayout.getConfirmButton().addActionListener(new ConfirmAction(this));
        this.sddLayout.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDeviceDialog.this.exitWindow();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectDeviceDialog.this.exitWindow();
            }
        });
        ListSelectionModel tableSelectModel = this.sddLayout.getDeviceTable().getSelectionModel();
        tableSelectModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (SelectDeviceDialog.this.sddLayout.getDeviceTable().getMarkedRows().isEmpty()) {
                    SelectDeviceDialog.this.sddLayout.getConfirmButton().setEnabled(false);
                } else {
                    SelectDeviceDialog.this.sddLayout.getConfirmButton().setEnabled(true);
                }
            }
        });
        IDeviceManage devMng = PublicServiceManage.getInstance().getService(IDeviceManage.class);
        devMng.addNodeObservers(this);
        new AutoProcessObserver((IAutoProcess)this);
        this.addComponentListener((ComponentListener)new AutoProcessListener((IAutoProcess)this));
    }

    private void exitWindow() {
        WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)this, (String)ResourceUtil.getString("bizpackage.desc.quite"));
        if (0 == wdialog.getValue()) {
            String toolId = BizPackageContext.getInstance().getCurToolName();
            ApplicationContext.getInstance().fireToolStopped(toolId);
        }
    }

    public SelectDeviceDialogLayout getSddLayout() {
        return this.sddLayout;
    }

    @Override
    public void fireNodeAdd(DevNode dev) {
        BizPackageContext context = BizPackageContext.getInstance();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("devs ip=" + dev.getIp());
        }
        if (!context.isSupportDev(dev)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("devs ip=" + dev.getIp() + "is ignored");
            }
            DialogUtils.showErrorDialog(null, (String)ResourceUtil.getString("bizpackage.error.product.notsupport"));
            return;
        }
        this.sddLayout.getTableModel().addRow(new TableRow[]{this.createRow(dev)});
    }

    @Override
    public void fireNodeDelete(DevNode dev) {
    }

    @Override
    public void fireNodeModify(DevNode dev) {
    }

    public void onStepDialogDisplayed() {
        this.sddLayout.getAddDeviceLink().getClickListener().clickLink(null);
        this.sddLayout.getDeviceTable().selectFirstRow();
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    public void onStepFinished(AutoProcessStatus status) {
        this.sddLayout.getConfirmButton().doClick();
    }

    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }
}

