/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizPackGroup;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.GroupTypePanel;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectGroupWizardDialogLayout
extends JPanel {
    public static final Font TITLE_FONT_ZH = new Font("\u5b8b\u4f53", 1, 13);
    public static final Font TITLE_FONT_EN = new Font("Arail", 1, 13);
    private static final long serialVersionUID = -940640230781370093L;
    private Locale locale = LanguageManager.getInstance().getCurrentLanguage();
    private List<ToolHyperLinkLabel> fruTitleList = new ArrayList<ToolHyperLinkLabel>();

    public SelectGroupWizardDialogLayout() {
        this.initUI();
    }

    private void initUI() {
        List<BizPackGroup> groups = BizPackageContext.getInstance().getCurBizPackage().getGroupList();
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(25));
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        boolean buildHorizotalReadyFlag = false;
        BizPackGroup leftGroup = null;
        for (BizPackGroup bizPackGroup : groups) {
            GroupTypePanel leftPanel;
            if (bizPackGroup.isSeperator()) {
                if (buildHorizotalReadyFlag) {
                    leftPanel = new GroupTypePanel(leftGroup);
                    this.fruTitleList.addAll(leftPanel.getFruTitleList());
                    this.add(UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(25), leftPanel, Box.createHorizontalGlue()}));
                    this.add(Box.createVerticalGlue());
                }
                JLabel titleLabel = new JLabel(resutil.getString(bizPackGroup.getDescription()));
                AutomateUtils.setNameAttribute(titleLabel, bizPackGroup.getTitle());
                UiMethod.setFont((JComponent)titleLabel, (Font)TITLE_FONT_EN, (Font)TITLE_FONT_ZH, (Locale)this.locale);
                this.add(UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(15), UCD.buildHorizontalBoxLeft((Component)titleLabel), Box.createHorizontalGlue()}));
                this.add(Box.createVerticalStrut(10));
                buildHorizotalReadyFlag = false;
                continue;
            }
            if (buildHorizotalReadyFlag) {
                leftPanel = new GroupTypePanel(leftGroup);
                this.fruTitleList.addAll(leftPanel.getFruTitleList());
                GroupTypePanel rightPanel = new GroupTypePanel(bizPackGroup);
                this.fruTitleList.addAll(rightPanel.getFruTitleList());
                this.fruTitleList.stream().filter(label -> "process.group.other.title.riskPower".equals(label.getName())).forEach(label -> label.setVisible(false));
                this.add(UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(25), leftPanel, rightPanel, Box.createHorizontalGlue()}));
                this.add(Box.createVerticalGlue());
                buildHorizotalReadyFlag = false;
                continue;
            }
            buildHorizotalReadyFlag = true;
            leftGroup = bizPackGroup;
        }
        if (buildHorizotalReadyFlag) {
            GroupTypePanel leftPanel = new GroupTypePanel(leftGroup);
            this.fruTitleList.addAll(leftPanel.getFruTitleList());
            this.add(UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(25), leftPanel, Box.createHorizontalGlue()}));
            this.add(Box.createVerticalGlue());
        }
    }

    public List<ToolHyperLinkLabel> getFruTitleList() {
        return this.fruTitleList;
    }
}

