/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectZoneDeviceDialogLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(SelectZoneDeviceDialogLayout.class);
    private static final Dimension DEFAULT_SIZE = new Dimension(550, 200);
    private IsmTable deviceTable;
    private DefaultTableModel deviceTableModel;
    private boolean isSingDev;
    private JButton cancelBtn;
    private JButton okBtn;
    private final String[] tableHeaders = new String[]{ResourceUtil.getString((String)"bizpack.selectdevice.zone.uuid"), ResourceUtil.getString((String)"bizpack.selectdevice.ipaddress"), ResourceUtil.getString((String)"bizpack.selectdevice.devmodel"), ResourceUtil.getString((String)"bizpack.selectdevice.productversion")};

    public SelectZoneDeviceDialogLayout(boolean isSingDev) {
        this.isSingDev = isSingDev;
        this.initComponent();
        this.layoutComponents();
    }

    public int getTableColumn() {
        return this.tableHeaders.length;
    }

    private void initComponent() {
        this.cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"bizpack.selectdevice.cancelButton"), (char)'G');
        this.okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"bizpack.selectdevice.confirmButton"), (char)'L');
        this.createDeviceTable();
    }

    private void createDeviceTable() {
        this.deviceTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.getDeviceTableModel());
    }

    private void layoutComponents() {
        JComponent descriptionArea = this.layoutDescrptionArea();
        JComponent tableArea = this.layoutTableArea();
        JComponent buttonArea = this.layoutButtonArea();
        JComponent contentArea = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionArea}), UCD.buildHorizotalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalGlue()}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{tableArea})}), buttonArea});
        this.setLayout(new BorderLayout());
        this.add(this.buildFrameSpace(contentArea, 20, 30, 15, 35));
    }

    private JComponent layoutDescrptionArea() {
        JLabel descriptionLabelA = new JLabel(ResourceUtil.getString((String)"bizpack.select.device"));
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionLabelA})});
    }

    private JComponent layoutTableArea() {
        TableScrollPane pane = TableScrollPane.createTablePane((IsmTable)this.getDeviceTable(), (!this.isSingDev ? 1 : 0) != 0);
        pane.setPreferredSize(DEFAULT_SIZE);
        return pane;
    }

    private JComponent buildFrameSpace(JComponent contentArea, int left, int right, int up, int down) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(left));
        hBox.add(contentArea);
        hBox.add(Box.createHorizontalStrut(right));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(up));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(down));
        return vBox;
    }

    private JComponent layoutButtonArea() {
        return UiMethod.buildCompsRight((Component[])new Component[]{this.okBtn, this.cancelBtn});
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public boolean isSingDev() {
        return this.isSingDev;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public String[] getTableHeaders() {
        return this.tableHeaders;
    }
}

