/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.settingdialog;

import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.GroupTypePanel;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectGroupWizardDialogLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.settingdialog.SelectGroupWizardSettingDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingContentPanel
extends JComponent {
    private static final Logger log = LoggerFactory.getLogger(SettingContentPanel.class);
    private static final int LABEL_HEIGHT = 15;
    private static final int LABEL_WIDTH_EN = 220;
    private static final int LABEL_WIDTH_ZH = 120;
    private static final int COM_WIDTH_EN = 145;
    private static final int COM_WIDTH_ZH = 145;
    private static final int COM_HEIGHT = 22;
    private final JTextArea decLabel = UCD.createTextArea((String)ResourceUtil.getString("bizpack.wizard.setting.desc"));
    private final JLabel checkDesc = UiMethod.createColonLabel((String)ResourceUtil.getString("biapack.wizard.setting.itemName"));
    private final JComboBox<String> switchOnOffComboBox = new JComboBox();
    private final JLabel riskPowerDesc = UiMethod.createColonLabel((String)ResourceUtil.getString("biapack.wizard.setting.risk.power.desc"));
    private final JComboBox<String> switchOnOffRiskPowerComboBox = new JComboBox();
    private final Dimension dimension = new Dimension(150, 22);

    public SettingContentPanel() {
        this.setLayout(new BorderLayout());
        this.decLabel.setEditable(false);
        this.initSwitch();
        this.initSize();
        JComponent buildVerticalBox = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.checkDesc, this.switchOnOffComboBox}), UCD.buildHBoxLeft((Component[])new Component[]{this.riskPowerDesc, this.switchOnOffRiskPowerComboBox})});
        this.add((Component)UCD.buildVerticalBox((Border)SwingUtil.getEmptyBorder(), (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.decLabel}), buildVerticalBox, Box.createVerticalGlue()}), "North");
    }

    private void initSize() {
        Dimension labelDi = null;
        Dimension comDi = null;
        if (Locale.ENGLISH.equals(ApplicationContext.getInstance().getCurrentLanguage())) {
            labelDi = new Dimension(220, 15);
            comDi = new Dimension(145, 22);
        } else {
            labelDi = new Dimension(120, 15);
            comDi = new Dimension(145, 22);
        }
        UCD.setJComponentSize((JComponent)this.checkDesc, (Dimension)labelDi);
        UCD.setJComponentSize(this.switchOnOffComboBox, (Dimension)comDi);
        UCD.setJComponentSize((JComponent)this.riskPowerDesc, (Dimension)labelDi);
        UCD.setJComponentSize(this.switchOnOffRiskPowerComboBox, (Dimension)comDi);
    }

    private void initSwitch() {
        this.initDefaultSwitch();
        this.initRiskPowerSwitch();
    }

    private void initDefaultSwitch() {
        this.initSwitchSizeAndComboBox(this.switchOnOffComboBox);
        ConfirmSwitch historyChoose = BizPackageContext.getInstance().getCheckItemHandleSwitch();
        if (historyChoose != null) {
            this.switchOnOffComboBox.setSelectedIndex(historyChoose.getIndex());
        } else {
            this.switchOnOffComboBox.setSelectedIndex(ConfirmSwitch.OFF.getIndex());
        }
    }

    private void initRiskPowerSwitch() {
        this.initSwitchSizeAndComboBox(this.switchOnOffRiskPowerComboBox);
        ConfirmSwitch historyChoose = BizPackageContext.getInstance().getCheckRiskPowerSwitch();
        if (historyChoose != null) {
            this.switchOnOffRiskPowerComboBox.setSelectedIndex(historyChoose.getIndex());
        } else {
            this.switchOnOffRiskPowerComboBox.setSelectedIndex(ConfirmSwitch.OFF.getIndex());
        }
    }

    private void initSwitchSizeAndComboBox(JComboBox<String> box) {
        box.setModel(new DefaultComboBoxModel());
        ((DefaultComboBoxModel)box.getModel()).addElement(ResourceUtil.getString(ConfirmSwitch.OFF.getLangResource()));
        ((DefaultComboBoxModel)box.getModel()).addElement(ResourceUtil.getString(ConfirmSwitch.ON.getLangResource()));
        box.setPreferredSize(this.dimension);
        box.setMaximumSize(this.dimension);
        box.setMinimumSize(this.dimension);
    }

    private void addSwitchElement(ConfirmSwitch switchOnOff) {
        ((DefaultComboBoxModel)this.switchOnOffComboBox.getModel()).addElement(ResourceUtil.getString(switchOnOff.getLangResource()));
        ((DefaultComboBoxModel)this.switchOnOffRiskPowerComboBox.getModel()).addElement(ResourceUtil.getString(switchOnOff.getLangResource()));
    }

    public void confirmSwitch() {
        ConfirmSwitch.findByIndex(this.switchOnOffComboBox.getSelectedIndex()).ifPresent(choose -> BizPackageContext.getInstance().setCheckItemHandleSwitch((ConfirmSwitch)((Object)choose)));
        ConfirmSwitch.findByIndex(this.switchOnOffRiskPowerComboBox.getSelectedIndex()).ifPresent(choose -> BizPackageContext.getInstance().setCheckRiskPowerSwitch((ConfirmSwitch)((Object)choose)));
        if (SwingUtilities.getWindowAncestor(this) instanceof SelectGroupWizardSettingDialog) {
            SelectGroupWizardSettingDialog dialog = (SelectGroupWizardSettingDialog)SwingUtilities.getWindowAncestor(this);
            SelectGroupWizardDialogLayout groupWizardDialogLayout = dialog.getSelectGroupWizardDialog().getGroupDialogLayout();
            for (Component component : groupWizardDialogLayout.getComponents()) {
                if (!(component instanceof JPanel)) continue;
                this.setRiskPowerShow((JPanel)component);
            }
        }
        log.info("Set switchOnOff:{}, Set switchOnOffRiskPower:{} ", (Object)this.switchOnOffComboBox.getSelectedIndex(), (Object)this.switchOnOffRiskPowerComboBox.getSelectedIndex());
    }

    private void setRiskPowerShow(JPanel component) {
        for (Component boxComponent : component.getComponents()) {
            if (!(boxComponent instanceof GroupTypePanel)) continue;
            this.setRiskPowerLabel((GroupTypePanel)boxComponent);
        }
    }

    private void setRiskPowerLabel(GroupTypePanel boxComponent) {
        for (ToolHyperLinkLabel toolHyperLinkLabel : boxComponent.getFruTitleList()) {
            if (!"process.group.other.title.riskPower".equals(toolHyperLinkLabel.getName())) continue;
            toolHyperLinkLabel.setVisible(this.switchOnOffRiskPowerComboBox.getSelectedIndex() > 0);
        }
    }

    public static enum ConfirmSwitch {
        OFF(0, "off"),
        ON(1, "on");

        private int index;
        private String name;

        private ConfirmSwitch(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getLangResource() {
            return "bizpack.wizard.setting." + this.getName();
        }

        public static Optional<ConfirmSwitch> findByIndex(int index) {
            ConfirmSwitch[] switchList;
            for (ConfirmSwitch st : switchList = ConfirmSwitch.values()) {
                if (st.index != index) continue;
                return Optional.of(st);
            }
            return Optional.empty();
        }
    }
}

