/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog;

import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelWizardWaitDialog
implements Callable<WaitDialogResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelWizardWaitDialog.class);
    private static final String CANCEL = "cancel";
    private String cancelScript = "";
    private String cancelScriptName = "";

    public CancelWizardWaitDialog(String cancelScript, String cancelScriptName) {
        this.cancelScript = cancelScript;
        this.cancelScriptName = cancelScriptName;
    }

    @Override
    public WaitDialogResult call() {
        WaitDialogResult result = new WaitDialogResult();
        try {
            ExecPyScriptTask cancelTask = new ExecPyScriptTask(this.cancelScript, this.cancelScriptName);
            cancelTask.execFunc(CANCEL);
            result.setFlag(true);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("CancelWizard jython File {} not found", (Object)this.cancelScriptName);
            result.setFlag(false);
            result.setException(new FileNotFoundException());
        }
        catch (SignException e) {
            LOGGER.error("CancelWizard python file has no sign", (Throwable)e);
            result.setFlag(false);
            result.setException(e);
        }
        catch (Exception e) {
            LOGGER.error("CancelWizard jython exec err", (Throwable)e);
            result.setFlag(false);
            result.setException(e);
        }
        return result;
    }
}

