/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog;

import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileAndExecOnePyFuncWaitDialog
implements Callable<WaitDialogResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileAndExecOnePyFuncWaitDialog.class);
    private ExecPyScriptTask pyTask;
    private String preScriptPath = "";
    private String pyName = "";
    private String funcName = "";
    private String param = "";

    public CompileAndExecOnePyFuncWaitDialog(String preScriptPath, String pyName, String funcName, String param) {
        this.preScriptPath = preScriptPath;
        this.pyName = pyName;
        this.funcName = funcName;
        this.param = param;
    }

    @Override
    public WaitDialogResult call() {
        WaitDialogResult result = new WaitDialogResult();
        try {
            this.pyTask = new ExecPyScriptTask(this.preScriptPath, this.pyName);
            if (this.pyTask.execFunc(this.funcName, this.param)) {
                result.setFlag(true);
                result.setTask(this.pyTask);
                return result;
            }
            result.setFlag(false);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("CompileAndExecOnePyFunc jython File {} not found", (Object)this.pyName);
            result.setFlag(false);
            result.setException(e);
        }
        catch (SignException e) {
            LOGGER.error("CompileAndExecOnePyFunc python file has no sign", (Throwable)e);
            result.setFlag(false);
            result.setException(e);
        }
        catch (Exception e) {
            LOGGER.error("CompileAndExecOnePyFunc jython exec err", (Throwable)e);
            result.setFlag(false);
            result.setException(e);
        }
        return result;
    }
}

