/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect.task;

import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect.comp.DetectItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect.intf.IDetectItemUiObserver;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecDetectItemTask
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecDetectItemTask.class);
    private List<DetectItem> detectItems;
    private IDetectItemUiObserver uiObserver;
    private Map<Integer, DetectItem> id2ItemMap = new HashMap<Integer, DetectItem>();
    private List<Integer> idList = new ArrayList<Integer>();
    private String processPath = "";
    private String scriptPath = "";
    private JythonContext ssEnv;
    private JythonExecuter jythonExecuter;
    private boolean execAllWhenFailed = false;
    private boolean isRecheck = false;
    private int beginNum;

    public ExecDetectItemTask(List<DetectItem> detectItems, IDetectItemUiObserver uiObserver, String processPath, boolean execAllWhenFailed) {
        this.detectItems = detectItems;
        this.uiObserver = uiObserver;
        this.processPath = processPath;
        this.execAllWhenFailed = execAllWhenFailed;
        this.scriptPath = this.getScriptDir();
        this.initItem();
        this.ssEnv = BizPackageContext.getInstance().getJythonContext();
    }

    public ExecDetectItemTask(List<DetectItem> detectItems, IDetectItemUiObserver uiObserver, String processPath, boolean execAllWhenFailed, List<Integer> idList) {
        this.detectItems = detectItems;
        this.uiObserver = uiObserver;
        this.processPath = processPath;
        this.execAllWhenFailed = execAllWhenFailed;
        this.scriptPath = this.getScriptDir();
        this.idList = idList;
        this.isRecheck = true;
        this.initItemWhenFailed();
        this.ssEnv = BizPackageContext.getInstance().getJythonContext();
    }

    private void initItem() {
        for (DetectItem item : this.detectItems) {
            String idStr = item.getId();
            int id = Integer.parseInt(idStr);
            this.id2ItemMap.put(id, item);
            this.idList.add(id);
        }
        Collections.sort(this.idList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("idList = " + this.idList);
        }
    }

    private void initItemWhenFailed() {
        for (DetectItem item : this.detectItems) {
            String idStr = item.getId();
            int id = Integer.parseInt(idStr);
            this.id2ItemMap.put(id, item);
        }
    }

    @Override
    public void run() {
        int id;
        DetectItem item;
        this.jythonExecuter = new JythonExecuter(new File(this.processPath));
        this.ssEnv.getDict().put("logger", LOGGER);
        this.uiObserver.startDetect();
        this.beginNum = this.uiObserver.getCurItemNums();
        for (int index = 0; index < this.idList.size() && this.execOneItem(item = this.id2ItemMap.get(id = this.idList.get(index).intValue()), id); ++index) {
        }
        SwingUtilities.invokeLater(() -> {
            this.uiObserver.fireAllFinish();
            LOGGER.info("refresh ui when all finish.");
        });
    }

    private boolean execOneItem(DetectItem item, Integer id) {
        int index = this.uiObserver.getCurItemNums();
        if (this.isRecheck) {
            index = id + (this.uiObserver.getCurItemNums() - this.beginNum);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("execute list index : " + index);
        }
        String scriptName = item.getScript();
        String param = item.getParam();
        String pyPath = this.scriptPath + File.separator + scriptName;
        File pyFile = new File(pyPath);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("execute script : " + pyPath);
        }
        this.uiObserver.setCurrentStatusTxt(item.getTitle() + "...");
        this.uiObserver.refreshItemLoading(item, index);
        this.uiObserver.initStatusPanel();
        if (this.checkSsEnv(item, index, param, pyFile)) {
            return this.getRealResult(false);
        }
        return this.getRealResult(true);
    }

    private boolean checkSsEnv(DetectItem item, int index, String param, File pyFile) {
        try {
            this.ssEnv.getDict().put("curProgressPer", null);
            this.ssEnv.getDict().put("remainTime", null);
            this.ssEnv.getDict().put("detailInfo", null);
            this.jythonExecuter.compileScript(pyFile);
            item.setJythonExecuter(this.jythonExecuter);
            item.setPyFile(pyFile);
            this.ssEnv.clearMsgData();
            if ("".equals(param.trim())) {
                Object[] paramList = new Object[]{this.ssEnv.getDict()};
                this.jythonExecuter.invokeFunction("execute", paramList);
            } else {
                this.jythonExecuter.invokeFunction("execute", new Object[]{this.ssEnv.getDict(), param});
            }
            if (!((Boolean)this.ssEnv.getDict().get("succ")).booleanValue()) {
                item.setResult(ItemResult.FAILED);
                this.uiObserver.fireFinish(item, index);
                return true;
            }
            item.setResult(ItemResult.SUCCEED);
            this.uiObserver.fireFinish(item, index);
        }
        catch (FileNotFoundException e) {
            this.uiObserver.fireException(new FileNotFoundException("file not found."), item, index);
            LOGGER.error("jython File {} not found", (Object)pyFile.getName());
            return true;
        }
        catch (SignException e) {
            this.uiObserver.fireException(e, item, index);
            LOGGER.error("python file has no sign", (Throwable)e);
            return true;
        }
        catch (Exception e) {
            this.uiObserver.fireException(e, item, index);
            LOGGER.error("jython exec err", (Throwable)e);
            return true;
        }
        return false;
    }

    private boolean getRealResult(boolean originalResult) {
        return this.execAllWhenFailed || originalResult;
    }

    private String getScriptDir() {
        String processID = BizPackageContext.getInstance().getCurBizWizardCfg().getId();
        StringBuilder scriptProcessPath = new StringBuilder();
        scriptProcessPath.append(this.processPath);
        scriptProcessPath.append(File.separator);
        scriptProcessPath.append(processID);
        scriptProcessPath.append(File.separator);
        scriptProcessPath.append("script");
        return scriptProcessPath.toString();
    }
}

