/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph;

import com.huawei.ism.autotest.AutoProcessResult;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.tool.base.flow.IStep;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.Navigation;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IDevgGraphInit;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.DevGraphStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.DevGraphStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.comp.DevCompEnum;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.comp.DevGraphComp;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.comp.DevGraphCompLine;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevGraphStep
extends AbstractBizStep
implements IDevgGraphInit {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevGraphStep.class);
    private DevGraphStepLayout devGraphLayout;
    private DevGraphStepCfg cfg;

    protected FlowWizardCardLayout getLayout() {
        return this.devGraphLayout;
    }

    protected boolean init() {
        this.setCurStepID();
        DevGraphStepCfg conCfg = (DevGraphStepCfg)BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId());
        this.initByConfig(conCfg);
        this.setAllStageNum();
        super.setIndex(this.getStageIndex());
        this.clearAllCheckBox(this.cfg);
        if (this.cfg.isNeedDeviceGraph()) {
            this.paintDevGraph(this);
        }
        this.initAllBtnLink(this.cfg);
        this.chgWizState(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IStep currentStep = BizPackageContext.getInstance().getCurrentStep();
                if (currentStep != null && currentStep instanceof DevGraphStep) {
                    ((DevGraphStep)currentStep).notifyObserver(AutoProcessStatus.DISPLAY);
                }
            }
        });
        return true;
    }

    public boolean flowExiting() {
        return this.cancel();
    }

    public boolean ending() {
        if (!this.cfg.isNextCheck()) {
            return true;
        }
        if (!ExecPyUtils.execInitScript(this.cfg.getScriptFile(), this.getParamAbs(), "nextCheck")) {
            String errText = ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            return false;
        }
        if (!((Boolean)this.getSsEnv().getDict().get("succ")).booleanValue()) {
            String errText = (String)this.getSsEnv().getDict().get("errMsg");
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)errText);
            return false;
        }
        return true;
    }

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        if (stepConfig instanceof DevGraphStepCfg) {
            this.cfg = (DevGraphStepCfg)stepConfig;
            this.devGraphLayout = new DevGraphStepLayout(this.cfg);
            super.setBackwardAbs(this.cfg.isBackward());
            super.setCancelScriptAbs(this.cfg.getCancelScript());
            super.setParamAbs(this.cfg.getParam());
            this.initListener(this.cfg);
        }
    }

    @Override
    public TaskResult initDevGraph() {
        if (!ExecPyUtils.execInitScript(this.cfg.getScriptFile(), this.getParamAbs(), "initDevGraph")) {
            String errorMsg = ResourceUtil.getString("bizpackage.error.preset.execscriptfailed");
            TaskResult result = new TaskResult(TaskResult.Result.FAILED);
            result.setErrorLocaleDescription(errorMsg);
            return result;
        }
        TaskResult result = this.getDevGraphExecResult();
        this.refreshComValue(this.cfg);
        return result;
    }

    private void refreshComValue(DevGraphStepCfg conCfg) {
        try {
            JythonContext jssEnv = BizPackageContext.getInstance().getJythonContext();
            String jsonstr = (String)jssEnv.getDict().get("refreshData");
            this.refreshUiPage(conCfg, jsonstr);
        }
        catch (Exception e) {
            LOGGER.trace("refreshData error", (Throwable)e);
            LOGGER.error("refreshData error!");
        }
    }

    private void refreshUiPage(DevGraphStepCfg conCfg, String jsonstr) {
        List<DevGraphComp> lableList = this.getCompByType(DevCompEnum.ALL, conCfg);
        for (DevGraphComp devGraphComp : lableList) {
            Component comp;
            String refresh = devGraphComp.getRefresh();
            if (refresh == null || "".equals(refresh) || !((comp = devGraphComp.getComp()) instanceof JLabel)) continue;
            JLabel uicomp = (JLabel)comp;
            String key = devGraphComp.getValue();
            JSONArray jsonArray = new JSONArray(jsonstr);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                uicomp.setText(jsonObject.getString(key));
            }
        }
    }

    private void clearAllCheckBox(DevGraphStepCfg conCfg) {
        List<DevGraphComp> checkBoxList = this.getCompByType(DevCompEnum.CHECKBOX, conCfg);
        for (DevGraphComp devGraphComp : checkBoxList) {
            Component comp = devGraphComp.getComp();
            if (!(comp instanceof JCheckBox)) {
                String errorInfo = "clear checkbox comp error, comp id=" + devGraphComp.getId() + " type=" + devGraphComp.getType();
                LOGGER.error(errorInfo);
                continue;
            }
            JCheckBox ck = (JCheckBox)devGraphComp.getComp();
            ck.setSelected(false);
        }
    }

    private void initAllBtnLink(DevGraphStepCfg conCfg) {
        List<DevGraphComp> btnList = this.getCompByType(DevCompEnum.BUTTON, conCfg);
        for (DevGraphComp devGraphComp : btnList) {
            DevGraphComp ckComp;
            String linkId = devGraphComp.getEnableLinkId();
            if (StringUtils.isNULLStr(linkId) || (ckComp = this.getCompById(linkId, conCfg)) == null) continue;
            ckComp.getComp().setEnabled(false);
        }
    }

    private void initListener(DevGraphStepCfg conCfg) {
        this.initCKListener(conCfg);
        this.initBtnListener(conCfg);
        this.initComboBoxListener(conCfg);
    }

    private void initComboBoxListener(DevGraphStepCfg conCfg) {
        List<DevGraphComp> comboBoxList = this.getCompByType(DevCompEnum.COMBOBOX, conCfg);
        for (DevGraphComp devGraphComp : comboBoxList) {
            Component comp = devGraphComp.getComp();
            if (!(comp instanceof JComboBox)) {
                String errorInfo = "combobox comp add listener error, comp id=" + devGraphComp.getId() + " type=" + devGraphComp.getType();
                LOGGER.error(errorInfo);
                continue;
            }
            ((JComboBox)comp).addItemListener(new ComboBoxItemListener(devGraphComp));
        }
    }

    private void initCKListener(DevGraphStepCfg conCfg) {
        List<DevGraphComp> checkBoxList = this.getCompByType(DevCompEnum.CHECKBOX, conCfg);
        for (DevGraphComp devGraphComp : checkBoxList) {
            Component comp = devGraphComp.getComp();
            if (!(comp instanceof JCheckBox)) {
                String errorInfo = "checkbox comp add listener error, comp id=" + devGraphComp.getId() + " type=" + devGraphComp.getType();
                LOGGER.error(errorInfo);
                continue;
            }
            JCheckBox ck = (JCheckBox)devGraphComp.getComp();
            ck.addItemListener(new CheckItemListener(conCfg));
        }
    }

    private void initBtnListener(DevGraphStepCfg conCfg) {
        List<DevGraphComp> btnList = this.getCompByType(DevCompEnum.BUTTON, conCfg);
        for (DevGraphComp devGraphComp : btnList) {
            this.addEachActionListener(conCfg, devGraphComp);
        }
    }

    private void addEachActionListener(DevGraphStepCfg conCfg, DevGraphComp devGraphComp) {
        Component comp = devGraphComp.getComp();
        if (!(comp instanceof JButton)) {
            String errorInfo = "button comp add listener error, comp id=" + devGraphComp.getId() + " type=" + devGraphComp.getType();
            LOGGER.error(errorInfo);
            return;
        }
        JButton btn = (JButton)comp;
        JCheckBox ck = null;
        if (!StringUtils.isNULLStr(devGraphComp.getEnableLinkId())) {
            try {
                DevGraphComp compById = this.getCompById(devGraphComp.getEnableLinkId(), conCfg);
                if (compById == null) {
                    return;
                }
                ck = (JCheckBox)compById.getComp();
            }
            catch (Exception e) {
                LOGGER.error("get link checkbox error.", (Throwable)e);
            }
        }
        btn.addActionListener(new ClickBtnListener(devGraphComp.getTask(), devGraphComp.getParam(), ck));
    }

    private boolean isAllChecked(DevGraphStepCfg conCfg) {
        List<DevGraphComp> checkBoxList = this.getCompByType(DevCompEnum.CHECKBOX, conCfg);
        for (DevGraphComp devGraphComp : checkBoxList) {
            Component comp = devGraphComp.getComp();
            if (!(comp instanceof JCheckBox)) {
                String errorInfo = "checkbox comp juage select error, comp id=" + devGraphComp.getId() + " type=" + devGraphComp.getType();
                LOGGER.error(errorInfo);
                continue;
            }
            JCheckBox ck = (JCheckBox)devGraphComp.getComp();
            if (ck.isSelected()) continue;
            return false;
        }
        return true;
    }

    private DevGraphComp getCompById(String id, DevGraphStepCfg config) {
        for (DevGraphCompLine compLine : config.getCompLineList()) {
            for (DevGraphComp comp : compLine.getCompList()) {
                if (!id.equals(comp.getId())) continue;
                return comp;
            }
        }
        return null;
    }

    private List<DevGraphComp> getCompByType(DevCompEnum type, DevGraphStepCfg config) {
        ArrayList<DevGraphComp> compList = new ArrayList<DevGraphComp>();
        for (DevGraphCompLine compLine : config.getCompLineList()) {
            for (DevGraphComp comp : compLine.getCompList()) {
                if (type.equals((Object)DevCompEnum.ALL)) {
                    compList.add(comp);
                    continue;
                }
                if (!type.toString().equals(comp.getType())) continue;
                compList.add(comp);
            }
        }
        return compList;
    }

    private void refreshComboBoxData(DevGraphComp devGraphComp) {
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        List<DevGraphComp> comboBoxList = this.getCompByType(DevCompEnum.COMBOBOX, this.cfg);
        for (Map.Entry<String, Object> iterable : ssEnv.getDict().entrySet()) {
            String value;
            Component comp;
            String key = iterable.getKey();
            DevGraphComp comboBoxComp = this.findComboBoxID(comboBoxList, key);
            if (null == comboBoxComp || comboBoxComp.getId().equals(devGraphComp.getId()) || !((comp = comboBoxComp.getComp()) instanceof JComboBox) || StringUtils.isNULLStr(value = (String)iterable.getValue())) continue;
            JComboBox jComboBoxTmp = (JComboBox)comp;
            SwingUtilities.invokeLater(new ComBoxListner(jComboBoxTmp, value));
        }
    }

    private DevGraphComp findComboBoxID(List<DevGraphComp> comboBoxList, String key) {
        for (DevGraphComp devGraphComp : comboBoxList) {
            String id = devGraphComp.getId();
            if (!key.trim().equals("retData_" + id)) continue;
            return devGraphComp;
        }
        return null;
    }

    private String getItemId(String id) {
        StringBuilder itemId = new StringBuilder();
        itemId.append("input");
        itemId.append('_');
        itemId.append(this.getId());
        itemId.append('_');
        itemId.append(id);
        return itemId.toString();
    }

    @Override
    public void onStepDialogDisplayed() {
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.outputResult(status);
        if (BizPackageContext.getInstance().getWizard() instanceof FlowWizardDialog) {
            FlowWizardDialog wizardDialog = (FlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(Navigation.NEXT);
        }
    }

    private void outputResult(AutoProcessStatus status) {
        String stepId = BizPackageContext.getInstance().getCurStepId();
        AutoProcessResult.getInstance().append(String.format(Locale.ROOT, "%s--------step: %s, result: %s", System.lineSeparator(), stepId, status.toString()));
    }

    private class ComboBoxItemListener
    implements ItemListener {
        private DevGraphComp devGraphComp;

        public ComboBoxItemListener(DevGraphComp devGraphComp) {
            this.devGraphComp = devGraphComp;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String itemId = this.devGraphComp.getId();
                String selectValue = (String)((JComboBox)this.devGraphComp.getComp()).getSelectedItem();
                BizPackageContext.getInstance().getJythonContext().getDict().put(DevGraphStep.this.getItemId(itemId), selectValue);
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                this.devGraphComp.getTask().execFunc("refresh", this.devGraphComp.getParam());
                DevGraphStep.this.refreshComboBoxData(this.devGraphComp);
            }
        }
    }

    private class CheckItemListener
    implements ItemListener {
        private DevGraphStepCfg config = null;

        public CheckItemListener(DevGraphStepCfg cfg) {
            this.config = cfg;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DevGraphStep.this.isAllChecked(this.config)) {
                DevGraphStep.this.chgWizState(true);
            } else {
                DevGraphStep.this.chgWizState(false);
            }
        }
    }

    private static class ClickBtnListener
    implements ActionListener {
        private JCheckBox ck = null;
        private ExecPyScriptTask task;
        private String param = "";

        public ClickBtnListener(ExecPyScriptTask task, String param, JCheckBox ck) {
            this.task = task;
            this.param = param;
            this.ck = ck;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.task.execFunc("execute", this.param);
            if (null != this.ck) {
                this.ck.setEnabled(true);
            }
        }
    }

    private static class ComBoxListner
    implements Runnable {
        private final JComboBox jComboBoxTmp;
        private final String value;

        private ComBoxListner(JComboBox jComboBoxTmp, String value) {
            this.jComboBoxTmp = jComboBoxTmp;
            this.value = value;
        }

        @Override
        public void run() {
            this.jComboBoxTmp.removeAllItems();
            JSONArray jArray = new JSONArray(this.value);
            for (int i = 0; i < jArray.length(); ++i) {
                String item = (String)jArray.get(i);
                this.jComboBoxTmp.addItem(item);
            }
        }
    }
}

