/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.comp.DevGraphComp;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.comp.DevGraphCompLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;

public class DevGraphStepCfg
extends BizStepConfig {
    private static final String BOTTOM_LINE = "bottom-line";
    private static final String COMP_NODE = "component";
    private List<DevGraphCompLine> compLineList = new ArrayList<DevGraphCompLine>();
    private boolean nextCheck = false;

    @Override
    public void loadConfig(Element node) {
        this.setId(this.getAttribute(node, "id", ""));
        this.setDescription(this.getAttribute(node, "desc", ""));
        this.setTitle(this.getAttribute(node, "title", ""));
        this.setScriptFile(this.getAttribute(node, "script", ""));
        this.setCancelScript(this.getAttribute(node, "cancelScript", ""));
        this.setParam(this.getAttribute(node, "param", ""));
        String auto = this.getAttribute(node, "auto", "");
        if (auto.equalsIgnoreCase("true")) {
            this.setAuto(true);
        }
        String backwardStr = this.getAttribute(node, "backward", "");
        this.setBackwardValue(backwardStr);
        String nextCheckStr = this.getAttribute(node, "nextCheck", "");
        if (nextCheckStr.equalsIgnoreCase("true")) {
            this.setNextCheck(true);
        }
        this.laodCompList(node);
        this.parseCommon(node);
    }

    private void laodCompList(Element node) {
        Collection<Element> bottomLines = XmlUtils.getChildren(node, BOTTOM_LINE);
        for (Element oneLine : bottomLines) {
            DevGraphCompLine compLine = new DevGraphCompLine();
            String margin = this.getAttribute(oneLine, "margin", "");
            if (!StringUtils.isNULLStr(margin)) {
                int m = Integer.parseInt(margin);
                compLine.setCompMargin(m);
            }
            compLine.setType(this.getAttribute(oneLine, "type", ""));
            String valueStr = this.getAttribute(oneLine, "value", "");
            if (!StringUtils.isNULLStr(valueStr)) {
                int value = Integer.parseInt(valueStr);
                compLine.setValue(value);
            }
            List<DevGraphComp> oneLineComps = compLine.getCompList();
            Collection<Element> oneLineNodes = XmlUtils.getChildren(oneLine, COMP_NODE);
            for (Element element : oneLineNodes) {
                DevGraphComp comp = new DevGraphComp();
                comp.setId(this.getAttribute(element, "id", ""));
                comp.setType(this.getAttribute(element, "type", ""));
                comp.setValue(this.getAttribute(element, "value", ""));
                comp.setScript(this.getAttribute(element, "script", ""));
                comp.setRefresh(this.getAttribute(element, "refresh", ""));
                comp.setParam(this.getAttribute(element, "param", ""));
                comp.setEnableLinkId(this.getAttribute(element, "linkid", ""));
                comp.setShortcut(this.getAttribute(element, "shortcut", ""));
                oneLineComps.add(comp);
            }
            this.compLineList.add(compLine);
        }
    }

    public List<DevGraphCompLine> getCompLineList() {
        return this.compLineList;
    }

    public void setCompLineList(List<DevGraphCompLine> compLineList) {
        this.compLineList = compLineList;
    }

    public boolean isNextCheck() {
        return this.nextCheck;
    }

    public void setNextCheck(boolean nextCheck) {
        this.nextCheck = nextCheck;
    }
}

