/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.DevGraphStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.comp.DevCompEnum;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.comp.DevGraphComp;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.devgraph.comp.DevGraphCompLine;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevGraphStepLayout
extends AbstractBizStepLayout {
    private static final long serialVersionUID = 6431173374666161878L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DevGraphStepLayout.class);
    private static final int BORDER_SIZE = 20;

    public DevGraphStepLayout(DevGraphStepCfg cfg) {
        BizPackageContext.getInstance().getId2LayoutMap().put(cfg.getId(), this);
        this.initUi(cfg);
    }

    private void initUi(DevGraphStepCfg cfg) {
        this.setBizCfg(cfg);
        this.initComp(cfg);
        this.initLayOut(cfg);
    }

    private void initComp(DevGraphStepCfg cfg) {
        List<DevGraphCompLine> compLineList = cfg.getCompLineList();
        for (DevGraphCompLine compLine : compLineList) {
            for (DevGraphComp devGraphComp : compLine.getCompList()) {
                try {
                    this.initOneComp(devGraphComp);
                }
                catch (Exception e) {
                    LOGGER.error("init one component error", (Throwable)e);
                }
            }
        }
        JScrollPane devGraphPane = new JScrollPane();
        this.setDevGraphPane(devGraphPane);
        UiMethod.setComponentSize((Dimension)cfg.getDevGraphSize(), (Component[])new Component[]{devGraphPane});
    }

    private void initLayOut(DevGraphStepCfg cfg) {
        List<DevGraphCompLine> compLineList = cfg.getCompLineList();
        Component[] comps = new Component[1 + compLineList.size()];
        comps[0] = this.getDevGraphPane();
        for (int i = 0; i < compLineList.size(); ++i) {
            DevGraphCompLine oneLine = compLineList.get(i);
            comps[1 + i] = oneLine.getType().equalsIgnoreCase("strut") ? Box.createVerticalStrut(oneLine.getValue()) : (oneLine.getType().equalsIgnoreCase("glue") ? Box.createVerticalGlue() : this.buildOneLine(oneLine));
        }
        JComponent view = null;
        view = UCD.buildVerticalBox(null, (Component[])comps);
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)view, (int)20), "Center");
    }

    private Component buildOneLine(DevGraphCompLine oneLineComp) {
        JPanel oneLinePanel = new JPanel();
        oneLinePanel.setLayout(new BoxLayout(oneLinePanel, 0));
        List<DevGraphComp> comps = oneLineComp.getCompList();
        int compMargin = oneLineComp.getCompMargin();
        for (DevGraphComp devGraphComp : comps) {
            oneLinePanel.add(devGraphComp.getComp());
            if (compMargin <= 0) continue;
            oneLinePanel.add(Box.createHorizontalStrut(compMargin));
        }
        return oneLinePanel;
    }

    private void initOneComp(DevGraphComp devGraphComp) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        DevCompEnum type = DevCompEnum.getDevCompEnum(devGraphComp.getType().toLowerCase(Locale.ENGLISH));
        switch (type) {
            case LABEL: {
                JLabel label = new JLabel(resource.getString(devGraphComp.getValue()));
                AutomateUtils.setNameAttribute(label, "label_devGraphStep");
                devGraphComp.setComp(label);
                break;
            }
            case BUTTON: {
                JButton btn = UiMethod.createButton((String)resource.getString(devGraphComp.getValue()), (char)devGraphComp.getShortcut().charAt(0));
                AutomateUtils.setNameAttribute(btn, "btn_devGraphStep");
                devGraphComp.setComp(btn);
                this.initTask(devGraphComp);
                break;
            }
            case STRUT: {
                Component strut = Box.createHorizontalStrut(Integer.parseInt(devGraphComp.getValue()));
                AutomateUtils.setNameAttribute(strut, "strut_devGraphStep");
                devGraphComp.setComp(strut);
                break;
            }
            case GLUE: {
                Component glue = Box.createHorizontalGlue();
                AutomateUtils.setNameAttribute(glue, "glue_devGraphStep");
                devGraphComp.setComp(glue);
                break;
            }
            case CHECKBOX: {
                JCheckBox cb = new JCheckBox(resource.getString(devGraphComp.getValue()));
                AutomateUtils.setNameAttribute(cb, "checkBox_devGraphStep");
                devGraphComp.setComp(cb);
                break;
            }
            case COMBOBOX: {
                JComboBox<String> cb = new JComboBox<String>();
                AutomateUtils.setNameAttribute(cb, "comboBox_devGraphStep");
                devGraphComp.setComp(cb);
                this.initTask(devGraphComp);
                this.setComboBoxItems(cb, devGraphComp);
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong dev component type[" + devGraphComp.getType() + "]");
            }
        }
    }

    private void setComboBoxItems(JComboBox<String> cb, DevGraphComp devGraphComp) {
        if (!devGraphComp.getTask().execFunc("execute", devGraphComp.getParam())) {
            LOGGER.error("init combobox data faile.");
            return;
        }
        String jsonStr = (String)BizPackageContext.getInstance().getJythonContext().getDict().get("retData");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("init combobox data =" + jsonStr);
        }
        JSONArray jArray = new JSONArray(jsonStr);
        for (int i = 0; i < jArray.length(); ++i) {
            String item = (String)jArray.get(i);
            cb.addItem(item);
        }
    }

    private void initTask(DevGraphComp devGraphComp) {
        try {
            devGraphComp.setTask(new ExecPyScriptTask(this.getScriptProcess(), devGraphComp.getScript()));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found.");
        }
        catch (SignException e) {
            LOGGER.error("file not sign.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("file init err.", (Throwable)e);
        }
    }

    private String getScriptProcess() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append("process");
        return scriptPath.toString();
    }
}

