/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.parse.CheckItemPlatformAdapterInBizPackage;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.ProcessStepType;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoBoard;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.BackAfterSucc;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.comp.ConfirmBord;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.comp.DangerTips;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DoItemStepCfg
extends BizStepConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoItemStepCfg.class);
    private static final String CHECK_ITEM = "check-item";
    private static final String EXEC_ITEM = "cmd-item";
    private static final String CONFIRM_INFO = "confirm-info";
    private static final String INFO_ITEM = "info-item";
    private static final String[] TOOLTYPES = new String[]{"fru", "cru"};
    private List<Item> checkItemList = new ArrayList<Item>();
    private List<ConfirmBord> confirmBoardList = new ArrayList<ConfirmBord>();
    private BackAfterSucc backaftersuc = BackAfterSucc.NOT_SET;
    private DangerTips dangerTips = new DangerTips();
    private boolean showPro;
    private boolean showLeftTime;
    private boolean showRemindInfo;
    private String remainText;
    private boolean failedCheckAll = false;

    public boolean isShowRemindInfo() {
        return this.showRemindInfo;
    }

    public void setShowRemindInfo(boolean showRemindInfo) {
        this.showRemindInfo = showRemindInfo;
    }

    @Override
    public void loadConfig(Element node) {
        this.setId(this.getAttribute(node, "id", ""));
        this.setDescription(this.getAttribute(node, "desc", ""));
        this.setTitle(this.getAttribute(node, "title", ""));
        this.setScriptFile(this.getAttribute(node, "script", ""));
        this.setParam(this.getAttribute(node, "param", ""));
        this.setCancelScript(this.getAttribute(node, "cancelScript", ""));
        this.setInsertPoint(this.getAttribute(node, "insertPoint", ""));
        this.loadBoolAttr(node);
        String remindText = this.getAttribute(node, "remindText", "");
        this.setRemainText(remindText);
        this.parseSingleWizardSize(node);
        this.setAllAtributeMap(this.getAllAtributeMap(node));
        String backwardStr = this.getAttribute(node, "backward", "");
        this.setBackwardValue(backwardStr);
        String backaftersucStr = this.getAttribute(node, "backaftersuc", "");
        if (backaftersucStr.equalsIgnoreCase("enable")) {
            this.backaftersuc = BackAfterSucc.ENABLE;
        } else if (backaftersucStr.equalsIgnoreCase("disable")) {
            this.backaftersuc = BackAfterSucc.DISABLE;
        }
        NodeList nodeList = null;
        nodeList = this.checkStepType(node, nodeList);
        if (nodeList == null) {
            return;
        }
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Element nodeElement = (Element)nodeList.item(index);
            Item checkItem = new Item();
            checkItem.setId(this.getAttribute(nodeElement, "id", ""));
            checkItem.setTitle(this.getAttribute(nodeElement, "title", ""));
            checkItem.setScriptName(this.getAttribute(nodeElement, "script", ""));
            checkItem.setParam(this.getAttribute(nodeElement, "param", ""));
            checkItem.setDesc(this.getAttribute(nodeElement, "desc", ""));
            String showDetailVal = this.getAttribute(nodeElement, "showdetail", "false");
            checkItem.setShowDetail(null != showDetailVal && "true".equalsIgnoreCase(showDetailVal));
            this.addCheckItem(checkItem);
        }
        CheckItemPlatformAdapterInBizPackage.getInstance().addCheckConfigItem(this.checkItemList, this.getProcessId(), this.getId(), this.getInsertPoint());
        this.parseDanerTips(node);
        this.parseCommon(node);
    }

    NodeList checkStepType(Element node, NodeList nodeList) {
        String type = this.getAttribute(node, "type", "");
        NodeList result = nodeList;
        if (type.equals(ProcessStepType.CHECK.toString())) {
            result = node.getElementsByTagName(CHECK_ITEM);
            this.setType(ProcessStepType.CHECK);
            BizPackage bPa = BizPackageContext.getInstance().getCurBizPackage();
            if (TOOLTYPES[0].equalsIgnoreCase(bPa.getType()) || TOOLTYPES[1].equalsIgnoreCase(bPa.getType())) {
                this.setShowPro(true);
                this.setShowLeftTime(true);
            }
        } else if (type.equals(ProcessStepType.EXEC_SETTING.toString())) {
            result = node.getElementsByTagName(EXEC_ITEM);
            this.setType(ProcessStepType.EXEC_SETTING);
        } else if (type.equals(ProcessStepType.CONFIRM_REPLACED.toString())) {
            this.setType(ProcessStepType.CONFIRM_REPLACED);
            this.loadConfirmInfo(node);
            result = node.getElementsByTagName(CHECK_ITEM);
            BizPackage bPa = BizPackageContext.getInstance().getCurBizPackage();
            if (TOOLTYPES[0].equalsIgnoreCase(bPa.getType()) || TOOLTYPES[1].equalsIgnoreCase(bPa.getType())) {
                this.setShowPro(true);
                this.setShowLeftTime(true);
            }
        } else if (type.equals(ProcessStepType.ONE_CMD_SETTING.toString())) {
            this.setType(ProcessStepType.ONE_CMD_SETTING);
        }
        if (result == null || result.getLength() == 0) {
            return null;
        }
        return result;
    }

    private void parseSingleWizardSize(Element node) {
        String sizeStr = node.getAttribute("size");
        if (!StringUtils.isNULLStr(sizeStr)) {
            try {
                String[] sizeList = sizeStr.split(",");
                int width = Integer.parseInt(sizeList[0].trim());
                int height = Integer.parseInt(sizeList[1].trim());
                Dimension wardSize = new Dimension(width, height);
                this.setWizardSize(wardSize);
            }
            catch (Exception e) {
                LOGGER.error("pase wiward size exception:", (Throwable)e);
                return;
            }
        }
    }

    private void loadBoolAttr(Element node) {
        String failedCheckAllStr;
        String showRemindInfoString;
        String leftTime;
        String progress;
        String auto = this.getAttribute(node, "auto", "");
        if (auto.equalsIgnoreCase("true")) {
            this.setAuto(true);
        }
        if ((progress = this.getAttribute(node, "showProgress", "")).equalsIgnoreCase("true")) {
            this.setShowPro(true);
        }
        if ((leftTime = this.getAttribute(node, "showRemain", "")).equalsIgnoreCase("true")) {
            this.setShowLeftTime(true);
        }
        if ((showRemindInfoString = this.getAttribute(node, "showRemindText", "")).equalsIgnoreCase("true")) {
            this.setShowRemindInfo(true);
        }
        if ((failedCheckAllStr = this.getAttribute(node, "failedCheckAll", "")).equalsIgnoreCase("true")) {
            this.failedCheckAll = true;
        }
        String onceCheckAllStr = this.getAttribute(node, "onceCheckAll", "");
        this.setOnceCheckAll(onceCheckAllStr.equalsIgnoreCase("true"));
    }

    private void parseDanerTips(Element node) {
        Element dangerTipsNode;
        String dangerStr = this.getAttribute(node, "dangerTips", "");
        if (!StringUtils.isNULLStr(dangerStr)) {
            this.dangerTips.setDesc(dangerStr);
        }
        if (null != (dangerTipsNode = XmlUtils.getChild(node, "dangerTips"))) {
            String dangerScript = this.getAttribute(dangerTipsNode, "script", "");
            String dangerParam = this.getAttribute(dangerTipsNode, "param", "");
            if (!StringUtils.isNULLStr(dangerScript)) {
                this.dangerTips.setHasScript(true);
                this.dangerTips.setScript(dangerScript);
                this.dangerTips.setParam(dangerParam);
            }
        }
    }

    private void loadConfirmInfo(Element node) {
        NodeList nodeRefreshList = node.getElementsByTagName(CONFIRM_INFO);
        if (nodeRefreshList == null || nodeRefreshList.getLength() == 0) {
            return;
        }
        int refreshLength = nodeRefreshList.getLength();
        for (int index = 0; index < refreshLength; ++index) {
            Element nodeElement = (Element)nodeRefreshList.item(index);
            String name = this.getAttribute(nodeElement, "name", "");
            String btnNameK = "riskPower.replacefru.confirm".equals(name) ? "fru.riskPower.confirm.button" : this.getAttribute(nodeElement, "btnName", "");
            InfoBoard refreshBoard = new InfoBoard();
            this.loadOneRefreshBoard(node, refreshBoard);
            ConfirmBord confirmBord = null;
            confirmBord = !StringUtils.isNULLStr(btnNameK) ? new ConfirmBord(refreshBoard, btnNameK) : new ConfirmBord(refreshBoard);
            confirmBord.setName(name);
            this.confirmBoardList.add(confirmBord);
        }
    }

    private void loadOneRefreshBoard(Element node, InfoBoard refreshBoard) {
        NodeList refreshItemNodes = node.getElementsByTagName(INFO_ITEM);
        if (refreshItemNodes == null || refreshItemNodes.getLength() == 0) {
            return;
        }
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        int tableLength = refreshItemNodes.getLength();
        List<InfoItem> refreshItems = refreshBoard.getRefreshItems();
        for (int index = 0; index < tableLength; ++index) {
            Element nodeElement = (Element)refreshItemNodes.item(index);
            String itemId = this.getAttribute(nodeElement, "id", "");
            String label = this.getAttribute(nodeElement, "label", "");
            String isDoubleLen = this.getAttribute(nodeElement, "isDoubleLen", "");
            InfoItem refreshItem = new InfoItem(this);
            if ("true".equals(isDoubleLen)) {
                refreshItem.setHorizonLine(true);
            }
            refreshItem.setId(itemId);
            refreshItem.setLabelText(util.getString(label));
            refreshItems.add(refreshItem);
        }
    }

    public String getRemainText() {
        return this.remainText;
    }

    public void setRemainText(String remainText) {
        this.remainText = remainText;
    }

    public List<Item> getCheckItem() {
        return this.checkItemList;
    }

    public void setCheckItem(List<Item> checkItem) {
        this.checkItemList = checkItem;
    }

    public void addCheckItem(Item checkItem) {
        this.checkItemList.add(checkItem);
    }

    public boolean isShowPro() {
        return this.showPro;
    }

    public void setShowPro(boolean showPro) {
        this.showPro = showPro;
    }

    public boolean isShowLeftTime() {
        return this.showLeftTime;
    }

    public void setShowLeftTime(boolean showLeftTime) {
        this.showLeftTime = showLeftTime;
    }

    public List<ConfirmBord> getConfirmBoardList() {
        return this.confirmBoardList;
    }

    public void setConfirmBoardList(List<ConfirmBord> confirmBoardList) {
        this.confirmBoardList = confirmBoardList;
    }

    public BackAfterSucc getBackaftersuc() {
        return this.backaftersuc;
    }

    public void setBackaftersuc(BackAfterSucc backaftersuc) {
        this.backaftersuc = backaftersuc;
    }

    public DangerTips getDangerTips() {
        return this.dangerTips;
    }

    public boolean isFailedCheckAll() {
        return this.failedCheckAll;
    }

    public void setFailedCheckAll(boolean failedCheckAll) {
        this.failedCheckAll = failedCheckAll;
    }
}

