/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.finish.comp;

import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class Prompt {
    private static final int WIZARD_BLANK_SIZE = 45;
    private static final int GAP_SIZE = 50;
    private String id = "";
    private String name = "";
    private PromptType type;
    private JLabel promptLabel = new JLabel();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JLabel getPrompt() {
        return this.promptLabel;
    }

    public void setPrompt(JLabel prompt) {
        this.promptLabel = prompt;
    }

    public void setPromptTxt(String txt, BizStepConfig cfg) {
        this.promptLabel.setText(txt);
        int limitWidth = 45;
        if (cfg.isNeedDeviceGraph()) {
            limitWidth = cfg.getDevGraphSize().width + 45 + 50;
        }
        int maxWidth = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize().width - limitWidth;
        FontMetrics fm = this.promptLabel.getFontMetrics(IsmFontFactory.getDialogPlain());
        this.promptLabel.setText(UCD.wrapTextWithBr((FontMetrics)fm, (String)("<html>" + txt + "</html>"), (int)maxWidth));
        View view = BasicHTML.createHTMLView(this.promptLabel, this.promptLabel.getText());
        view.setSize(maxWidth, 2.1474836E9f);
        int minimumSpan = (int)view.getMinimumSpan(1);
        this.promptLabel.setPreferredSize(new Dimension(maxWidth, minimumSpan));
    }

    public PromptType getType() {
        return this.type;
    }

    public void setType(PromptType type) {
        this.type = type;
    }

    public static enum PromptType {
        LABEL("label"),
        RETDATA("retData");

        private String type = "";

        private PromptType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

