/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex.FlexConfigStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex.comp.ItemRow;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex.comp.RowPan;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.ComponetFactory;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.IInputComponent;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.InputItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexConfigStepLayout
extends AbstractBizStepLayout {
    private static final long serialVersionUID = -5443806693807724578L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexConfigStepLayout.class);
    private static final int WEIGTH_BOUNDS = 10;
    private static final int WIZARD_BLANK_SIZE = 45;
    private static final String STATIC_TEXT = "#StaticText#";
    private static final int BORDER_SIZE = 20;
    private static int gridy;
    private JLabel tipsText = new JLabel();
    private JPanel docLinkPanel = new JPanel();
    private JPanel inputPanel = new JPanel();
    private JPanel allPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private GridBagLayout inputLayout = new GridBagLayout();
    private JScrollPane inputScrollPane;
    private JCheckBox check = new JCheckBox();
    private JButton addBtn = new JButton();
    private JScrollBar vScrollBar;
    private Map<String, JComponent> realRowMap = new HashMap<String, JComponent>();

    public FlexConfigStepLayout(FlexConfigStepCfg flexCfg) {
        BizPackageContext.getInstance().getId2LayoutMap().put(flexCfg.getId(), this);
        this.initUi(flexCfg);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.tipsText, "tipsText");
        AutomateUtils.setNameAttribute(this.docLinkPanel, "docLinkPanel");
        AutomateUtils.setNameAttribute(this.inputPanel, "inputPanel_flexCfgStep");
        AutomateUtils.setNameAttribute(this.allPanel, "allPanel");
        AutomateUtils.setNameAttribute(this.buttonPanel, "buttonPanel");
        AutomateUtils.setNameAttribute(this.inputScrollPane, "inputScrollPane");
        AutomateUtils.setNameAttribute(this.check, "check_flexCfgStep");
        AutomateUtils.setNameAttribute(this.addBtn, "addBtn");
        AutomateUtils.setNameAttribute(this.vScrollBar, "vScrollBar");
    }

    public static int getGridy() {
        return gridy;
    }

    public static void setGridy() {
        ++gridy;
    }

    private void initUi(FlexConfigStepCfg flexCfg) {
        this.setBizCfg(flexCfg);
        JComponent view = null;
        ArrayList<Component> comps = new ArrayList<Component>();
        if (flexCfg.getGuideLinkGroup().getLinks().size() > 0) {
            flexCfg.getGuideLinkGroup().init();
            this.docLinkPanel = flexCfg.getGuideLinkGroup().getLinkPanel();
            comps.add(this.docLinkPanel);
        }
        comps.add(this.buildLeftRight(0, this.tipsText));
        boolean isGraphInMiddle = "middle".equalsIgnoreCase((String)flexCfg.getAllAtributeMap().getOrDefault("graphLoc", ""));
        boolean needAddButton = "true".equalsIgnoreCase((String)flexCfg.getAllAtributeMap().getOrDefault("needAddButton", "true"));
        if (isGraphInMiddle) {
            comps.add(this.initInputPane());
            comps.add(Box.createHorizontalStrut(4));
        } else {
            comps.add(this.initScrollPane(needAddButton));
        }
        if (!StringUtils.isNULLStr(flexCfg.getPromise())) {
            comps.add(this.buildLeftRight(0, this.check));
        }
        Component[] compArrs = comps.toArray(new Component[0]);
        if (isGraphInMiddle) {
            JComponent rightComp = UCD.buildVerticalBox(null, (Component[])compArrs);
            view = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(25), rightComp});
            this.setTopPanel(view);
            this.setViewInLayout(flexCfg, null, true);
        } else {
            view = UCD.buildVerticalBox(null, (Component[])compArrs);
            this.setViewInLayout(flexCfg, view, true);
        }
    }

    private JPanel buildLeftRight(int dir, JComponent comp) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        if (dir == 0) {
            jPanel.add(comp);
            jPanel.add(Box.createHorizontalGlue());
        } else {
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(comp);
        }
        return jPanel;
    }

    private JComponent initScrollPane(boolean needAddButton) {
        this.inputPanel.setLayout(this.inputLayout);
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.add((Component)this.inputPanel, "North");
        String btnText = ResourceUtil.getString("bizpack.wizard.flexconfig.addbutton.name");
        this.addBtn = UiMethod.createButton((String)btnText, (char)'A');
        this.addGridBagCopLeft(this.buttonPanel, this.addBtn, 0, gridy, 10);
        if (needAddButton) {
            this.allPanel.add((Component)this.buttonPanel, "West");
        }
        this.inputScrollPane = new JScrollPane();
        this.vScrollBar = this.inputScrollPane.getVerticalScrollBar();
        this.inputScrollPane.getViewport().add(this.allPanel);
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.inputScrollPane});
        return view;
    }

    private JComponent initInputPane() {
        this.inputPanel.setLayout(this.inputLayout);
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.add((Component)this.inputPanel, "North");
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.allPanel});
        return view;
    }

    public void init(FlexConfigStepCfg flexCfg) {
        this.inputPanel.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 10.0;
        constraints.weighty = 10.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.inputPanel.add(Box.createVerticalGlue(), constraints);
        this.inputPanel.repaint();
    }

    public void addRow(JComponent row) {
        this.inputPanel.remove(this.inputPanel.getComponentCount() - 1);
        this.addGridBagCopLeft(this.inputPanel, row, 0, gridy, 10);
        FlexConfigStepLayout.setGridy();
        this.inputPanel.repaint();
        this.inputScrollPane.repaint();
        this.inputScrollPane.revalidate();
        this.inputScrollPane.updateUI();
        this.inputScrollPane.getViewport().doLayout();
        this.vScrollBar.setValue(this.vScrollBar.getMaximum());
    }

    public void addInputItemRow(JComponent row) {
        this.inputPanel.remove(this.inputPanel.getComponentCount() - 1);
        this.addGridBagCopLeft(this.inputPanel, row, 0, gridy, 10);
        FlexConfigStepLayout.setGridy();
        this.inputPanel.repaint();
        this.inputPanel.updateUI();
        this.allPanel.updateUI();
    }

    public void removeRow(String rowKey) {
        if (!this.realRowMap.containsKey(rowKey)) {
            return;
        }
        this.inputPanel.remove(this.realRowMap.get(rowKey));
        this.inputPanel.repaint();
        this.inputScrollPane.repaint();
        this.inputScrollPane.revalidate();
        this.inputScrollPane.updateUI();
    }

    public JComponent createOneRow(ItemRow row) {
        LOGGER.info("create a row..");
        RowPan rowPan = new RowPan();
        List<InputItem> inputItems = row.getInputItems();
        Map<String, IInputComponent> rowCompsMap = row.getCompsMap();
        int gridx = 0;
        for (InputItem item : inputItems) {
            rowPan.addItem(this.createInputItem(item, rowCompsMap), gridx, 0, 0);
            ++gridx;
        }
        this.realRowMap.put(row.getRowKey(), rowPan);
        return rowPan;
    }

    public JComponent createOneInputRow(ItemRow row) {
        LOGGER.info("create a row with input items...");
        RowPan rowPan = new RowPan();
        List<InputItem> inputItems = row.getInputItems();
        Map<String, IInputComponent> rowCompsMap = row.getCompsMap();
        int gridx = 0;
        for (InputItem item : inputItems) {
            rowPan.addItem(this.createInputItem(item, rowCompsMap), gridx, 0, 0);
            ++gridx;
        }
        this.realRowMap.put(row.getRowKey(), rowPan);
        return rowPan;
    }

    private void addGridBagCopLeft(JComponent parent, JComponent comp, int gridx, int pGridy, int weightx) {
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.fill = 0;
        bagConstraints.anchor = 17;
        bagConstraints.gridx = gridx;
        bagConstraints.gridy = pGridy;
        bagConstraints.weightx = weightx;
        bagConstraints.weighty = 0.0;
        bagConstraints.insets = new Insets(0, 0, 0, 0);
        parent.add((Component)comp, bagConstraints);
        GridBagConstraints bagConstraints1 = new GridBagConstraints();
        bagConstraints1.fill = 0;
        bagConstraints1.anchor = 17;
        bagConstraints1.gridx = gridx + 1;
        bagConstraints1.gridy = pGridy;
        bagConstraints1.weightx = weightx;
        bagConstraints1.weighty = 0.0;
        bagConstraints1.insets = new Insets(0, 0, 0, 0);
        parent.add(Box.createHorizontalGlue(), bagConstraints1);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = gridx;
        constraints.gridy = pGridy + 1;
        constraints.weightx = weightx;
        constraints.weighty = 10.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        parent.add(Box.createVerticalGlue(), constraints);
    }

    private JComponent createInputItem(InputItem item, Map<String, IInputComponent> rowCompsMap) {
        String type = item.getType();
        if (type.equalsIgnoreCase("button")) {
            return this.createButton(item, rowCompsMap);
        }
        if (type.equalsIgnoreCase("text")) {
            return this.createTextField(item, rowCompsMap);
        }
        if (type.equalsIgnoreCase("dropdown")) {
            return this.createDropDown(item, rowCompsMap);
        }
        if (type.equalsIgnoreCase("label")) {
            return this.createLabel(item, rowCompsMap);
        }
        return new JPanel();
    }

    private JComponent createLabel(InputItem item, Map<String, IInputComponent> rowCompsMap) {
        JPanel labelPanel = new JPanel();
        String defaultString = item.getDefaultValue();
        String lableLayout = item.getLableLayout();
        IInputComponent label = ComponetFactory.getInstance().createComponent(item.getType(), item.getRule(), defaultString);
        label.setValue(defaultString);
        int lenth = item.getCompSpectLen();
        if (lenth > 0) {
            label.getComponent().setPreferredSize(new Dimension(lenth, 20));
        }
        this.setLayout(label.getComponent(), lableLayout);
        rowCompsMap.put(item.getId(), label);
        labelPanel.add(label.getComponent());
        return labelPanel;
    }

    private void setLayout(JComponent label, String lableLayout) {
        if (null == label) {
            return;
        }
        if ("center".equals(lableLayout)) {
            ((JLabel)label).setHorizontalAlignment(0);
        }
        if ("left".equals(lableLayout)) {
            ((JLabel)label).setHorizontalAlignment(2);
        }
        if ("right".equals(lableLayout)) {
            ((JLabel)label).setHorizontalAlignment(4);
        }
    }

    private JComponent createDropDown(InputItem item, Map<String, IInputComponent> rowCompsMap) {
        JPanel dropDownPanel = new JPanel();
        String rule = item.getRule();
        if (!StringUtils.isNULLStr(rule)) {
            rule = this.changeKey(rule);
        }
        String defaultValue = item.getDefaultValue();
        IInputComponent dropDownBox = ComponetFactory.getInstance().createComponent(item.getType(), rule, defaultValue);
        int lenth = item.getCompSpectLen();
        if (lenth > 0) {
            dropDownBox.getComponent().setPreferredSize(new Dimension(lenth, 20));
        }
        rowCompsMap.put(item.getId(), dropDownBox);
        dropDownPanel.add(dropDownBox.getComponent());
        return dropDownPanel;
    }

    private String changeKey(String ruleStr) {
        StringBuilder rulebBuilder = new StringBuilder();
        List<String> lanList = this.chg2language(ruleStr.split(","));
        if (!lanList.isEmpty()) {
            rulebBuilder.append(lanList.get(0));
        }
        for (int i = 1; i < lanList.size(); ++i) {
            rulebBuilder.append(",");
            rulebBuilder.append(lanList.get(i));
        }
        return rulebBuilder.toString();
    }

    private List<String> chg2language(String[] dropLists) {
        ArrayList<String> dropList = new ArrayList<String>();
        String[] stringArray = dropLists;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String dropKey;
            String dropOneKey = dropKey = stringArray[i];
            dropList.add(dropOneKey);
        }
        return dropList;
    }

    private JComponent createTextField(InputItem item, Map<String, IInputComponent> rowCompsMap) {
        IInputComponent text;
        JPanel textFieldPanel = new JPanel();
        String defaultString = item.getDefaultValue();
        boolean isStatic = false;
        if (defaultString.startsWith(STATIC_TEXT)) {
            isStatic = true;
            defaultString = defaultString.replace(STATIC_TEXT, "");
        }
        if ((text = ComponetFactory.getInstance().createComponent(item.getType(), item.getRule(), defaultString)).getComponent() instanceof IsmTextField) {
            IsmTextField ismTextField = (IsmTextField)text.getComponent();
            if (isStatic) {
                ismTextField.setEditable(false);
            }
        } else if (text.getComponent() instanceof IsmPasswordField) {
            IsmPasswordField ismPasswordField = (IsmPasswordField)text.getComponent();
            ismPasswordField.setMinValidRestrict(item.getMinContentLenght());
            ismPasswordField.setMaxValidRestrict(item.getMaxContentLenght());
        }
        int lenth = item.getCompSpectLen();
        if (lenth > 0) {
            text.getComponent().setPreferredSize(new Dimension(lenth, 20));
        }
        rowCompsMap.put(item.getId(), text);
        textFieldPanel.add(text.getComponent());
        return textFieldPanel;
    }

    private JComponent createButton(InputItem item, Map<String, IInputComponent> rowCompsMap) {
        JPanel buttonFieldPanel = new JPanel();
        String label = item.getLabel();
        IInputComponent button = ComponetFactory.getInstance().createComponent(item.getType(), item.getRule(), label);
        int lenth = item.getCompSpectLen();
        if (lenth > 0) {
            button.getComponent().setPreferredSize(new Dimension(lenth, 20));
        }
        rowCompsMap.put(item.getId(), button);
        buttonFieldPanel.add(button.getComponent());
        return buttonFieldPanel;
    }

    public void setTipsTxt(String ctipsTxt) {
        this.setJLabelText(this.tipsText, ctipsTxt, 45);
    }

    public JButton getAddBtn() {
        return this.addBtn;
    }

    public void setAddBtn(JButton addBtn) {
        this.addBtn = addBtn;
    }

    public JCheckBox getCheck() {
        return this.check;
    }

    public void setCheck(JCheckBox check) {
        this.check = check;
    }

    public JPanel getInputPanel() {
        return this.inputPanel;
    }

    public JScrollPane getInputScrollPane() {
        return this.inputScrollPane;
    }

    public void setInputScrollPane(JScrollPane inputScrollPane) {
        this.inputScrollPane = inputScrollPane;
    }

    public Map<String, JComponent> getRealRowMap() {
        return this.realRowMap;
    }

    public void setRealRowMap(Map<String, JComponent> realRowMap) {
        this.realRowMap = realRowMap;
    }
}

