/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec.item;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec.MultiDevExecStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec.item.ErrorMsgItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.framework.platform.util.HtmlEnums;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorInfoDialogLayout
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiDevExecStep.class);
    private static final long serialVersionUID = 1233165196286096599L;
    private static final String NEWLINE = "\n";
    private static final String HTTP = "http:";
    private static final String WWW = "www.";
    private static final String HTTPS = "https:";
    private static final int WIDTH = 450;
    private static final int REFPAN_HEIGHT = 150;
    private static final int RESULTPAN_HEIGHT = 60;
    private static final String HTML_PAGE_CONRENTTYPE = "text/html;charset=\"UTF-8\"";
    private JButton close = UiMethod.createButton((String)ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.button.close"));
    private JEditorPane reference = new JEditorPane();
    private JTextArea result = new JTextArea(ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.result.tip"));
    private JScrollPane refPan = new JScrollPane(this.reference);
    private JScrollPane resultPan = new JScrollPane(this.result);
    private ToolHyperLinkLabel showMore = new ToolHyperLinkLabel(ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.linkLabel"));
    private String showMoreText = "";

    public ErrorInfoDialogLayout() {
        JLabel refLabel = new JLabel(ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.refer.tip"));
        JLabel retLabel = new JLabel(ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.result.tip2"));
        this.refPan = new JScrollPane(this.reference);
        this.resultPan = new JScrollPane(this.result);
        UiMethod.setComponentSize((Dimension)new Dimension(450, 150), (Component[])new Component[]{this.refPan});
        UiMethod.setComponentSize((Dimension)new Dimension(450, 60), (Component[])new Component[]{this.resultPan});
        JComponent pan = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)refLabel), this.refPan, UCD.buildHorizontalBoxLeft((Component)retLabel), this.resultPan, UCD.buildHorizontalBoxLeft((Component)this.showMore), UCD.buildHBoxRight((Component[])new Component[]{this.close})});
        this.reference.setEditable(false);
        this.reference.setMargin(this.getTextInset());
        this.result.setMargin(this.getTextInset());
        this.reference.setFocusable(true);
        this.result.setFocusable(true);
        this.result.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)pan, (int)12), "North");
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.close, "close");
        AutomateUtils.setNameAttribute(this.reference, "reference");
        AutomateUtils.setNameAttribute(this.result, "result");
        AutomateUtils.setNameAttribute(this.refPan, "refPan");
        AutomateUtils.setNameAttribute(this.resultPan, "resultPan");
        AutomateUtils.setNameAttribute((Component)this.showMore, "showMore");
    }

    private void scorll2top() {
        this.reference.setCaretPosition(0);
        this.result.setCaretPosition(0);
    }

    private Insets getTextInset() {
        return new Insets(0, 5, 0, 0);
    }

    public void setValue(ErrorMsgItem item) {
        List<Map<String, String>> errInfoList = item.getErrInfo();
        StringBuffer refText = this.buildRefText(errInfoList);
        this.setReferenceParams(refText);
        String ret = this.buildRetText(item);
        this.result.setText(ret);
        this.result.setLineWrap(true);
        this.result.setWrapStyleWord(true);
        this.showMoreText = item.getSourceInfo();
        this.scorll2top();
    }

    private StringBuffer buildRefText(List<Map<String, String>> errInfoList) {
        StringBuffer refText = new StringBuffer();
        StringBuffer context = new StringBuffer();
        refText.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" ").append("\"").append(HtmlEnums.XHTML_TRANSITIONAL.getResourceValue()).append("\">").append(System.lineSeparator()).append("<html xmlns=\"").append(HtmlEnums.XHTML.getResourceValue()).append("\">").append(System.lineSeparator()).append("<head>").append(System.lineSeparator()).append("<style type= \"text/css\">").append("body{ font-size:9px;color:#464646;}").append("spn{font-size:13px;color:#ffffff;font-weight:bold;font-style:italic;}").append("selected::selection{color:#ffffff;background:#990000;}").append("selected::-moz-selection{background:#990000;}").append("</style>").append(System.lineSeparator()).append("</head>").append(System.lineSeparator()).append("<body>").append(System.lineSeparator());
        if (errInfoList != null) {
            for (Map<String, String> errInfo : errInfoList) {
                String title = errInfo.get("title");
                String content = errInfo.get("content");
                context.append("<span><b>").append(title).append("</b></span>").append(NEWLINE).append(content).append(NEWLINE).append(NEWLINE);
            }
        }
        refText.append(context.toString().replaceAll(NEWLINE, "<br>"));
        refText.append("<br><br></body>");
        refText.append("</html>");
        return refText;
    }

    private void setReferenceParams(StringBuffer refText) {
        try {
            this.reference.setContentType(HTML_PAGE_CONRENTTYPE);
            this.reference.setText(refText.toString());
            this.reference.setEditable(false);
            this.reference.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent ev) {
                    ErrorInfoDialogLayout.this.doHyperLinkEvent(ev);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            this.reference.setContentType(HTML_PAGE_CONRENTTYPE);
            this.reference.setText(refText.toString());
            this.reference.setEditable(false);
            this.reference.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    ErrorInfoDialogLayout.this.doHyperLinkEvent(event);
                }
            });
        }
    }

    private String buildRetText(ErrorMsgItem item) {
        String ret = "";
        ItemResult rec = item.getResult();
        if (rec.equals((Object)ItemResult.FAILED)) {
            ret = ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.return.failure");
            ret = this.showErrorMsg(item, ret);
        } else if (rec.equals((Object)ItemResult.NOT_PASS)) {
            ret = ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.return.nopass");
            ret = this.showErrorMsg(item, ret);
        } else if (rec.equals((Object)ItemResult.SUCCEED)) {
            ret = ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.return.success");
            ret = this.showErrorMsg(item, ret);
        } else if (rec.equals((Object)ItemResult.PASS)) {
            ret = ResourceUtil.getString("bizpack.wizard.multiexec.errInfo.return.pass");
            ret = this.showErrorMsg(item, ret);
        }
        return ret;
    }

    private String showErrorMsg(ErrorMsgItem rec, String ret) {
        return ret + NEWLINE + NEWLINE + rec.getErrorInfo();
    }

    public JButton getClose() {
        return this.close;
    }

    public ToolHyperLinkLabel getShowMore() {
        return this.showMore;
    }

    public String getShowMoreText() {
        return this.showMoreText;
    }

    private void doHyperLinkEvent(HyperlinkEvent event) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType())) {
            String helpFileStr = event.getDescription();
            try {
                if (helpFileStr.startsWith(HTTP) || helpFileStr.startsWith(HTTPS) || helpFileStr.startsWith(WWW)) {
                    FileUtils.openHtmlFile((String)helpFileStr);
                } else {
                    OSCmdUtils.explorerFile((File)new File(helpFileStr));
                }
            }
            catch (Exception ex) {
                LOGGER.error("open the file failed", (Throwable)ex);
            }
        }
    }
}

