/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.InputItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.ItemGroup;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PreSettingStepCfg
extends BizStepConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreSettingStepCfg.class);
    private static final String INPUT_ITEM_GROUP = "input-item-group";
    private static final String AUTOID = "autoId_";
    private static final String INPUT_ITEM = "input-item";
    private static final String SEP = "seperator";
    private static int defaultGroupID;
    private Map<String, ItemGroup> itemsGroup = new HashMap<String, ItemGroup>();
    private List<String> inputGroups = new ArrayList<String>();
    private boolean endLoading = false;
    private boolean initLoading = false;

    public static int getDefaultGroupID() {
        return defaultGroupID;
    }

    public static void setDefaultGroupID() {
        ++defaultGroupID;
    }

    @Override
    public void loadConfig(Element node) {
        String initLoadingStr;
        String endLoadingStr;
        this.setId(this.getAttribute(node, "id", ""));
        this.setDescription(this.getAttribute(node, "desc", ""));
        this.setTitle(this.getAttribute(node, "title", ""));
        this.setScriptFile(this.getAttribute(node, "script", ""));
        this.setPromise(this.getAttribute(node, "promise", ""));
        this.setPrompt(this.getAttribute(node, "prompt", ""));
        this.setCancelScript(this.getAttribute(node, "cancelScript", ""));
        this.setParam(this.getAttribute(node, "param", ""));
        String auto = this.getAttribute(node, "auto", "");
        if (auto.equalsIgnoreCase("true")) {
            this.setAuto(true);
        }
        if ((endLoadingStr = this.getAttribute(node, "endLoading", "")).equalsIgnoreCase("true")) {
            this.setEndLoading(true);
        }
        if ((initLoadingStr = this.getAttribute(node, "initLoading", "")).equalsIgnoreCase("true")) {
            this.setInitLoading(true);
        }
        String backwardStr = this.getAttribute(node, "backward", "");
        this.setBackwardValue(backwardStr);
        NodeList nodeList = node.getElementsByTagName(INPUT_ITEM_GROUP);
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        int length = nodeList.getLength();
        this.checkItemGroup(nodeList, length);
        this.parseCommon(node);
    }

    void checkItemGroup(NodeList nodeList, int length) {
        for (int index = 0; index < length; ++index) {
            Element nodeElement = (Element)nodeList.item(index);
            String groupKey = this.getAttribute(nodeElement, "name", "");
            String groupScript = this.getAttribute(nodeElement, "script", "");
            String groupParam = this.getAttribute(nodeElement, "param", "");
            String layoutStr = this.getAttribute(nodeElement, "layout", "");
            ItemGroup itemGroup = new ItemGroup();
            itemGroup.setScript(groupScript);
            itemGroup.setParam(groupParam);
            itemGroup.setLayout(layoutStr);
            ArrayList<InputItem> inputItemList = new ArrayList<InputItem>();
            if (StringUtils.isNULLStr(groupScript)) {
                this.loadOneGroup(nodeElement, inputItemList);
                itemGroup.setInputItems(inputItemList);
            }
            if (StringUtils.isNULLStr(groupKey)) {
                groupKey = AUTOID + defaultGroupID;
                PreSettingStepCfg.setDefaultGroupID();
            }
            this.itemsGroup.put(groupKey, itemGroup);
            this.inputGroups.add(groupKey);
        }
    }

    private void loadOneGroup(Element node, List<InputItem> inputItemList) {
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        NodeList nodeList = node.getElementsByTagName(INPUT_ITEM);
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Element nodeElement = (Element)nodeList.item(index);
            InputItem inputItem = new InputItem();
            String textContent = nodeElement.getTextContent();
            if (!"".equals(textContent) && null != textContent && textContent.equals(SEP)) {
                inputItem.setType(SEP);
                inputItemList.add(inputItem);
                continue;
            }
            if (!"".equals(textContent) && null != textContent && textContent.contains(SEP)) {
                inputItem.setType(textContent);
                inputItemList.add(inputItem);
                continue;
            }
            inputItemList.add(this.loadOneInputItem(nodeElement, resutil));
        }
    }

    private InputItem loadOneInputItem(Element nodeElement, PackagesResource resutil) {
        String maxContentLenghtStr;
        String minContentLenghtStr;
        String refreshId;
        InputItem inputItem = new InputItem();
        inputItem.setId(this.getAttribute(nodeElement, "id", ""));
        inputItem.setType(this.getAttribute(nodeElement, "type", ""));
        inputItem.setLabel(this.getAttribute(nodeElement, "label", ""));
        inputItem.setRule(this.getAttribute(nodeElement, "rule", ""));
        inputItem.setDefaultValue(this.getAttribute(nodeElement, "default", ""));
        String defaultValueKey = this.getAttribute(nodeElement, "defaultKey", "");
        if (!StringUtils.isNULLStr(defaultValueKey)) {
            inputItem.setDefaultValue(resutil.getString(defaultValueKey));
        }
        inputItem.setInitSript(this.getAttribute(nodeElement, "initScript", ""));
        inputItem.setInitParam(this.getAttribute(nodeElement, "param", ""));
        String lenStr = this.getAttribute(nodeElement, "length", "");
        if (!StringUtils.isNULLStr(lenStr)) {
            inputItem.setCompSpectLen(Integer.valueOf(lenStr));
        }
        if (!(refreshId = this.getAttribute(nodeElement, "refreshItems", "")).equals("")) {
            String[] refreshIds = refreshId.split(",");
            List<String> refreshList = Arrays.asList(refreshIds);
            inputItem.setRefreshItems(refreshList);
        }
        if (!StringUtils.isNULLStr(minContentLenghtStr = this.getAttribute(nodeElement, "minContentLength", ""))) {
            int min = 1;
            try {
                min = Integer.parseInt(minContentLenghtStr);
            }
            catch (Exception e) {
                LOGGER.error("parse int failed.", (Throwable)e);
            }
            inputItem.setMinContentLenght(min);
        }
        if (!StringUtils.isNULLStr(maxContentLenghtStr = this.getAttribute(nodeElement, "maxContentLength", ""))) {
            int max = 15;
            try {
                max = Integer.parseInt(maxContentLenghtStr);
            }
            catch (Exception e) {
                LOGGER.error("parse int failed.", (Throwable)e);
            }
            inputItem.setMaxContentLenght(max);
        }
        return inputItem;
    }

    public Map<String, ItemGroup> getItemsGroup() {
        return this.itemsGroup;
    }

    public List<String> getInputGroups() {
        return this.inputGroups;
    }

    public boolean isEndLoading() {
        return this.endLoading;
    }

    public void setEndLoading(boolean endLoading) {
        this.endLoading = endLoading;
    }

    public boolean isInitLoading() {
        return this.initLoading;
    }

    public void setInitLoading(boolean initLoading) {
        this.initLoading = initLoading;
    }
}

