/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.util;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.DevMap;
import com.huawei.ism.tool.bizpack.wizardparse.intf.BizPackageProcessUIImpl;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectGroupWizardDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectWizardDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.ParseOneProductDetailWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;
import utils.Products;

public class DevNodeUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BizPackageProcessUIImpl.class);
    private static final int BUSY_BOX_WIDTH_ZH = 230;
    private static final int BUSY_BOX_WIDTH_EN = 250;

    public static Map<String, String> getDevMapDict(DevNode dev) {
        DevMap<String, String> devMapDict = new DevMap<String, String>();
        devMapDict.put("sn", dev.getDeviceSerialNumber());
        devMapDict.put("type", dev.getDeviceType().toString());
        devMapDict.put("version", dev.getProductVersion());
        devMapDict.put("name", dev.getDeviceName());
        devMapDict.put("ip", dev.getIp());
        devMapDict.put("sshPort", String.valueOf(dev.getPort()));
        devMapDict.put("tlvPort", "0");
        devMapDict.put("user", dev.getLoginUser().getUserName());
        String pwd = dev.getLoginUser().getPassword();
        devMapDict.put("pawd", pwd);
        String debugPwd = dev.getDeveloperPwd();
        devMapDict.put("devPassword", debugPwd);
        devMapDict.put("devInnerIpList", DevNodeUtil.buildIpListStr(dev.getIpList()));
        return devMapDict;
    }

    public static String buildIpListStr(List<String> ipList) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ipList.size(); ++i) {
            String ip = ipList.get(i);
            if (StringUtils.isNULLStr(ip)) continue;
            builder.append(ip);
            if (i >= ipList.size() - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static boolean matchingBizpackage(DevNode node) {
        List<BizPackage> allPackages = BizPackageContext.getInstance().getBizPackages();
        BizPackage bizPackageFinal = null;
        int verMatchLen = 0;
        for (BizPackage bizPackage : allPackages) {
            List<PackProduct> products = bizPackage.getPackProducts();
            for (PackProduct packProduct : products) {
                verMatchLen = DevNodeUtil.matchOneProduct(node, packProduct, verMatchLen);
                if (verMatchLen <= 0) continue;
                bizPackageFinal = bizPackage;
            }
        }
        if (null == bizPackageFinal) {
            return false;
        }
        BizPackageContext.getInstance().setCurBizPackage(bizPackageFinal);
        return true;
    }

    private static int matchOneProduct(DevNode node, PackProduct packProduct, int matchLen) {
        if (!node.getDeviceType().toString().trim().equals(packProduct.getProductName().trim())) {
            return -1;
        }
        for (String version : packProduct.getVersions()) {
            if (!Products.contains((String)version, (String)node.getProductVersion()) && !Products.contains((String)node.getProductVersion(), (String)version) || version.length() <= matchLen) continue;
            return version.length();
        }
        return -1;
    }

    public static void parseAndBuildDialog(JDialog parentDlg) {
        ProgressDialog progressDialog = new ProgressDialog((Window)parentDlg, ResourceUtil.getString("connecting.dev.and.parse.info"), BizPackageSceneUtils.isChineseLanguage() ? 230 : 250);
        List fs = AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{new ParseOneProductDetailWaitDialog()});
        WaitDialogResult parseRessult = (WaitDialogResult)fs.get(0);
        if (!parseRessult.isFlag()) {
            DialogUtils.showErrorDialog((JDialog)parentDlg, (String)parseRessult.getErrMsg());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("build dialog failed. " + parseRessult.getErrMsg());
            }
            if (BizPackageSceneUtils.isScene()) {
                String toolId = BizPackageContext.getInstance().getCurToolName();
                ApplicationContext.getInstance().fireToolStopped(toolId);
            }
            return;
        }
        if (!BizPackageContext.getInstance().getCurBizPackage().isGroupType()) {
            SelectWizardDialog dialog = new SelectWizardDialog(null);
            if (null != parentDlg) {
                parentDlg.dispose();
            }
            SwingUtil.putScreenCenter((Window)dialog);
            dialog.setResizable(false);
            dialog.setVisible(true);
        } else {
            SelectGroupWizardDialog dialog = new SelectGroupWizardDialog(null);
            if (null != parentDlg) {
                parentDlg.dispose();
            }
            SwingUtil.putScreenCenter((Window)dialog);
            dialog.setResizable(false);
            dialog.setVisible(true);
        }
    }
}

