/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JLabel;

public class ToolHyperLinkLabel
extends JLabel {
    private static final long serialVersionUID = -1235495322638840293L;
    private static final Color COLOR_BEFORE_CLICK_BLUE = new Color(4359891);
    private static final Color COLOR_BEFORE_CLICK_BLACK = new Color(0x333333);
    private static final Color COLOR_MOUSE_OVER = new Color(16542473);
    private static final Color COLOR_AFTER_CLICK = new Color(7581426);
    private ClickListener clickListener = null;
    private Color colorBeforeClick;

    public ToolHyperLinkLabel() {
        this("");
    }

    public ToolHyperLinkLabel(String text) {
        this(text, true);
    }

    public ToolHyperLinkLabel(String text, boolean isMainButton) {
        super(text);
        this.colorBeforeClick = isMainButton ? COLOR_BEFORE_CLICK_BLUE : COLOR_BEFORE_CLICK_BLACK;
        this.setForeground(this.colorBeforeClick);
        this.addMouseListener(new LinkMouseListener());
    }

    public void addClickListener(ClickListener listener) {
        this.clickListener = listener;
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    public static abstract class ClickAdapter
    implements ClickListener,
    ActionListener {
        private static final long serialVersionUID = -3994541621360055282L;

        @Override
        public void clickLink(MouseEvent e) {
            this.actionPerformed(null);
        }

        @Override
        public abstract void actionPerformed(ActionEvent var1);
    }

    public static interface ClickListener
    extends Serializable {
        public void clickLink(MouseEvent var1);
    }

    private class LinkMouseListener
    extends MouseAdapter {
        private Color curColor;

        private LinkMouseListener() {
            this.curColor = ToolHyperLinkLabel.this.colorBeforeClick;
        }

        @Override
        public void mouseClicked(MouseEvent paramMouseEvent) {
            if (!ToolHyperLinkLabel.this.isEnabled()) {
                return;
            }
            ToolHyperLinkLabel.this.setForeground(COLOR_AFTER_CLICK);
            if (null != ToolHyperLinkLabel.this.clickListener) {
                ToolHyperLinkLabel.this.clickListener.clickLink(paramMouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent paramMouseEvent) {
            ToolHyperLinkLabel.this.setCursor(new Cursor(12));
            ToolHyperLinkLabel.this.setForeground(COLOR_MOUSE_OVER);
        }

        @Override
        public void mouseExited(MouseEvent paramMouseEvent) {
            ToolHyperLinkLabel.this.setForeground(this.curColor);
        }
    }
}

