/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component;

import com.huawei.ism.tool.base.ui.component.FuncItem;
import com.huawei.ism.tool.base.ui.component.LineStylePanel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ToolRightPanel
extends JPanel {
    public static final String BUNDLE_ID_MAINTAINER = "maintainer";
    public static final String BUNDLE_ID_UPGRADE = "upgrade";
    public static final String BUNDLE_ID_DEPLOY = "deploy";
    private static final long serialVersionUID = 1L;
    private static final int FUNCITME_LEFT_GAP = 17;
    private static final int FUNCITME_TOP_GAP = 19;
    List<JPanel> panelList = new ArrayList<JPanel>();
    private List<FuncItem> funcItems = new ArrayList<FuncItem>();
    private List<FuncItem> funcItemsMaint = new ArrayList<FuncItem>();
    private List<FuncItem> funcItemsUpg = new ArrayList<FuncItem>();
    private List<FuncItem> funcItemsDep = new ArrayList<FuncItem>();
    private Map<String, JPanel> panelMap = new HashMap<String, JPanel>();
    private JPanel panel;
    private JPanel topDeployPanel;
    private JPanel middleMaintPanel;
    private JPanel buttomUpgradePanel;

    public ToolRightPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
    }

    public void addFuncItems(List<FuncItem> items) {
        this.funcItems.addAll(items);
        this.showFuncItems();
    }

    public void addFuncItemsAll(Map<String, List<FuncItem>> allFuncItem) {
        for (String id : allFuncItem.keySet()) {
            if (BUNDLE_ID_DEPLOY.equals(id)) {
                String deployString = ResourceUtil.getString("toolbox.all.deploy");
                this.funcItemsDep.addAll((Collection<FuncItem>)allFuncItem.get(BUNDLE_ID_DEPLOY));
                this.topDeployPanel = this.getPanel(id, deployString, this.funcItemsDep);
                this.panelMap.put(id, this.topDeployPanel);
                continue;
            }
            if (BUNDLE_ID_MAINTAINER.equals(id)) {
                String mainterString = ResourceUtil.getString("toolbox.all.maintainer");
                this.funcItemsMaint.addAll((Collection<FuncItem>)allFuncItem.get(BUNDLE_ID_MAINTAINER));
                this.middleMaintPanel = this.getPanel(id, mainterString, this.funcItemsMaint);
                this.panelMap.put(id, this.middleMaintPanel);
                continue;
            }
            if (!BUNDLE_ID_UPGRADE.equals(id)) continue;
            String upgradeString = ResourceUtil.getString("toolbox.all.upgrade");
            this.funcItemsUpg.addAll((Collection<FuncItem>)allFuncItem.get(BUNDLE_ID_UPGRADE));
            this.buttomUpgradePanel = this.getPanel(id, upgradeString, this.funcItemsUpg);
            this.panelMap.put(id, this.buttomUpgradePanel);
        }
        if (null != this.topDeployPanel) {
            this.topDeployPanel.setBackground(Color.WHITE);
            this.panelList.add(this.topDeployPanel);
        }
        if (null != this.middleMaintPanel) {
            this.middleMaintPanel.setBackground(Color.WHITE);
            this.panelList.add(this.middleMaintPanel);
        }
        if (null != this.buttomUpgradePanel) {
            this.buttomUpgradePanel.setBackground(Color.WHITE);
            this.panelList.add(this.buttomUpgradePanel);
        }
        this.add((Component)this.paintTools(this.panelList), "North");
    }

    private JPanel paintTools(List<JPanel> jPanelList) {
        JPanel maxPanel = new JPanel();
        maxPanel.setOpaque(false);
        maxPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridbc = this.getGridBagConstraints();
        for (JPanel jPanel : jPanelList) {
            maxPanel.add((Component)jPanel, gridbc);
            ++gridbc.gridy;
        }
        return maxPanel;
    }

    private JPanel getPanel(String id, String labelString, List<FuncItem> funcItemList) {
        JPanel jPanel = null == this.panelMap.get(id) ? new JPanel() : this.panelMap.get(id);
        jPanel.setLayout(new BorderLayout());
        LineStylePanel labelPanel = new LineStylePanel(labelString);
        JComponent vComp = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{Box.createVerticalStrut(8), labelPanel});
        JComponent hComp = UCD.buildHorizotalBox(null, (int)12, (Component[])new Component[]{Box.createHorizontalStrut(8), vComp, Box.createHorizontalStrut(8)});
        jPanel.add((Component)hComp, "North");
        JPanel panelSub = new JPanel();
        panelSub.setLayout(new GridBagLayout());
        panelSub.setOpaque(false);
        GridBagConstraints gbc = this.getGridBagConstraints();
        gbc.insets = new Insets(19, 17, 0, 17);
        for (FuncItem item : funcItemList) {
            panelSub.add((Component)item, gbc);
            ++gbc.gridx;
            if (gbc.gridx != 2) continue;
            gbc.gridx = 0;
            ++gbc.gridy;
        }
        jPanel.add((Component)panelSub, "Center");
        return jPanel;
    }

    public void showFuncItems() {
        if (null != this.panel) {
            this.remove(this.panel);
        }
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.getGridBagConstraints();
        gbc.insets = new Insets(19, 17, 0, 17);
        for (FuncItem item : this.funcItems) {
            this.panel.add((Component)item, gbc);
            ++gbc.gridy;
            gbc.insets.top = 0;
        }
        this.setBorder(new EmptyBorder(3, 3, 5, 0));
        this.add((Component)this.panel, "North");
    }

    private GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        return gbc;
    }

    @Override
    public String getUIClassID() {
        return "ToolRightPanelUI";
    }
}

