/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.checkboxtree;

import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckLabelPanel;
import com.huawei.ism.tool.base.ui.component.checkboxtree.CheckTreeNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class CheckTreeNodeRenderer
extends CheckLabelPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = -4607698747503207061L;
    private boolean isHook;
    private boolean checkBoxHook;
    private boolean hasCheckBox = true;

    public CheckTreeNodeRenderer(boolean hasCheckBox) {
        super(hasCheckBox);
        this.hasCheckBox = hasCheckBox;
        this.isHook = false;
        this.checkBoxHook = false;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        CheckLabelPanel checkLabelPanel = new CheckLabelPanel(this.hasCheckBox);
        CheckTreeNode node = (CheckTreeNode)value;
        checkLabelPanel.setHasCheckBox(node.isHasCheckBox());
        checkLabelPanel.setEnabled(tree.isEnabled());
        if (checkLabelPanel.getCheckBox() != null) {
            checkLabelPanel.getCheckBox().setSelected(node.isSelected());
            checkLabelPanel.getCheckBox().setPartialSelected(node.isPartSelect());
            checkLabelPanel.getCheckBox().setEnabled(((CheckTreeNode)value).isCheckEnable());
            if (this.checkBoxHook) {
                checkLabelPanel.getCheckBox().setOpaque(true);
                checkLabelPanel.getCheckBox().setEnabled(this.isHook);
            } else {
                checkLabelPanel.getCheckBox().setBackground(null);
                checkLabelPanel.getCheckBox().setEnabled(true);
            }
        }
        if (checkLabelPanel.getTreeLabel() != null) {
            checkLabelPanel.getTreeLabel().setFont(tree.getFont());
            checkLabelPanel.getTreeLabel().setText(stringValue);
            checkLabelPanel.getTreeLabel().setSelected(node.isHilight() || hasFocus);
            if (this.checkBoxHook) {
                checkLabelPanel.getTreeLabel().setOpaque(true);
            } else {
                checkLabelPanel.getTreeLabel().setOpaque(false);
            }
            Icon icon = this.getLabelIcon(node);
            if (null != icon) {
                checkLabelPanel.getTreeLabel().setIcon(icon);
            } else {
                checkLabelPanel.getTreeLabel().setIcon(null);
            }
        }
        return checkLabelPanel;
    }

    protected Icon getLabelIcon(CheckTreeNode node) {
        return null;
    }
}

