/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.wizard;

import com.huawei.ism.tool.base.flow.ui.Title;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolIconLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class WizardGuidePanel
extends JPanel {
    private static final long serialVersionUID = -1447517738382139080L;
    private JLabel stepTitle = new JLabel();
    private JTextArea stepDesc = new JTextArea();
    private static final int MAX_STEP_NUM = 8;
    private static final int MAX_TODO_STEP_NUM = 3;
    private String curSteptitle;
    private int curDisplayTitleIndex = -1;
    private int curStepTitleIndex = -1;
    private int startStepIndex = 0;
    private Locale locale;
    private List<Title> stageTitles;
    private List<String> displayStageTitles = new ArrayList<String>();
    private JLabel leftLabel = new JLabel();
    private JLabel rightLabel = new JLabel();
    private JPanel title = new JPanel();
    private JPanel progressPanel = new JPanel();
    private List<ToolIconLabel> progressNodes = new ArrayList<ToolIconLabel>();
    private List<JComponent> progressLines = new ArrayList<JComponent>();
    private List<JComponent> progressTitles = new ArrayList<JComponent>();
    private Map<String, ImageIcon> statusIconMap = new HashMap<String, ImageIcon>();
    private static final Color COLOR_TODO = new Color(226, 226, 226);
    private static final Color COLOR_DONE = new Color(71, 177, 45);
    private static final Color PROGRESS_BACK_COLOR = Color.WHITE;
    private static final Dimension TITLE_SZIE = new Dimension(900, 80);
    private Border borderTodo = BorderFactory.createLineBorder(COLOR_TODO, 4);
    private Border borderDone = BorderFactory.createLineBorder(COLOR_DONE, 4);

    public WizardGuidePanel() {
    }

    public WizardGuidePanel(String title, String desc, Locale locale, List<Title> stageTitles) {
        this.stageTitles = stageTitles;
        this.curSteptitle = title;
        this.locale = locale;
        this.addListener();
    }

    public String getCurSteptitle() {
        return this.curSteptitle;
    }

    public void setCurSteptitle(String curSteptitle) {
        this.curSteptitle = curSteptitle;
    }

    public int getCurStepTitleIndex() {
        return this.curStepTitleIndex;
    }

    public void setCurStepTitleIndex(int curStepTitleIndex) {
        this.curStepTitleIndex = curStepTitleIndex;
    }

    public void setTitle(String title) {
        this.stepTitle.setText(title);
    }

    public void setDesc(String desc) {
        this.stepDesc.setText(desc);
    }

    private JLabel getStepTitleLabel(String t) {
        JLabel jTitle = new JLabel();
        jTitle.setHorizontalAlignment(0);
        jTitle.setVerticalAlignment(1);
        jTitle.setForeground(new Color(102, 209, 149));
        if (Locale.CHINESE.equals(this.locale) || Locale.SIMPLIFIED_CHINESE.equals(this.locale)) {
            jTitle.setPreferredSize(new Dimension(120, 40));
            jTitle.setFont(new Font("\u5b8b\u4f53", 1, 11));
        } else {
            jTitle.setPreferredSize(new Dimension(110, 40));
            jTitle.setFont(new Font("Arial", 1, 11));
        }
        jTitle.setText(t);
        return jTitle;
    }

    private void initStatusIconMap() {
        this.statusIconMap.put("todo", ResourceUtil.getImage("phase_todo.png"));
        this.statusIconMap.put("running", ResourceUtil.getImage("phase_running.gif"));
        this.statusIconMap.put("done", ResourceUtil.getImage("phase_done.png"));
    }

    private void initDisplayTitles() {
        if (this.stageTitles.size() <= 8) {
            this.curDisplayTitleIndex = this.curStepTitleIndex;
            for (Title t : this.stageTitles) {
                this.displayStageTitles.add(t.getName(this.locale));
            }
        } else {
            int curIndex = this.getCurStepTitleIndex();
            int endIndex = curIndex + 3;
            int lastNum = endIndex > this.stageTitles.size() ? this.stageTitles.size() : endIndex;
            int startIndex = lastNum > 8 ? this.stageTitles.size() - 8 : 0;
            this.setStartStepIndex(startIndex);
            this.curDisplayTitleIndex = this.curStepTitleIndex - startIndex;
            for (int i = startIndex; i < startIndex + 8; ++i) {
                this.displayStageTitles.add(this.stageTitles.get(i).getName(this.locale));
            }
        }
    }

    private void updateDisplayTitles() {
        this.curDisplayTitleIndex = this.curStepTitleIndex - this.startStepIndex;
        for (int i = this.startStepIndex; i < this.startStepIndex + 8 && i < this.stageTitles.size(); ++i) {
            this.displayStageTitles.add(this.stageTitles.get(i).getName(this.locale));
        }
    }

    private void initProgressTitles() {
        for (int i = 0; i < this.displayStageTitles.size(); ++i) {
            JSeparator separator = new JSeparator();
            separator.setForeground(PROGRESS_BACK_COLOR);
            separator.setBackground(PROGRESS_BACK_COLOR);
            JComponent component = UCD.buildHorizotalBox(null, (int)-1, (Component[])new Component[]{separator, this.getStepTitleLabel(this.displayStageTitles.get(i)), separator});
            this.progressTitles.add(component);
        }
    }

    private void initProgressNodes() {
        for (int i = 0; i < this.displayStageTitles.size(); ++i) {
            if (i < this.curDisplayTitleIndex) {
                this.progressNodes.add(new ToolIconLabel(this.statusIconMap.get("done")));
                continue;
            }
            if (i == this.curDisplayTitleIndex) {
                this.progressNodes.add(new ToolIconLabel(this.statusIconMap.get("running")));
                continue;
            }
            this.progressNodes.add(new ToolIconLabel(this.statusIconMap.get("todo")));
        }
    }

    private void initProgressLines() {
        int maxNum = this.displayStageTitles.size() * 2;
        for (int i = 0; i < maxNum; ++i) {
            JSeparator separator = new JSeparator();
            if (i > 0 && i < maxNum - 1) {
                separator.setForeground(COLOR_TODO);
                separator.setBackground(COLOR_TODO);
                if (i <= this.curDisplayTitleIndex * 2) {
                    separator.setBorder(this.borderDone);
                } else {
                    separator.setBorder(this.borderTodo);
                }
            } else {
                separator.setForeground(PROGRESS_BACK_COLOR);
                separator.setBackground(PROGRESS_BACK_COLOR);
            }
            JComponent component = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalStrut(12), separator, Box.createVerticalStrut(13)});
            this.progressLines.add(component);
        }
    }

    private void updateLeftLabel() {
        this.leftLabel.setHorizontalAlignment(0);
        if (this.startStepIndex <= 0) {
            this.leftLabel.setIcon(ResourceUtil.getImage("leftButton_gray.png"));
        } else {
            this.leftLabel.setIcon(ResourceUtil.getImage("leftButton.png"));
        }
    }

    private void updateRightLabel() {
        this.rightLabel.setHorizontalAlignment(0);
        int curIndex = this.startStepIndex + this.displayStageTitles.size();
        if (curIndex >= this.stageTitles.size() - 1) {
            this.rightLabel.setIcon(ResourceUtil.getImage("rightButton_gray.png"));
        } else {
            this.rightLabel.setIcon(ResourceUtil.getImage("rightButton.png"));
        }
    }

    private void initTitle() {
        this.title.setPreferredSize(TITLE_SZIE);
        this.title.setLayout(new GridBagLayout());
        GridBagConstraints gConst = new GridBagConstraints();
        if (Locale.CHINESE.equals(this.locale) || Locale.SIMPLIFIED_CHINESE.equals(this.locale)) {
            this.stepTitle.setFont(new Font("\u5b8b\u4f53", 1, 14));
            this.stepDesc.setFont(new Font("\u5b8b\u4f53", 0, 12));
        } else {
            this.stepTitle.setFont(new Font("Arial", 1, 14));
            this.stepDesc.setFont(new Font("Arial", 0, 12));
        }
        gConst.gridx = 0;
        gConst.gridy = 0;
        gConst.gridheight = 1;
        gConst.weightx = 1.0;
        gConst.anchor = 11;
        gConst.fill = 1;
        gConst.insets = new Insets(0, 20, 10, 20);
        this.title.add((Component)this.stepTitle, gConst);
        gConst.gridy = 1;
        gConst.insets = new Insets(0, 20, 10, 20);
        this.stepDesc.setEditable(false);
        this.stepDesc.setOpaque(false);
        this.stepDesc.setLineWrap(true);
        this.stepDesc.setWrapStyleWord(true);
        this.stepDesc.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.title.add((Component)this.stepDesc, gConst);
        gConst.gridy = 2;
        gConst.insets = new Insets(0, 20, 0, 20);
        gConst.anchor = 10;
        JSeparator separatorLine = new JSeparator();
        separatorLine.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 4));
        this.title.add((Component)separatorLine, gConst);
    }

    public void initComponent() {
        this.progressPanel.removeAll();
        this.displayStageTitles = new ArrayList<String>();
        this.progressNodes = new ArrayList<ToolIconLabel>();
        this.progressLines = new ArrayList<JComponent>();
        this.progressTitles = new ArrayList<JComponent>();
        this.statusIconMap = new HashMap<String, ImageIcon>();
        this.initDisplayTitles();
        this.initStatusIconMap();
        this.initProgressTitles();
        this.initProgressNodes();
        this.initProgressLines();
        this.updateLeftLabel();
        this.updateRightLabel();
        this.initTitle();
    }

    public void updateComponent() {
        this.progressPanel.removeAll();
        this.displayStageTitles = new ArrayList<String>();
        this.progressNodes = new ArrayList<ToolIconLabel>();
        this.progressLines = new ArrayList<JComponent>();
        this.progressTitles = new ArrayList<JComponent>();
        this.statusIconMap = new HashMap<String, ImageIcon>();
        this.updateDisplayTitles();
        this.initStatusIconMap();
        this.initProgressTitles();
        this.initProgressNodes();
        this.initProgressLines();
    }

    public void updateProgressPanel(int stepNum) {
        this.setStartStepIndex(this.startStepIndex + stepNum);
        this.updateComponent();
        this.progressPanel.setLayout(new GridLayout(2, 8, -1, 10));
        for (JComponent titleComp : this.progressTitles) {
            this.progressPanel.add(UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{titleComp}));
        }
        for (int i = 0; i < this.progressNodes.size(); ++i) {
            JComponent progressComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{this.progressLines.get(i * 2), this.progressNodes.get(i), this.progressLines.get(i * 2 + 1)});
            this.progressPanel.add(progressComp);
        }
        this.progressPanel.setBackground(PROGRESS_BACK_COLOR);
        this.progressPanel.updateUI();
        this.repaint();
    }

    public void updatePanel() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(Color.WHITE);
        this.add((Component)UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), this.leftLabel, Box.createHorizontalStrut(5)}), "West");
        this.progressPanel.setLayout(new GridLayout(2, 8, -1, 10));
        this.progressPanel.setPreferredSize(new Dimension(900, 65));
        for (JComponent titleComp : this.progressTitles) {
            this.progressPanel.add(UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{titleComp}));
        }
        for (int i = 0; i < this.progressNodes.size(); ++i) {
            JComponent progressComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{this.progressLines.get(i * 2), this.progressNodes.get(i), this.progressLines.get(i * 2 + 1)});
            this.progressPanel.add(progressComp);
        }
        Component strut = Box.createVerticalStrut(5);
        strut.setBackground(PROGRESS_BACK_COLOR);
        strut.setForeground(PROGRESS_BACK_COLOR);
        this.progressPanel.setBackground(PROGRESS_BACK_COLOR);
        this.add((Component)UiMethod.buildFrameSpace(UCD.buildVBoxTop((Component[])new Component[]{strut, this.progressPanel}), 0), "Center");
        this.add((Component)UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), this.rightLabel, Box.createHorizontalStrut(5)}), "East");
        this.add((Component)this.title, "South");
        this.setVisible(true);
        this.repaint();
    }

    private void refreshButton() {
        if (this.stageTitles.size() <= 8) {
            this.rightLabel.setIcon(ResourceUtil.getImage("rightButton_gray.png"));
            this.leftLabel.setIcon(ResourceUtil.getImage("leftButton_gray.png"));
            return;
        }
        if (this.startStepIndex >= this.stageTitles.size() - 8) {
            this.rightLabel.setIcon(ResourceUtil.getImage("rightButton_gray.png"));
        } else {
            this.rightLabel.setIcon(ResourceUtil.getImage("rightButton.png"));
        }
        if (this.startStepIndex <= 0) {
            this.leftLabel.setIcon(ResourceUtil.getImage("leftButton_gray.png"));
        } else {
            this.leftLabel.setIcon(ResourceUtil.getImage("leftButton.png"));
        }
    }

    private void addListener() {
        this.rightLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WizardGuidePanel.this.updateProgressPanel(3);
                WizardGuidePanel.this.refreshButton();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                WizardGuidePanel.this.rightLabel.setIcon(ResourceUtil.getImage("rightButton_gray.png"));
                WizardGuidePanel.this.rightLabel.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WizardGuidePanel.this.rightLabel.setIcon(ResourceUtil.getImage("rightButton.png"));
                WizardGuidePanel.this.rightLabel.repaint();
            }
        });
        this.leftLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WizardGuidePanel.this.updateProgressPanel(-3);
                WizardGuidePanel.this.refreshButton();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                WizardGuidePanel.this.leftLabel.setIcon(ResourceUtil.getImage("leftButton_gray.png"));
                WizardGuidePanel.this.leftLabel.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WizardGuidePanel.this.leftLabel.setIcon(ResourceUtil.getImage("leftButton.png"));
                WizardGuidePanel.this.leftLabel.repaint();
            }
        });
    }

    @Override
    public String getUIClassID() {
        return "WizardGuidePanelUI";
    }

    public int getStartStepIndex() {
        return this.startStepIndex;
    }

    public void setStartStepIndex(int startStepIndex) {
        int endIndex = startStepIndex + 8;
        int startIndex = endIndex > this.stageTitles.size() ? this.stageTitles.size() - 8 : startStepIndex;
        this.startStepIndex = startIndex = 0 > startIndex ? 0 : startIndex;
    }
}

