/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.wizard;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class WizardHeadPanel
extends JPanel {
    private static final long serialVersionUID = -1447517738382139080L;
    private static final Dimension MIN_DIMENSION = new Dimension(100, 75);
    private JLabel stepTitle = new JLabel();
    private JTextArea stepDesc = new JTextArea();
    private JLabel stepLink = new JLabel();
    private String stepPath = "";
    private JLabel stepImage = new JLabel();
    private boolean isExpansion = false;

    public WizardHeadPanel() {
    }

    public WizardHeadPanel(Icon icon, String title, String desc, String link, String helpDir, Locale locale) {
        ToolLoggerFactory.getLogger(WizardHeadPanel.class).error("The link is :" + helpDir);
        this.setStepPath(helpDir);
        this.initIsExpansion(helpDir);
        this.initComponent(icon, title, desc, link, locale);
        this.initUI(locale);
        if (this.isExpansion) {
            this.addListener(locale);
        }
    }

    private void initIsExpansion(String helpDir) {
        this.isExpansion = helpDir != null && helpDir.contains("ServiceTool\\tools\\Expansion\\help\\Expansion");
    }

    public void setTitle(String title) {
        this.stepTitle.setText(title);
    }

    public void setDesc(String desc) {
        this.stepDesc.setText(desc);
    }

    public void setStepLink(String link) {
        this.stepLink.setText(link);
    }

    public void setStepPath(String path) {
        this.stepPath = path;
    }

    public void setIcon(Icon icon) {
        this.stepImage.setIcon(icon);
    }

    private void initComponent(Icon icon, String title, String desc, String link, Locale locale) {
        this.stepImage.setIcon(icon);
        this.stepTitle.setText(title);
        this.stepDesc.setText(desc);
        if (this.isExpansion) {
            this.stepLink.setText(link);
            this.stepLink.setOpaque(false);
        }
        this.stepDesc.setEditable(false);
        this.stepDesc.setOpaque(false);
        this.stepDesc.setLineWrap(true);
        this.stepDesc.setWrapStyleWord(true);
        if (Locale.CHINESE.equals(locale) || Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            this.stepTitle.setFont(new Font("\u5b8b\u4f53", 1, 14));
            this.stepDesc.setFont(new Font("\u5b8b\u4f53", 0, 12));
            if (this.isExpansion) {
                this.stepLink.setFont(new Font("\u5b8b\u4f53", 0, 12));
                this.stepLink.setForeground(Color.BLUE);
            }
        } else {
            this.stepTitle.setFont(new Font("Arial", 1, 14));
            this.stepDesc.setFont(new Font("Arial", 0, 12));
            if (this.isExpansion) {
                this.stepLink.setFont(new Font("Arial", 0, 12));
                this.stepLink.setForeground(Color.BLUE);
            }
        }
    }

    private void initUI(Locale locale) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gConst = new GridBagConstraints();
        gConst.gridx = 0;
        gConst.gridy = 0;
        gConst.gridheight = 2;
        gConst.weightx = 0.0;
        gConst.anchor = 17;
        gConst.fill = 1;
        gConst.insets = new Insets(12, 20, 12, 10);
        this.add((Component)this.stepImage, gConst);
        gConst.gridx = 1;
        gConst.gridheight = 1;
        gConst.weightx = 1.0;
        gConst.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.stepTitle, gConst);
        gConst.gridy = 1;
        gConst.insets = this.isExpansion ? new Insets(0, 0, 12, 0) : new Insets(0, 0, 12, 12);
        this.add((Component)this.stepDesc, gConst);
        if (this.isExpansion) {
            if (Locale.CHINESE.equals(locale) || Locale.SIMPLIFIED_CHINESE.equals(locale)) {
                gConst.gridx = 2;
                gConst.insets = new Insets(0, 0, 30, 380);
                this.add((Component)this.stepLink, gConst);
            } else {
                gConst.gridx = 2;
                gConst.insets = new Insets(0, 0, 30, 0);
                this.add((Component)this.stepLink, gConst);
            }
        } else {
            this.setPreferredSize(MIN_DIMENSION);
            this.setMinimumSize(MIN_DIMENSION);
        }
    }

    private void addListener(Locale locale) {
        if (Locale.CHINESE.equals(locale) || Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            this.stepLink.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        ToolLoggerFactory.getLogger(WizardHeadPanel.class).error("The help path is :" + WizardHeadPanel.this.stepPath);
                        String htmlFileName = "expand" + "_" + "zh" + ".chm";
                        String filePathString = WizardHeadPanel.this.stepPath + File.separator + htmlFileName;
                        String cmd = new String(("hh " + filePathString).getBytes(Charset.defaultCharset()), "UTF-8");
                        OSCmdUtils.executeCmd(cmd);
                    }
                    catch (UnsupportedEncodingException uee) {
                        ToolLoggerFactory.getLogger(WizardHeadPanel.class).error("encode string error.", (Throwable)uee);
                    }
                }
            });
        } else {
            this.stepLink.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        String htmlFileName = "expand" + "_" + "en" + ".chm";
                        String filePathString = WizardHeadPanel.this.stepPath + File.separator + htmlFileName;
                        String cmd = new String(("hh " + filePathString).getBytes(Charset.defaultCharset()), "UTF-8");
                        OSCmdUtils.executeCmd(cmd);
                    }
                    catch (UnsupportedEncodingException e1) {
                        ToolLoggerFactory.getLogger(WizardHeadPanel.class).error("encode string error.", (Object)e);
                    }
                }
            });
        }
    }

    @Override
    public String getUIClassID() {
        return "WizardHeadPanelUI";
    }
}

