/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.wizard;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.plaf.FontUIResource;

public class WizardStepItem
extends JPanel {
    private static final long serialVersionUID = 1L;
    WizardNumberPanel numberPanel = null;
    JPanel stepPpanel = new JPanel();
    JTextArea descriptionTextArea = null;
    private String description = null;
    private String stepName = null;
    private boolean currentStep = false;
    private int stepNumber = 1;
    private JLabel stepLabel = null;

    public WizardStepItem(String stepName, String descrip, int stepNumber, Locale locale) {
        this.stepName = stepName;
        this.description = descrip;
        this.stepNumber = stepNumber;
        this.initUI(locale.getLanguage().equals(Locale.ENGLISH.getLanguage()));
    }

    private void initUI(boolean isEnglishEnv) {
        this.stepLabel = new JLabel(this.stepName);
        Dimension size = new Dimension(151, (int)this.stepLabel.getPreferredSize().getHeight());
        UiMethod.setComponentSize(size, this.stepLabel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets.left = 15;
        gbc.insets.right = 10;
        this.stepPpanel.setLayout(new BoxLayout(this.stepPpanel, 0));
        this.numberPanel = new WizardNumberPanel(this.stepNumber);
        this.stepPpanel.add(this.numberPanel);
        this.stepPpanel.add(Box.createHorizontalStrut(10));
        this.stepPpanel.add(this.stepLabel);
        this.add((Component)this.stepPpanel, gbc);
        if (!StringUtils.isNULLStr(this.description)) {
            this.descriptionTextArea = UCD.createTextArea((String)this.description);
            gbc.gridy = 1;
            gbc.insets.top = 12;
            this.add((Component)this.descriptionTextArea, gbc);
            this.descriptionTextArea.setFont(this.getStandtardsDescriptionFont(isEnglishEnv));
            this.descriptionTextArea.setForeground(WizardConstants.WIZARD_STEP_CURRENT_STEP_DESCRIPTION_COLOR);
        }
        this.setBackground(WizardConstants.WIZARD_BACKGROUND);
        this.stepPpanel.setBackground(WizardConstants.WIZARD_BACKGROUND);
        this.stepLabel.setBackground(WizardConstants.WIZARD_BACKGROUND);
        this.stepLabel.setForeground(WizardConstants.WIZARD_STEP_FONT_WHITE_COLOR);
        this.stepLabel.setFont(this.getStandtardsStepFont(isEnglishEnv));
        this.numberPanel.setLableFont(IsmFontFactory.getArialBold13());
    }

    public void setLabelTextColor(Color color) {
        this.stepLabel.setForeground(color);
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setStepNumber(int number) {
        this.stepNumber = number;
    }

    public String getDesciption() {
        return this.description;
    }

    public boolean isCurrent() {
        return this.currentStep;
    }

    @Override
    public String toString() {
        return this.stepName + this.description;
    }

    @Override
    public String getUIClassID() {
        return "NewWizardStepItemUI";
    }

    public void setSelected(boolean isCurrent) {
        this.currentStep = isCurrent;
        this.numberPanel.setCurrent(isCurrent);
    }

    private FontUIResource getStandtardsStepFont(boolean isEnglishEnv) {
        if (isEnglishEnv) {
            return IsmFontFactory.getArialBold13();
        }
        return IsmFontFactory.getSimSunBold13();
    }

    private FontUIResource getStandtardsDescriptionFont(boolean isEnglishEnv) {
        if (isEnglishEnv) {
            return IsmFontFactory.getArailPlain12();
        }
        return IsmFontFactory.getSimSunPlain12();
    }

    static class WizardNumberPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel label = new JLabel();
        private boolean currentPanel = false;

        public WizardNumberPanel(int number) {
            String numberStr = "" + number;
            this.label.setText(numberStr);
            this.label.setForeground(WizardConstants.WIZARD_STEP_FONT_WHITE_COLOR);
            this.add(this.label);
        }

        @Override
        public String getUIClassID() {
            return "NewWizardNumberPanelUI";
        }

        public boolean isCurrent() {
            return this.currentPanel;
        }

        public void setCurrent(boolean isCurrent) {
            this.currentPanel = isCurrent;
        }

        public void setLableFont(FontUIResource font) {
            this.label.setFont(font);
        }
    }
}

