/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.wizard;

import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.util.CommonUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WizardTitlePane
extends JPanel {
    private static final long serialVersionUID = -5556262082689561118L;
    private static final int CLOSE_BUTTON_RIGHT_SPACE = 15;
    private static final int HELP_BUTTON_RIGHT_SPACE = 10;
    private static final int ICON_SIZE = 16;
    private transient PropertyChangeListener propertyChangeListener;
    private Action closeAction;
    private Action helpAction;
    private Action minimizeAction;
    private Action maxSizeAction;
    private transient Action aboutAction;
    private Action uiAboutAction;
    private Action settingAction;
    private Action uiSettingAction;
    private JButton helpButton;
    private JButton closeButton;
    private JButton minimizeButton;
    private JButton maxSizeButton;
    private JButton aboutButton;
    private JButton settingButton;
    private transient WindowListener windowListener;
    private Window currentWindow;
    private JRootPane rootPane;
    private transient IHelpActionCallBack helpActionObserver;

    public WizardTitlePane(JRootPane root, boolean showHelp, boolean showAbout, boolean showMinimize, boolean showMaxsize) {
        this(root, showHelp, showAbout, showMinimize, showMaxsize, false);
    }

    public WizardTitlePane(JRootPane root, boolean showHelp, boolean showAbout, boolean showMinimize, boolean showMaxsize, boolean showSetting) {
        this.rootPane = root;
        this.installSubcomponents(showHelp, showAbout, showMinimize, showMaxsize, showSetting);
        this.installDefaults();
    }

    public void setHelpActionObserver(IHelpActionCallBack helpObserver) {
        this.helpActionObserver = helpObserver;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.rootPane.getWidth();
        return new Dimension(width, this.computeHeight());
    }

    public void setAboutAction(Action aboutAction) {
        this.aboutAction = aboutAction;
    }

    public void setSettingAction(Action settingAction) {
        this.settingAction = settingAction;
    }

    private int computeHeight() {
        FontMetrics fm = this.rootPane.getFontMetrics(this.getFont());
        int fontHeight = fm.getHeight();
        int titleBarHeight = UIManager.getInt("IsmDialog.TitleBarHeight");
        int finalHeight = Math.max(fontHeight += 7, titleBarHeight);
        return finalHeight;
    }

    public void uninstall() {
        this.uninstallWindowListeners();
        this.currentWindow = null;
        this.removeAll();
    }

    private void installWindowListeners() {
        if (this.currentWindow != null) {
            this.windowListener = this.createBaseWindowListener();
            this.currentWindow.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.currentWindow.addPropertyChangeListener(this.propertyChangeListener);
            if (this.currentWindow instanceof JFrame) {
                this.addMaxWindowListener();
            }
        }
    }

    private void uninstallWindowListeners() {
        if (this.currentWindow != null) {
            this.currentWindow.removeWindowListener(this.windowListener);
            this.currentWindow.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createBaseWindowListener() {
        return new BaseWindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new WindowPropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallWindowListeners();
        this.currentWindow = SwingUtilities.getWindowAncestor(this);
        if (this.currentWindow != null) {
            this.setWindowActive(this.currentWindow.isActive());
            this.installWindowListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallWindowListeners();
        this.currentWindow = null;
    }

    private void setMaxButton() {
        this.setButtonIcon(this.maxSizeButton, "titleBar_maxsize_normal", "titleBar_maxsize_rollover", "titleBar_maxsize_selected");
    }

    private void setMaxBackButton() {
        this.setButtonIcon(this.maxSizeButton, "titleBar_maxsizeback_normal", "titleBar_maxsizeback_rollover", "titleBar_maxsizeback_selected");
    }

    private void installSubcomponents(boolean showHelp, boolean showAbout, boolean showMinimize, boolean showMaxsize, boolean showSetting) {
        this.closeAction = new CloseAction();
        this.helpAction = new HelpAction();
        this.minimizeAction = new AbstractAction(){
            private static final long serialVersionUID = 6354610668136376221L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frm = (JFrame)CommonUtil.convertObject((Object)WizardTitlePane.this.currentWindow, JFrame.class);
                frm.setExtendedState(1);
            }
        };
        this.maxSizeAction = new AbstractAction(){
            private static final long serialVersionUID = 6354610668136376221L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frm = (JFrame)CommonUtil.convertObject((Object)WizardTitlePane.this.currentWindow, JFrame.class);
                if (frm.getExtendedState() == 0) {
                    frm.setExtendedState(6);
                    WizardTitlePane.this.setMaxBackButton();
                } else {
                    frm.setExtendedState(0);
                    WizardTitlePane.this.setMaxButton();
                }
            }
        };
        this.uiAboutAction = new AbstractAction(){
            private static final long serialVersionUID = 3142424686670546924L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (null != WizardTitlePane.this.aboutAction) {
                    WizardTitlePane.this.aboutAction.actionPerformed(arg0);
                }
            }
        };
        this.uiSettingAction = new AbstractAction(){
            private static final long serialVersionUID = 8932246710221693399L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (WizardTitlePane.this.settingAction != null) {
                    WizardTitlePane.this.settingAction.actionPerformed(event);
                }
            }
        };
        this.checkCreateButton(showHelp, showAbout, showMinimize, showMaxsize, showSetting);
    }

    private void checkCreateButton(boolean showHelp, boolean showAbout, boolean showMinimize, boolean showMaxsize, boolean showSetting) {
        try {
            this.createButtons();
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("init wizardTitlePane failed:::>>>", (Throwable)e);
        }
        this.setLayout(new TitlePaneLayout(showHelp, showAbout, showMinimize, showMaxsize, showSetting));
        if (showHelp) {
            this.add(this.helpButton);
        }
        if (showAbout) {
            this.add(this.aboutButton);
        }
        if (showMinimize) {
            this.add(this.minimizeButton);
        }
        if (showMaxsize) {
            this.add(this.maxSizeButton);
        }
        if (showSetting) {
            this.add(this.settingButton);
        }
        this.add(this.closeButton);
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void addMaxWindowListener() {
        JFrame frame = (JFrame)CommonUtil.convertObject((Object)this.currentWindow, JFrame.class);
        frame.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getOldState() != e.getNewState()) {
                    switch (e.getNewState()) {
                        case 6: {
                            WizardTitlePane.this.setMaxBackButton();
                            break;
                        }
                        case 0: {
                            WizardTitlePane.this.setMaxButton();
                            break;
                        }
                    }
                }
            }
        });
    }

    private void close() {
        Window wd = this.getCurrentWindow();
        if (wd != null) {
            wd.dispatchEvent(new WindowEvent(wd, 201));
        }
    }

    private JButton createTitleButton(Action action, String btnName) {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        button.setText(null);
        button.putClientProperty("paintActive", Boolean.TRUE);
        button.setAction(action);
        button.setBackground(UIManager.getColor("IsmArmorStyle.BaseColor"));
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setIconTextGap(0);
        this.setBackground(UIManager.getColor("IsmArmorStyle.BaseColor"));
        button.setBounds(0, 0, 16, 16);
        if (btnName != null) {
            button.setName(btnName);
        }
        return button;
    }

    public JButton createTitleButton(Action action) {
        return this.createTitleButton(action, null);
    }

    private void createButtons() {
        this.helpButton = this.createTitleButton(this.helpAction, "helpAction");
        this.closeButton = this.createTitleButton(this.closeAction, "closeButton");
        this.minimizeButton = this.createTitleButton(this.minimizeAction, "minimizeButton");
        this.maxSizeButton = this.createTitleButton(this.maxSizeAction, "maxSizeButton");
        this.aboutButton = this.createTitleButton(this.uiAboutAction, "aboutButton");
        this.settingButton = this.createTitleButton(this.uiSettingAction, "settingButton");
        this.setButtonIcon(this.helpButton, "dialog_help_normal", "dialog_help_rollover", "dialog_help_selected");
        this.setButtonIcon(this.closeButton, "dialog_close_normal", "dialog_close_rollover", "dialog_close_selected");
        this.setButtonIcon(this.minimizeButton, "titleBar_minimize_normal", "titleBar_minimize_rollover", "titleBar_minimize_selected");
        this.setMaxButton();
        this.setButtonIcon(this.aboutButton, "dialog_about_taskbar_normal", "dialog_about_taskbar_rollover", "dialog_about_taskbar_selected");
        this.setButtonIcon(this.settingButton, "dialog_setting_taskbar_normal", "dialog_setting_taskbar_rollover", "dialog_setting_taskbar_selected");
    }

    private void setButtonIcon(JButton button, String normalIconKey, String rolloverIconKey, String selectedIconKey) {
        if (null != button) {
            String prefix = "TitleBar.";
            Icon normalIcon = UIManager.getIcon(prefix + normalIconKey);
            button.setIcon(normalIcon);
            button.setDisabledIcon(normalIcon);
            Icon rolloverIcon = UIManager.getIcon(prefix + rolloverIconKey);
            button.setRolloverIcon(rolloverIcon);
            button.setRolloverSelectedIcon(rolloverIcon);
            Icon selectedIcon = UIManager.getIcon(prefix + selectedIconKey);
            button.setSelectedIcon(selectedIcon);
            button.setPressedIcon(selectedIcon);
            button.setPreferredSize(new Dimension(normalIcon.getIconWidth(), normalIcon.getIconHeight()));
        }
    }

    private void setWindowActive(boolean isActive) {
        Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        this.closeButton.putClientProperty("paintActive", activeB);
        this.helpButton.putClientProperty("paintActive", activeB);
        this.aboutButton.putClientProperty("paintActive", activeB);
        this.minimizeButton.putClientProperty("paintActive", activeB);
        this.maxSizeButton.putClientProperty("paintActive", activeB);
        this.getRootPane().repaint();
    }

    private Window getCurrentWindow() {
        return this.currentWindow;
    }

    private String getTitle() {
        Window window = this.getCurrentWindow();
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        if (window instanceof JFrame) {
            return ((JFrame)window).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics gra) {
        super.paintComponent(gra);
        JRootPane jRootPane = this.getRootPane();
        Window wd = this.getCurrentWindow();
        boolean leftToRight = wd == null ? jRootPane.getComponentOrientation().isLeftToRight() : wd.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        int xOffset = 0;
        ImageIcon backgroundIcon = ResourceUtil.getImage("wizard_title_background.png");
        gra.drawImage(backgroundIcon.getImage(), 0, 0, width, height, this);
        xOffset += leftToRight ? 11 : -width - 11;
        String theTitle = this.getTitle();
        if (theTitle != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            gra.setColor(Color.WHITE);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            gra.drawString(theTitle, xOffset, yOffset);
        }
    }

    private class BaseWindowHandler
    extends WindowAdapter {
        private BaseWindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            WizardTitlePane.this.setWindowActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            WizardTitlePane.this.setWindowActive(false);
        }
    }

    private class WindowPropertyChangeHandler
    implements PropertyChangeListener {
        private WindowPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String propertyName = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(propertyName) || "state".equals(propertyName)) {
                if ("resizable".equals(propertyName)) {
                    WizardTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(propertyName)) {
                WizardTitlePane.this.repaint();
            } else if ("componentOrientation".equals(propertyName)) {
                this.revalidateAndRepaint();
            } else if ("iconImage".equals(propertyName)) {
                this.revalidateAndRepaint();
            }
        }

        private void revalidateAndRepaint() {
            WizardTitlePane.this.revalidate();
            WizardTitlePane.this.repaint();
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private boolean showHelp;
        private boolean showAbout;
        private boolean showMinimize;
        private boolean showMaxSize;
        private boolean showSetting;

        public TitlePaneLayout(boolean showHelp, boolean showAbout, boolean showMinimize, boolean showMaxSize, boolean showSetting) {
            this.showAbout = showAbout;
            this.showHelp = showHelp;
            this.showMinimize = showMinimize;
            this.showMaxSize = showMaxSize;
            this.showSetting = showSetting;
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = WizardTitlePane.this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container con) {
            return this.preferredLayoutSize(con);
        }

        @Override
        public void layoutContainer(Container c) {
            boolean leftToRight = WizardTitlePane.this.currentWindow == null ? WizardTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : WizardTitlePane.this.currentWindow.getComponentOrientation().isLeftToRight();
            int wi = WizardTitlePane.this.getWidth();
            int he = WizardTitlePane.this.getHeight();
            int buttonHeight = 16;
            int buttonWidth = 16;
            if (WizardTitlePane.this.closeButton != null && WizardTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = WizardTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = WizardTitlePane.this.closeButton.getIcon().getIconWidth();
            }
            int spacing = 15;
            int bu = (he - buttonHeight) / 2;
            int le = leftToRight ? wi : 0;
            le += leftToRight ? -spacing - buttonWidth : spacing;
            if (WizardTitlePane.this.closeButton != null) {
                WizardTitlePane.this.closeButton.setBounds(le, bu, buttonWidth, buttonHeight);
            }
            if (this.showMaxSize && WizardTitlePane.this.currentWindow instanceof JFrame) {
                le = le - buttonWidth - 10;
                WizardTitlePane.this.maxSizeButton.setBounds(le, bu, buttonWidth, buttonHeight);
            }
            if (this.showMinimize && WizardTitlePane.this.currentWindow instanceof JFrame) {
                le = le - buttonWidth - 10;
                WizardTitlePane.this.minimizeButton.setBounds(le, bu, buttonWidth, buttonHeight);
            }
            if (this.showHelp) {
                le = le - buttonWidth - 10;
                WizardTitlePane.this.helpButton.setBounds(le, bu, buttonWidth, buttonHeight);
            }
            if (this.showAbout) {
                le = le - buttonWidth - 10;
                WizardTitlePane.this.aboutButton.setBounds(le, bu, buttonWidth, buttonHeight);
            }
            if (this.showSetting) {
                le = le - buttonWidth - 10;
                WizardTitlePane.this.settingButton.setBounds(le, bu, buttonWidth, buttonHeight);
            }
        }
    }

    private class HelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null == WizardTitlePane.this.helpActionObserver) {
                return;
            }
            WizardTitlePane.this.helpActionObserver.doHelpActionWork();
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -2838961894571122928L;

        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WizardTitlePane.this.close();
        }
    }
}

