/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerIPGainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerIPGainer.class);
    private final String[] noPeerIpDeviceType = new String[]{"XVE", "N8000", "HVS", "18500", "18800"};
    private final String[] quaryIpCmds = new String[]{"showctrlip", "show controller ip", "show system management_ip"};

    public void getPeerIP(ICliConnection con, DevNode devNode) {
        try {
            if (!this.checkPeerIP(devNode)) {
                return;
            }
            for (String quaryIPCmd : this.quaryIpCmds) {
                String cliResult = con.execCmdWithTimout(quaryIPCmd, 15);
                if (this.isCLIResultInValid(cliResult)) {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("quary peer ip : " + quaryIPCmd + " cli not support");
                    continue;
                }
                BufferedReader reader = new BufferedReader(new StringReader(cliResult));
                String currentLine = "";
                boolean result = false;
                while ((currentLine = reader.readLine()) != null) {
                    if ((currentLine = currentLine.trim()).startsWith("A ") || currentLine.startsWith("B ")) {
                        String ipTV1 = this.parseIP(currentLine);
                        result = PeerIPGainer.addPeerIP(ipTV1, devNode);
                        PeerIPGainer.addIPlist(ipTV1, devNode);
                        if (!result) continue;
                        break;
                    }
                    if (!currentLine.contains("IPv4 Address") && !currentLine.contains("IPV4 Address")) continue;
                    String ipTV2 = this.parseIPTV2(currentLine);
                    PeerIPGainer.addPeerIP(ipTV2, devNode);
                    PeerIPGainer.addIPlist(ipTV2, devNode);
                }
                if (StringUtils.isNULLStr((String)devNode.getPeerIp())) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("BufferedReader close fail", (Throwable)e);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("set peer ip error!devNode:" + com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)devNode.toString()), (Throwable)e);
        }
    }

    private boolean checkPeerIP(DevNode devNode) {
        String type = devNode.getDeviceType().toString().toUpperCase(Locale.getDefault());
        for (int index = 0; index < this.noPeerIpDeviceType.length; ++index) {
            if (!type.contains(this.noPeerIpDeviceType[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean addPeerIP(String ip, DevNode devNode) {
        if (StringUtils.isNULLStr((String)ip)) {
            return false;
        }
        if (!devNode.getIp().equals(ip)) {
            devNode.setPeerIp(ip);
            return true;
        }
        return false;
    }

    public static boolean addIPlist(String ip, DevNode devNode) {
        if (StringUtils.isNULLStr((String)ip)) {
            return false;
        }
        if (!devNode.getIp().equals(ip)) {
            devNode.addIp(ip);
            return true;
        }
        return false;
    }

    private String parseIPTV2(String line) {
        try {
            String[] strs = line.split(":");
            String ip = strs[1].trim();
            if (StringUtils.allIsVaildIpv4((String[])new String[]{ip})) {
                return ip;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private String parseIP(String line) {
        try {
            String[] strs = line.split("[\\s]+");
            String ip = strs[1].trim();
            if (StringUtils.allIsVaildIpv4((String[])new String[]{ip})) {
                return ip;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private boolean isCLIResultInValid(String cliResult) {
        String normalizedCliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
        return normalizedCliResult.contains("command not found") || normalizedCliResult.contains("not exist") || normalizedCliResult.contains("command name is invalid") || normalizedCliResult.isEmpty();
    }
}

