/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.newinfoquery;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.dev.newinfoquery.InodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.dev.newinfoquery.entity.Progress;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.enums.DmeNodeStatus;
import com.huawei.ism.tool.obase.entity.enums.DmeType;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmeNodeQueryImpl
implements InodeTypeQuery {
    private static final Logger log = LoggerFactory.getLogger(DmeNodeQueryImpl.class);

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr, Consumer<Progress> updateProgress) {
        if (!(devNode instanceof AiDevNode)) {
            TaskResult taskResult = new TaskResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription("not ai node, can not login with current service");
            return taskResult;
        }
        AiDevNode loginNode = (AiDevNode)devNode;
        TaskResult taskResult = new TaskResult();
        try {
            this.setProgressInfo(updateProgress, ResourceUtil.getString((String)"login.dme"));
            RestConnection restConnection = this.getRestConnection(devNode);
            this.setProgressInfo(updateProgress, ResourceUtil.getString((String)"query.basic.info"));
            this.queryBasicInfo(restConnection, loginNode);
            this.setProgressInfo(updateProgress, ResourceUtil.getString((String)"query.a800.info"));
            String errorMsg = this.doQueryWithConfirmInfo(updateProgress, restConnection, loginNode);
            if (!StringUtils.isNULLStr((String)errorMsg)) {
                taskResult.setAddConfirmInfo(errorMsg);
            }
            taskResult.setResult(TaskResult.Result.SUCCESS);
            if (devNode.isVerifyCertificate()) {
                this.checkRestCert(restConnection, devNode);
            }
        }
        catch (ToolException e) {
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)loginNode);
        }
        return taskResult;
    }

    private String doQueryWithConfirmInfo(Consumer<Progress> updateProgress, RestConnection restConnection, AiDevNode loginNode) throws ToolException {
        String errorMsg = this.queryA800WithConfirmInfo(restConnection, loginNode);
        this.setProgressInfo(updateProgress, ResourceUtil.getString((String)"query.dpc.info"));
        return this.queryOmWithConfirmInfo(restConnection, loginNode, errorMsg);
    }

    private String queryOmWithConfirmInfo(RestConnection restConnection, AiDevNode loginNode, String errorMsg) throws ToolException {
        try {
            this.queryOmNodes(restConnection, loginNode);
        }
        catch (ToolException e) {
            if (!"no.om.found".equals(e.getErrorId())) {
                throw e;
            }
            if (DeviceAddUtil.isSceneSupportOmOnly()) {
                throw new ToolException("no.om.found.but.required");
            }
            if (!StringUtils.isNULLStr((String)errorMsg)) {
                throw new ToolException(String.join((CharSequence)System.lineSeparator(), ResourceUtil.getString((String)"no.a800.found"), e.getErrorLocaleDescription()));
            }
            return e.getErrorLocaleDescription();
        }
        return errorMsg;
    }

    private String queryA800WithConfirmInfo(RestConnection restConnection, AiDevNode loginNode) throws ToolException {
        try {
            this.queryA800Nodes(restConnection, loginNode);
        }
        catch (ToolException e) {
            if ("no.a800.found".equals(e.getErrorId())) {
                return e.getErrorLocaleDescription();
            }
            throw e;
        }
        return "";
    }

    private void setProgressInfo(Consumer<Progress> processFunc, String showMsg) {
        if (Objects.nonNull(processFunc)) {
            processFunc.accept(new Progress(0, showMsg));
        }
    }

    private void queryA800Nodes(RestConnection restConnection, AiDevNode devNode) throws ToolException {
        String url = RestUtil.getBaseUri((DevNode)devNode) + "/rest/storagemgmt/v1/storages";
        ResponseInfo responseInfo = restConnection.execGet(url);
        this.checkResponse(responseInfo);
        devNode.setA800Nodes(this.parseA800Nodes(responseInfo));
        if (CollectionUtils.isEmpty((Collection)devNode.getA800Nodes())) {
            throw new ToolException(DeviceAddUtil.isSceneSupportA800Only() ? "no.a800.found.but.required" : "no.a800.found");
        }
        devNode.getA800Nodes().forEach(node -> node.setPort(devNode.getPort()));
        this.queryForZonesForA800Nodes(devNode, restConnection);
    }

    private void queryForZonesForA800Nodes(AiDevNode devNode, RestConnection restConnection) throws ToolException {
        List a800Nodes = devNode.getA800Nodes();
        if (CollectionUtils.isEmpty((Collection)a800Nodes)) {
            log.warn("node :{} has no storage nodes", (Object)devNode.getIp());
            return;
        }
        String url = RestUtil.getBaseUri((DevNode)devNode) + "/rest/storageclusterservice/v1/zones/query";
        List idParams = a800Nodes.stream().map(DevNode::getUuid).collect(Collectors.toList());
        HashMap param = new HashMap();
        param.put("storage_ids", idParams);
        ResponseInfo responseInfo = restConnection.execPost(url, param);
        this.checkResponse(responseInfo);
        this.parseZones(a800Nodes, responseInfo);
    }

    private void checkResponse(ResponseInfo responseInfo) throws ToolException {
        JSONObject jsonObject = JSON.parseObject((String)responseInfo.getContent());
        if (jsonObject.containsKey((Object)"errorCode")) {
            throw new ToolException("request.error.for.dme");
        }
    }

    private void parseZones(List<A800Node> a800Nodes, ResponseInfo responseInfo) throws ToolException {
        JSONObject responseObj = JSON.parseObject((String)responseInfo.getContent());
        if (!responseObj.containsKey((Object)"datas")) {
            throw new ToolException("request.error.for.dme");
        }
        JSONArray datas = responseObj.getJSONArray("datas");
        Map<String, List<JSONObject>> groupZones = IntStream.range(0, datas.size()).mapToObj(arg_0 -> ((JSONArray)datas).getJSONObject(arg_0)).collect(Collectors.groupingBy(key -> key.getString("parent_id")));
        for (A800Node a800Node : a800Nodes) {
            List<JSONObject> zoneDatas = groupZones.get(a800Node.getUuid());
            if (CollectionUtils.isEmpty(zoneDatas)) {
                log.warn("a800 : {} has no zone found, parent_id : {}", (Object)a800Node.getIp(), (Object)a800Node.getUuid());
                throw new ToolException("request.error.for.dme");
            }
            a800Node.setZones(zoneDatas.stream().map(this::parseZone).collect(Collectors.toList()));
        }
    }

    private DmeNode parseZone(JSONObject zoneData) {
        DmeNode zone = new DmeNode();
        zone.setIp(zoneData.getString("ip"));
        zone.setDeviceSerialNumber(zoneData.getString("sn"));
        zone.setUuid(zoneData.getString("zone_raw_id"));
        zone.setStatus(DmeNodeStatus.of((DmeType)DmeType.ZONE, (String)zoneData.getString("status")));
        zone.setProductVersion(zoneData.getString("version"));
        zone.setVendor(zoneData.getString("vendor"));
        zone.setProductModel(zoneData.getString("model"));
        zone.setDeviceName(zoneData.getString("name"));
        zone.setItDeviceType(ItDeviceType.A800_NODE);
        zone.setDeviceType(DeviceType.valueOf((String)ItDeviceType.A800_NODE.getName()));
        zone.setCoreZone(zoneData.getOrDefault((Object)"isCoreZone", (Object)"0").equals("1"));
        return zone;
    }

    private List<A800Node> parseA800Nodes(ResponseInfo responseInfo) throws ToolException {
        JSONObject jsonObject = JSON.parseObject((String)responseInfo.getContent());
        if (!jsonObject.containsKey((Object)"datas")) {
            throw new ToolException("request.error.for.dme");
        }
        JSONArray storages = jsonObject.getJSONArray("datas");
        return IntStream.range(0, storages.size()).mapToObj(arg_0 -> ((JSONArray)storages).getJSONObject(arg_0)).filter(obj -> ItDeviceType.A800_NODE.getName().replace(" ", "").equals(obj.getString("owning_ne_type"))).map(this::parseA800Node).collect(Collectors.toList());
    }

    private A800Node parseA800Node(JSONObject jsonObject) {
        A800Node a800Node = new A800Node();
        a800Node.setDeviceName(jsonObject.getString("name"));
        a800Node.setIp(jsonObject.getString("ip"));
        a800Node.setDeviceSerialNumber(jsonObject.getString("sn"));
        a800Node.setProductModel(jsonObject.getString("model"));
        a800Node.setUuid(jsonObject.getString("id"));
        a800Node.setStatus(DmeNodeStatus.of((DmeType)DmeType.STORAGE, (String)jsonObject.getString("status")));
        a800Node.setProductVersion(jsonObject.getString("version"));
        a800Node.setHotPatchVersion(jsonObject.getString("patch_version"));
        a800Node.setItDeviceType(ItDeviceType.A800_NODE);
        a800Node.setDeviceType(DeviceType.valueOf((String)ItDeviceType.A800_NODE.getName()));
        return a800Node;
    }

    private void queryBasicInfo(RestConnection restConnection, AiDevNode devNode) throws ToolException {
        String url = RestUtil.getBaseUri((DevNode)devNode) + "/rest/productmgmt/v1/system-info";
        ResponseInfo responseInfo = restConnection.execGet(url);
        try {
            this.checkResponse(responseInfo);
        }
        catch (ToolException e) {
            log.warn("dme :{} basic info query failed, use ip for sn", (Object)devNode.getIp(), (Object)e);
            devNode.setDeviceSerialNumber(devNode.getIp());
            return;
        }
        this.parseDmeBasicInfo(devNode, responseInfo.getContent());
    }

    private void parseDmeBasicInfo(AiDevNode devNode, String responseContent) {
        JSONObject jsonObject = JSON.parseObject((String)responseContent);
        devNode.setDeviceSerialNumber(jsonObject.getOrDefault((Object)"sn", (Object)devNode.getIp()).toString());
        devNode.setProductVersion(jsonObject.getOrDefault((Object)"version", (Object)"").toString());
    }

    private void queryOmNodes(RestConnection restConnection, AiDevNode devNode) throws ToolException {
        String url = RestUtil.getBaseUri((DevNode)devNode) + "/rest/dpc-mgmt/v1/dpc-oms/query";
        ResponseInfo responseInfo = restConnection.execPost(url, new HashMap());
        this.checkResponse(responseInfo);
        devNode.setOmNodes(this.parseOmResponse(responseInfo));
    }

    private List<DmeNode> parseOmResponse(ResponseInfo responseInfo) throws ToolException {
        JSONObject response = JSON.parseObject((String)responseInfo.getContent());
        if (!response.containsKey((Object)"dpc_oms")) {
            throw new ToolException("no.om.found");
        }
        JSONArray dpcOms = response.getJSONArray("dpc_oms");
        if (dpcOms.isEmpty()) {
            throw new ToolException("no.om.found");
        }
        return IntStream.range(0, dpcOms.size()).mapToObj(arg_0 -> ((JSONArray)dpcOms).getJSONObject(arg_0)).map(this::parseOmNode).collect(Collectors.toList());
    }

    private DmeNode parseOmNode(JSONObject jsonObject) {
        DmeNode devNode = new DmeNode();
        devNode.setIp(jsonObject.getString("ip"));
        devNode.setUuid(jsonObject.getString("id"));
        devNode.setStatus(DmeNodeStatus.of((DmeType)DmeType.OM, (String)jsonObject.getString("status")));
        devNode.setProductModel(ItDeviceType.A800_OM.getName());
        devNode.setDeviceType(DeviceType.valueOf((String)ItDeviceType.A800_OM.getName()));
        devNode.setItDeviceType(ItDeviceType.A800_OM);
        devNode.setPort(8088);
        devNode.setDeviceSerialNumber(UUID.randomUUID().toString());
        return devNode;
    }

    private RestConnection getRestConnection(DevNode devNode) throws ToolException {
        RestConnection connection = null;
        try {
            connection = RestConnectionManager.getRestConnection(devNode);
        }
        catch (ToolException e) {
            if (e.getErrorId().equals("No trusted certificate found")) {
                throw new ToolException("devicemanager.verify.cert.error", new Object[0]);
            }
            throw e;
        }
        if (Objects.isNull(connection) || !connection.isLogin()) {
            throw new ToolException("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror", new Object[]{devNode.getIp()});
        }
        return connection;
    }
}

