/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.host;

import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.utils.StarterType;
import com.huawei.ism.tool.devicemanager.utils.WwnUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class AixHostServiceImpl
extends HostService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AixHostServiceImpl.class);
    private static final String FC_COMMAND = "lscfg -vpl fcs*";
    private static final String FC_KEY_WORD = "Network Address";
    private static final String FC_REG_EXP = "[0-9|a-f]{16}";
    private static final String ISCSI_COMMAND_1 = "lsdev | grep -i iscsi";
    private static final String ISCSI_COMMAND_2 = "lsattr -El ";
    private static final String ISCSI_KEY_WORD = "iqn.";

    @Override
    public Launcher queryWwn(ICliConnection con, DevNode devNode) {
        HashMap<StarterType, List<String>> hashMap = new HashMap<StarterType, List<String>>();
        WwnUtil.buildWwnData(hashMap, StarterType.FC, FC_COMMAND, FC_KEY_WORD, FC_REG_EXP);
        Launcher launcher = new Launcher();
        StringBuffer resultCollect = new StringBuffer();
        try {
            WwnUtil.getAluaWwn(con, hashMap, launcher, resultCollect);
            this.getAixIscsiWwn(con, launcher, resultCollect);
        }
        catch (Exception e) {
            launcher.getOtherDataMap().put("queryWwnSuccess", false);
            LOGGER.error("Get aix wwn error:" + e);
        }
        WwnUtil.setResult2Launcher(launcher, resultCollect);
        return launcher;
    }

    private void getAixIscsiWwn(ICliConnection con, Launcher launcher, StringBuffer resultCollect) {
        String result = null;
        try {
            result = con.execCmd(ISCSI_COMMAND_1);
            resultCollect.append(result + "\n");
            if (WwnUtil.checkResultFailed(result, StarterType.ISCSI)) {
                WwnUtil.setFailedInLauncher(launcher);
                return;
            }
        }
        catch (ToolException e) {
            LOGGER.error("send iscsi command faild:lsdev | grep -i iscsi", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
            return;
        }
        String[] splitResult = result.split("\n");
        ArrayList<String> iscsiCommandList = new ArrayList<String>();
        if (splitResult.length < 2) {
            LOGGER.error("aix Iscsi get result error:" + result);
            return;
        }
        for (int i = 1; i < splitResult.length; ++i) {
            String resultWithTrim = splitResult[i].trim();
            int indexOf = resultWithTrim.indexOf(" ");
            if (indexOf <= 0) continue;
            String portName = resultWithTrim.substring(0, indexOf);
            iscsiCommandList.add(ISCSI_COMMAND_2 + portName);
        }
        ArrayList<String> iscsiResultList = new ArrayList<String>();
        for (String iscsiCommand : iscsiCommandList) {
            try {
                String iscsiCommandResult = con.execCmd(iscsiCommand);
                resultCollect.append(iscsiCommandResult + "\n");
                if (WwnUtil.checkResultFailed(result, StarterType.ISCSI)) {
                    WwnUtil.setFailedInLauncher(launcher);
                    return;
                }
                iscsiResultList.add(iscsiCommandResult);
            }
            catch (ToolException e) {
                WwnUtil.setFailedInLauncher(launcher);
                LOGGER.error("send iscsi command faild:" + iscsiCommand, (Throwable)e);
                return;
            }
            for (String iscsiResult : iscsiResultList) {
                this.getAixIscsiWwn(launcher, iscsiResult);
            }
        }
    }

    private void getAixIscsiWwn(Launcher launcher, String result) {
        String[] splitIscsiResult;
        for (String splitEveryIscsiResult : splitIscsiResult = Normalizer.normalize(result, Normalizer.Form.NFKC).split("\n")) {
            String[] split;
            if (!splitEveryIscsiResult.contains(ISCSI_KEY_WORD)) continue;
            for (String string : split = splitEveryIscsiResult.split(" ")) {
                if (!string.contains(ISCSI_KEY_WORD)) continue;
                launcher.getiSCSIWwns().add(string);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("get aix iscsi wwn success: " + string);
            }
        }
    }
}

