/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.host;

import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.service.host.LinuxHostServiceImpl;
import com.huawei.ism.tool.devicemanager.utils.StarterType;
import com.huawei.ism.tool.devicemanager.utils.WwnUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class HpuxHostServiceImpl
extends HostService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LinuxHostServiceImpl.class);
    private static final String HP_FC_COMMAND = "ioscan -funC fc";
    private static final String HP_FC_KEY_WORD_1 = "fc";
    private static final String HP_FC_KEY_WORD_2 = "Fibre Channel";
    private static final String HP_FC_COMMAND_2 = "scsimgr get_info -D ";
    private static final String HP_FC_KEY_WORD_3 = "Port name";
    private static final String LINUX_FC_REG_EXP = "[0-9|a-f]{16}";
    private static final String HP_ISCSI_COMMAND = "iscsiutil -l";
    private static final String HP_ISCSI_KEY_WORD = "Initiator Name";
    private static final String HP_ISCSI_REG_EXP = "iqn.(\\d{4}-\\d{2}.*)";

    @Override
    public Launcher queryWwn(ICliConnection con, DevNode devNode) {
        HashMap<StarterType, List<String>> hashMap = new HashMap<StarterType, List<String>>();
        WwnUtil.buildWwnData(hashMap, StarterType.ISCSI, HP_ISCSI_COMMAND, HP_ISCSI_KEY_WORD, HP_ISCSI_REG_EXP);
        Launcher launcher = new Launcher();
        StringBuffer resultCollect = new StringBuffer();
        try {
            WwnUtil.getAluaWwn(con, hashMap, launcher, resultCollect);
            this.getHpFcWwn(con, launcher, resultCollect);
        }
        catch (Exception e) {
            launcher.getOtherDataMap().put("queryWwnSuccess", false);
            LOGGER.error("Get aix wwn error:" + e);
        }
        WwnUtil.setResult2Launcher(launcher, resultCollect);
        return launcher;
    }

    private void getHpFcWwn(ICliConnection con, Launcher launcher, StringBuffer resultCollect) {
        String result = null;
        try {
            result = con.execCmd(HP_FC_COMMAND);
            resultCollect.append(result + "\n");
        }
        catch (ToolException e) {
            LOGGER.error("send HP fc name command faild:ioscan -funC fc", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
            return;
        }
        catch (Exception e) {
            LOGGER.error("send HP fc name command faild exception:ioscan -funC fc", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
            return;
        }
        result = Normalizer.normalize(result, Normalizer.Form.NFKC);
        String[] splitResult = result.split("\n");
        for (int i = 0; i < splitResult.length; ++i) {
            if (!splitResult[i].contains(HP_FC_KEY_WORD_1) || !splitResult[i].contains(HP_FC_KEY_WORD_2) || ++i >= splitResult.length) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("get hp fc name success:" + splitResult[i].trim());
            }
            HashMap<StarterType, List<String>> hpfcMap = new HashMap<StarterType, List<String>>();
            ArrayList<String> hpFcList = new ArrayList<String>();
            hpFcList.add(HP_FC_COMMAND_2 + splitResult[i].trim());
            hpFcList.add(HP_FC_KEY_WORD_3);
            hpFcList.add(LINUX_FC_REG_EXP);
            hpfcMap.put(StarterType.FC, hpFcList);
            WwnUtil.getAluaWwn(con, hpfcMap, launcher, resultCollect);
        }
    }
}

