/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.host;

import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.utils.StarterType;
import com.huawei.ism.tool.devicemanager.utils.WwnUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class VMwareHostServiceImpl
extends HostService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(VMwareHostServiceImpl.class);
    private static final String VMWARE_FCISCSI_COMMAND = "esxcfg-scsidevs -a";
    private static final String VMWARE_FC_KEY_WORD = "fc.";
    private static final String VMWARE_FC_REG_EXP = ":([0-9|a-f]{16})";
    private static final String VMWARE_ISCSI_KEY_WORD = "iqn.";
    private static final String VMWARE_ISCSI_KEY_WORD_1 = "iSCSI ";

    @Override
    public Launcher queryWwn(ICliConnection con, DevNode devNode) {
        Launcher launcher = new Launcher();
        StringBuffer resultCollect = new StringBuffer();
        try {
            this.getVmwareFcAndIscsiWwn(con, launcher, resultCollect);
        }
        catch (Exception e) {
            LOGGER.error("Get aix wwn error:" + e);
            WwnUtil.setFailedInLauncher(launcher);
        }
        WwnUtil.setResult2Launcher(launcher, resultCollect);
        return launcher;
    }

    private void getVmwareFcAndIscsiWwn(ICliConnection con, Launcher launcher, StringBuffer resultCollect) {
        String result = null;
        try {
            result = con.execCmd(VMWARE_FCISCSI_COMMAND);
            result = Normalizer.normalize(result, Normalizer.Form.NFKC);
            resultCollect.append(result + "\n");
            if (WwnUtil.checkResultFailed(result, StarterType.FC)) {
                WwnUtil.setFailedInLauncher(launcher);
                return;
            }
        }
        catch (ToolException e) {
            LOGGER.error("send Vmware iscsi command faild:esxcfg-scsidevs -a", (Throwable)e);
            WwnUtil.setFailedInLauncher(launcher);
            return;
        }
        String[] splitResult = result.split("\n");
        WwnUtil.setResult2Launcher(launcher, resultCollect);
        for (String everyResult : splitResult) {
            if (everyResult.contains(VMWARE_FC_KEY_WORD)) {
                Pattern p = Pattern.compile(VMWARE_FC_REG_EXP);
                Matcher m = p.matcher(everyResult.toLowerCase(Locale.ENGLISH));
                while (m.find()) {
                    m.group();
                    String wwn = m.group(1);
                    launcher.getFcWwns().add(wwn);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("get vmware fc wwn sussess:" + wwn);
                }
            }
            this.extractVmwareIscsiWwn(launcher, everyResult);
        }
    }

    private void extractVmwareIscsiWwn(Launcher launcher, String everyResult) {
        String normalizedEveryResult = Normalizer.normalize(everyResult, Normalizer.Form.NFKC);
        if (normalizedEveryResult.contains(VMWARE_ISCSI_KEY_WORD) && normalizedEveryResult.contains(VMWARE_ISCSI_KEY_WORD_1)) {
            int startIndex = normalizedEveryResult.indexOf(VMWARE_ISCSI_KEY_WORD);
            int endIndex = normalizedEveryResult.indexOf(VMWARE_ISCSI_KEY_WORD_1);
            launcher.getiSCSIWwns().add(normalizedEveryResult.substring(startIndex, endIndex).trim());
        }
    }
}

