/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.task.AiNodeUpdateTask;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceToolAction;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.MultiTaskResultMsg;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.NodeMsg;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.util.AuthResultShowUtil;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAiDeviceAction
extends DeviceToolAction {
    private static final Logger log = LoggerFactory.getLogger(UpdateAiDeviceAction.class);
    private final Window parent;

    @Override
    protected void abstractActionPerformed(ActionEvent event) {
        log.info("click update ai device");
        Object userObject = this.getUserObject();
        if (userObject instanceof List) {
            this.doBatchUpdate((List)this.getUserObject());
        }
    }

    private void doBatchUpdate(List<?> userObject) {
        CustMsgProgressDialog progressDialog = new CustMsgProgressDialog(this.parent);
        List<AiDevNode> nodes = userObject.stream().filter(obj -> obj instanceof AiDevNode).map(AiDevNode.class::cast).collect(Collectors.toList());
        AiNodeUpdateTask dmeUpdateTask = new AiNodeUpdateTask((ProgressDialog)progressDialog, nodes);
        Future result = AsyncExcutor.submit((Callable)dmeUpdateTask);
        if (progressDialog.isDisplayable()) {
            progressDialog.setVisible(true);
        }
        try {
            TaskResult taskResult = (TaskResult)result.get();
            if (TaskResult.Result.FAILED.equals((Object)taskResult.getResult())) {
                if (taskResult.getResultObject() instanceof MultiTaskResultMsg) {
                    AuthResultShowUtil.showTableInfos(this.parent, (MultiTaskResultMsg)taskResult.getResultObject(), ResourceUtil.getString((String)"update.result.info"));
                    this.logOperateFailed((MultiTaskResultMsg)taskResult.getResultObject(), nodes);
                }
                return;
            }
            UpdateAiDeviceAction.logOperateSuccess(nodes);
        }
        catch (InterruptedException | ExecutionException e) {
            this.logOperateDefaultFailed(nodes);
            log.error("get update dme result failed", (Throwable)e);
        }
    }

    private void logOperateDefaultFailed(List<AiDevNode> nodes) {
        nodes.forEach(node -> LogUtils.addOperaLog("operalog.name.upddevice", (DevNode)node, "device.config.changed"));
    }

    private static void logOperateSuccess(List<AiDevNode> nodes) {
        nodes.forEach(node -> LogUtils.addOperaLog("operalog.name.upddevice", (DevNode)node));
    }

    private void logOperateFailed(MultiTaskResultMsg resultMsg, List<AiDevNode> nodes) {
        Map failedIps = resultMsg.getResults().stream().collect(Collectors.toMap(NodeMsg::getIp, Function.identity()));
        for (AiDevNode node : nodes) {
            if (failedIps.containsKey(node.getIp())) {
                LogUtils.addOperaLog("operalog.name.upddevice", (DevNode)node, ((NodeMsg)failedIps.get(node.getIp())).getResultMsg());
                continue;
            }
            LogUtils.addOperaLog("operalog.name.upddevice", (DevNode)node);
        }
    }

    public boolean isAvailable() {
        return Objects.nonNull(this.getUserObject());
    }

    public UpdateAiDeviceAction(Window parent) {
        this.parent = parent;
    }
}

