/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.QuerySupportProductAction;
import com.huawei.ism.tool.devicemanager.ui.action.SceneAddDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.ModifyAiNodeDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.ScenePreparedMainJDialogLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.ShowSupportDevLayout;
import com.huawei.ism.tool.devicemanager.ui.former.DeviceSaveServiceFactory;
import com.huawei.ism.tool.devicemanager.ui.former.GetTooolSupportList;
import com.huawei.ism.tool.devicemanager.ui.former.SceneProductParser;
import com.huawei.ism.tool.devicemanager.ui.former.service.NodeSceneOptionService;
import com.huawei.ism.tool.devicemanager.ui.listener.AuthClusterNodes;
import com.huawei.ism.tool.devicemanager.ui.listener.CancelAction;
import com.huawei.ism.tool.devicemanager.ui.listener.ConfirmAction;
import com.huawei.ism.tool.devicemanager.ui.listener.DirSetupButtonListener;
import com.huawei.ism.tool.devicemanager.ui.listener.ModifyOperateAction;
import com.huawei.ism.tool.devicemanager.ui.listener.ScenePreparedMainJDialogListener;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.devicemanager.utils.DeviceForbidLoginUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.common.ISceneService;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardTitlePane;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.RootPaneUI;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class ScenePreparedMainJDialog
extends JDialog
implements INodeObserver {
    private static final Logger log = LoggerFactory.getLogger(ScenePreparedMainJDialog.class);
    private static final long serialVersionUID = 1L;
    private static final int SNS_LIST_MAX_LENTH = 3;
    private ScenePreparedMainJDialogLayout mainLayout = null;
    private ShowSupportDevLayout supportLayout = new ShowSupportDevLayout();
    public final WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    public final DeviceSceneContext context = DeviceSceneContext.getInstance();
    private Window parent;
    private List<String> supportDevTypeList = new ArrayList<String>();
    private Map<String, String> supportDevTypeAndVersMap = new HashMap<String, String>();
    private Map<String, TableRow> snRow = new HashMap<String, TableRow>();
    private List<DevNode> relatedDevNode = new ArrayList<DevNode>();

    private void initSceneSupportDevTyeAndVersionInfo() {
        SceneProductParser parser = new SceneProductParser();
        this.supportDevTypeAndVersMap = parser.parse();
        if (null == this.supportDevTypeAndVersMap) {
            log.error("Parse scene support device type and version failed.");
            return;
        }
        Iterator<String> devTypesItr = this.supportDevTypeAndVersMap.keySet().iterator();
        String devTypeString = "";
        while (devTypesItr.hasNext()) {
            devTypeString = devTypesItr.next();
            if (StringUtils.isNULLStr((String)devTypeString)) continue;
            this.supportDevTypeList.add(devTypeString);
        }
    }

    public ScenePreparedMainJDialog(Window parent, boolean isEdit) {
        super(parent);
        this.parent = parent;
        this.initUI(isEdit);
        this.initData();
        this.addListener();
        if (DeviceSceneContext.getInstance().isCurrentSceneSupportsHyperMetro()) {
            this.addHyperMetroListener();
        }
        this.initSceneSupportDevTyeAndVersionInfo();
        if (LocalHostUtil.isRunInSvp()) {
            ((WizardTitlePane)this.rootPaneUI.getTitleComponent()).getHelpButton().setVisible(false);
        }
    }

    private void initUI(boolean isEdit) {
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.mainLayout = new ScenePreparedMainJDialogLayout(isEdit);
        this.add(this.mainLayout);
        this.setTitle(ResourceUtil.getString((String)"scene.title"));
        this.setIconImage(ResourceUtil.getImage((String)"scene.png").getImage());
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setDefaultCloseOperation(0);
        this.context.setScenePreparedMainJDialog(this);
        this.addNodeObserver();
    }

    private void initData() {
        this.mainLayout.getDeviceTable().removeAll();
        this.mainLayout.getDeviceTableModel().getRowList().clear();
        IDeviceManage deviceManage = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        List<DevNode> devs = this.showNodesByScene(deviceManage.getNodeList());
        Set<String> unSupportDevSNs = this.getUnSupportDevSns(devs);
        List<DevNode> devsXML = SceneXmlData.getInstance().loadSceneFromFile();
        devsXML = DeviceForbidLoginUtil.filterForbidDevContainsShowErrMsg(devsXML);
        for (DevNode dev : devs) {
            Map<String, String> support = this.supportLayout.getShowInfos();
            for (Map.Entry<String, String> i : support.entrySet()) {
                String deviceType = i.getKey();
                String value = i.getValue();
                String[] versions = value.split(",");
                String deviceSN = dev.getDeviceSerialNumber();
                for (String version : versions) {
                    if (unSupportDevSNs.contains(deviceSN)) {
                        log.error("[Scene init data] Device: {} is highEnd device or domain user, not support!", (Object)deviceSN);
                        continue;
                    }
                    if ((!deviceType.equals(String.valueOf(dev.getDeviceType())) || !Products.contains((String)dev.getProductVersion(), (String)version)) && !this.isReplaceSceneAndHost(dev)) continue;
                    this.mainLayout.getDeviceTableModel().addRow(new TableRow[]{this.createTableRow(dev)});
                    int row = this.mainLayout.getDeviceTable().getRowCount() - 1;
                    this.isSelecteDev(dev, devsXML, row);
                }
            }
        }
        if (DeviceSceneContext.getInstance().isSingleDev() && !devs.isEmpty()) {
            List markRows = this.mainLayout.getDeviceTable().getMarkedRows();
            if (null == markRows || markRows.isEmpty()) {
                return;
            }
            TableRow tRow = (TableRow)markRows.get(0);
            DevNode dev = (DevNode)tRow.getUserObject();
            if (dev.isHyperMetro()) {
                for (DevNode remoteDev : devs) {
                    String remoteSn = remoteDev.getDeviceSerialNumber();
                    if (!dev.getRemoteSNs().contains(remoteSn)) continue;
                    this.setColor(this.snRow.get(remoteSn), UIManager.getColor("Table.rolloverColor"));
                    this.addRelatedDevNode(remoteDev);
                }
            }
        }
    }

    @NotNull
    private Set<String> getUnSupportDevSns(List<DevNode> devs) {
        Optional<NodeSceneOptionService<?>> nodeSceneOptionService = DeviceSaveServiceFactory.buildServiceByScene();
        if (nodeSceneOptionService.isPresent()) {
            return Collections.emptySet();
        }
        return this.filterUnSupportNodesByDefaultMethod(devs);
    }

    @NotNull
    private Set<String> filterUnSupportNodesByDefaultMethod(List<DevNode> devs) {
        HashSet<String> unSupportDevSNs = new HashSet<String>(this.getUnsupportHighEndDevSNs(devs));
        unSupportDevSNs.addAll(this.getUnSupportDomainUserTools(devs));
        return unSupportDevSNs;
    }

    private List<DevNode> showNodesByScene(List<DevNode> nodeList) {
        Optional<NodeSceneOptionService<?>> nodeSceneOptionService = DeviceSaveServiceFactory.buildServiceByScene();
        if (nodeSceneOptionService.isPresent()) {
            return nodeSceneOptionService.get().buildPrepareShowNode(nodeList);
        }
        this.filterNotCurSvpDev(nodeList);
        return nodeList;
    }

    private boolean isReplaceSceneAndHost(DevNode dev) {
        return DeviceAddUtil.isReplaceCertScene() && ItDeviceType.Host.equals((Object)dev.getItDeviceType());
    }

    private List<String> getUnSupportDomainUserTools(List<DevNode> devs) {
        ArrayList<String> unSupportDevSNs = new ArrayList<String>();
        if (this.isNotIncludeDomain(devs)) {
            log.info("Domain users are not included.");
            return unSupportDevSNs;
        }
        String subScene = GetTooolSupportList.getNeededSceneID();
        if (ArrayUtils.isSupportDomainUserAdd((String)subScene)) {
            log.info("In this scenario {}, domain users can log in to the system.", (Object)subScene);
            return unSupportDevSNs;
        }
        ArrayList<ArrayList<Object>> unSupportDevs = new ArrayList<ArrayList<Object>>();
        devs.stream().filter(dev -> dev.getLoginUser().getUserName().startsWith("domain/")).forEach(dev -> this.saveUnSupportDevInfo((DevNode)dev, unSupportDevs, unSupportDevSNs));
        if (!unSupportDevSNs.isEmpty()) {
            this.hintUnSupportDev(unSupportDevs);
        }
        return unSupportDevSNs;
    }

    private boolean isNotIncludeDomain(List<DevNode> devs) {
        return devs.stream().noneMatch(dev -> dev.getLoginUser().getUserName().startsWith("domain/"));
    }

    private void hintUnSupportDev(ArrayList<ArrayList<Object>> unSupportDevs) {
        log.error("[initData] This scenario does not support devices that are logged in as domain users. {}", (Object)unSupportDevs.toString());
        SubDialogUtils.showMultiInfoDialogOnTop(ResourceUtil.getString((String)"scene.domain.user.not.support.add.error"), new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devsn")}, unSupportDevs);
    }

    private void saveUnSupportDevInfo(DevNode dev, ArrayList<ArrayList<Object>> unSupportDevs, ArrayList<String> unSupportDevSNs) {
        ArrayList<String> unSupportDev = new ArrayList<String>();
        unSupportDev.add(dev.getIp());
        unSupportDev.add(dev.getDeviceSerialNumber());
        unSupportDevs.add(unSupportDev);
        unSupportDevSNs.add(dev.getDeviceSerialNumber());
    }

    private void filterNotCurSvpDev(List<DevNode> devs) {
        DevNode curDev = DeviceSceneContext.getInstance().getCurSvpNode();
        if (null != curDev && devs.size() > 1 && !ArrayUtils.isHighEndDevSupportSvpAdd((String)GetTooolSupportList.getNeededSceneID()) && !DeviceAddUtil.isReplaceCertScene()) {
            devs.clear();
            devs.add(curDev);
        }
    }

    private ArrayList<String> getUnsupportHighEndDevSNs(List<DevNode> devs) {
        ArrayList unSupportDevs = new ArrayList();
        ArrayList<String> unSupportDevSNs = new ArrayList<String>();
        if (LocalHostUtil.isRunInSvp()) {
            return unSupportDevSNs;
        }
        String subScene = GetTooolSupportList.getNeededSceneID();
        if (ArrayUtils.isHighEndDevSupportSvpAdd((String)subScene)) {
            return unSupportDevSNs;
        }
        for (DevNode devNode : devs) {
            if (!DeviceTypeUtil.hasSVPModule((com.huawei.ism.tool.obase.entity.DevNode)EntityUtils.toOldDev((DevNode)devNode))) continue;
            ArrayList<String> unSupportDev = new ArrayList<String>();
            unSupportDev.add(devNode.getIp());
            unSupportDev.add(devNode.getDeviceSerialNumber());
            unSupportDevs.add(unSupportDev);
            unSupportDevSNs.add(devNode.getDeviceSerialNumber());
        }
        if (!unSupportDevSNs.isEmpty()) {
            log.error("[initData] High end device not support out svp: {}", unSupportDevs);
            SubDialogUtils.showMultiInfoDialogOnTop(ResourceUtil.getString((String)"scene.outSvp.highEndDev.notsupport.start.error"), new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devsn")}, unSupportDevs);
        }
        return unSupportDevSNs;
    }

    private void isSelecteDev(DevNode dev, List<DevNode> devsXML, int row) {
        Optional<List> readNodes = DeviceSaveServiceFactory.buildServiceByScene().map(NodeSceneOptionService::readExtend).map(nodes -> nodes.stream().filter(node -> node instanceof AiDevNode).map(node -> (AiDevNode)node).collect(Collectors.toList()));
        if (null != devsXML) {
            for (DevNode devNode : devsXML) {
                if (!ScenePreparedMainJDialog.isSelected(dev, devNode) && (!readNodes.isPresent() || !this.subNodesSelect(dev, readNodes.get()))) continue;
                this.mainLayout.getDeviceTable().addRowSelectionInterval(row, row);
            }
        }
    }

    private boolean subNodesSelect(DevNode dev, List<AiDevNode> readNodes) {
        return readNodes.stream().anyMatch(aiNode -> ScenePreparedMainJDialog.isA800Select(dev, aiNode) || this.isOmSelect(dev, (AiDevNode)aiNode));
    }

    private boolean isOmSelect(DevNode dev, AiDevNode aiNode) {
        return aiNode.getOmNodes().stream().filter(DmeNode::isSelect).anyMatch(node -> node.getIp().equals(dev.getIp()));
    }

    private static boolean isA800Select(DevNode dev, AiDevNode aiNode) {
        return aiNode.getA800Nodes().stream().filter(DmeNode::isSelect).anyMatch(a800 -> a800.getDeviceSerialNumber().equals(dev.getDeviceSerialNumber()));
    }

    private static boolean isSelected(DevNode dev, DevNode devNode) {
        return devNode.getDeviceSerialNumber().equals(dev.getDeviceSerialNumber());
    }

    private void addListener() {
        this.addWindowListener(new ScenePreparedMainJDialogListener(this){

            @Override
            public void okCallback() {
                DeviceSceneContext.getInstance().fireToolStopped();
                DefaultNodeProviderImpl.getInstance().removeNodeObserver(ScenePreparedMainJDialog.this.getClass());
            }

            @Override
            public void cancelCallback() {
                ScenePreparedMainJDialog.this.setDefaultCloseOperation(0);
            }
        });
        this.mainLayout.getAddDeviceLabel().addClickListener((ToolHyperLinkLabel.ClickListener)new SceneAddDeviceAction(this));
        this.mainLayout.getSupportProductLabel().addClickListener((ToolHyperLinkLabel.ClickListener)new QuerySupportProductAction(this));
        this.mainLayout.getSetPathButton().addActionListener(new DirSetupButtonListener(this, this.getMainLayout().getSavePathText().getText()){

            @Override
            public void callback(String path) {
                ISceneService getSceneContextService = (ISceneService)PublicServiceManage.getInstance().getService(ISceneService.class);
                getSceneContextService.setReportPath(path);
                ApplicationContext.getInstance().setFilePath(path);
                ScenePreparedMainJDialog.this.getMainLayout().getSavePathText().setText(path);
                ScenePreparedMainJDialog.this.getMainLayout().getSavePathText().setToolTipText(path);
            }
        });
        this.mainLayout.getOkBtn().addActionListener(new ConfirmAction(this));
        this.mainLayout.getCancleBtn().addActionListener(new CancelAction());
    }

    private void addHyperMetroListener() {
        this.mainLayout.getDeviceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            boolean applyMark = false;
            List<TableRow> allRemoteRows;
            List<TableRow> allSelectedRows;
            List<TableRow> lastSlection = new ArrayList<TableRow>();

            @Override
            public void valueChanged(ListSelectionEvent selectionEvent) {
                this.initDevSNs();
                if (DeviceSceneContext.getInstance().isSingleDev()) {
                    this.signRemoteDevnode();
                } else {
                    boolean doReturn;
                    boolean bl = doReturn = selectionEvent.getValueIsAdjusting() || this.applyMark || ScenePreparedMainJDialog.this.mainLayout.getDeviceTable().getRowCount() == 0;
                    if (doReturn) {
                        return;
                    }
                    this.applyMark = true;
                    if (this.lastSlection.size() > this.allSelectedRows.size() && this.doCancleOp(this.lastSlection, this.allSelectedRows)) {
                        this.applyMark = false;
                        this.lastSlection = this.allSelectedRows;
                        return;
                    }
                    this.selectAllHyperMetroDevs();
                    this.applyMark = false;
                }
                ScenePreparedMainJDialog.this.mainLayout.getDeviceTable().repaint();
            }

            private void signRemoteDevnode() {
                for (TableRow row : ScenePreparedMainJDialog.this.snRow.values()) {
                    boolean isColor = !this.allRemoteRows.isEmpty() && this.allRemoteRows.contains(row);
                    ScenePreparedMainJDialog.this.setColor(row, isColor ? UIManager.getColor("Table.rolloverColor") : null);
                    if (!isColor) continue;
                    ScenePreparedMainJDialog.this.addRelatedDevNode((DevNode)row.getUserObject());
                }
            }

            private boolean doCancleOp(List<TableRow> lastRows, List<TableRow> curRows) {
                for (TableRow row : curRows) {
                    if (lastRows.contains(row)) continue;
                    return false;
                }
                return true;
            }

            private void selectAllHyperMetroDevs() {
                ArrayList<TableRow> rows = new ArrayList<TableRow>();
                rows.addAll(this.allSelectedRows);
                rows.addAll(this.allRemoteRows);
                ScenePreparedMainJDialog.this.mainLayout.getDeviceTable().markTableRow(rows.toArray(new TableRow[rows.size()]));
                this.lastSlection = rows;
            }

            private void initDevSNs() {
                this.allRemoteRows = new ArrayList<TableRow>();
                this.allSelectedRows = new ArrayList<TableRow>();
                this.allSelectedRows = ScenePreparedMainJDialog.this.mainLayout.getDeviceTable().getMarkedRows();
                for (TableRow row : this.allSelectedRows) {
                    DevNode dev;
                    if (!(row.getUserObject() instanceof DevNode) || !(dev = (DevNode)row.getUserObject()).isHyperMetro()) continue;
                    this.addRemoteRows(dev);
                }
            }

            private void addRemoteRows(DevNode dev) {
                for (String sn : dev.getRemoteSNs()) {
                    TableRow row = (TableRow)ScenePreparedMainJDialog.this.snRow.get(sn);
                    if (!ScenePreparedMainJDialog.this.snRow.containsKey(sn) || this.allSelectedRows.contains(row)) continue;
                    this.allRemoteRows.add(row);
                }
            }
        });
    }

    private void addNodeObserver() {
        DefaultNodeProviderImpl.getInstance().addNodeObservers(this);
    }

    public ScenePreparedMainJDialogLayout getMainLayout() {
        return this.mainLayout;
    }

    public void setMainLayout(ScenePreparedMainJDialogLayout mainLayout) {
        this.mainLayout = mainLayout;
    }

    @Override
    public void fireNodeAdd(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        DevNode dev = EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)devNode);
        this.context.setCurrentAddDevIp(dev.getIp());
        this.context.setCurrentAddDevSN(dev.getDeviceSerialNumber());
        this.context.setCurrentAddDevType(dev.getDeviceType().toString());
        for (DevNode node : this.showNodesByScene(Collections.singletonList(dev))) {
            if (this.isNotAuthOm(node)) continue;
            this.addOneNode(devNode, node);
        }
    }

    private boolean isNotAuthOm(DevNode node) {
        return ItDeviceType.A800_OM.equals((Object)node.getItDeviceType()) && StringUtils.isNULLStr((String)node.getProductVersion());
    }

    private void addOneNode(com.huawei.ism.tool.obase.entity.DevNode devNode, DevNode dev) {
        log.info("fire node add in scene;devs ip={}", (Object)dev.getIp());
        if (!this.supportLayout.isSupport(dev)) {
            log.info("devs ip={} is ignored", (Object)dev.getIp());
            this.context.setSupport(false);
            this.context.getUnSupportDevs().add(dev.getIp());
            return;
        }
        if (!LocalHostUtil.isRunInSvp() && DeviceTypeUtil.hasSVPModule((com.huawei.ism.tool.obase.entity.DevNode)devNode) && !ArrayUtils.isHighEndDevSupportSvpAdd((String)GetTooolSupportList.getNeededSceneID())) {
            log.info("devs ip={} is high end device, does not support to add out of svp, ignored", (Object)dev.getIp());
            this.context.setHighEndDeviceSupport(false);
            this.context.getUnSupportHighEndDevs().add(dev.getIp());
            return;
        }
        if (this.isLoginWithDomainUserErrorScenario(devNode)) {
            this.saveErrorInfo(devNode);
            return;
        }
        TableRow<DevNode, String> row = this.createTableRow(dev);
        this.checkDeviceExists(dev, row);
    }

    private void saveErrorInfo(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        log.error("In this scenario ({}), the device ({}) cannot be logged in as a domain user.", (Object)GetTooolSupportList.getNeededSceneID(), (Object)devNode.getIp());
        this.context.getUnSupportDomainUserDevs().add(devNode.getIp());
    }

    private boolean isLoginWithDomainUserErrorScenario(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return devNode.getLoginUser().getUserName().startsWith("domain/") && !ArrayUtils.isSupportDomainUserAdd((String)GetTooolSupportList.getNeededSceneID());
    }

    private void checkDeviceExists(DevNode dev, TableRow row) {
        List oldRows = this.mainLayout.getDeviceTableModel().getAllRows();
        if (!oldRows.contains(row)) {
            int size = oldRows.size();
            oldRows.add(size, row);
            this.mainLayout.getDeviceTableModel().addRow(oldRows);
            if (this.needDoCascadeOp(dev, (TableRow<DevNode, String>)row)) {
                if (DeviceSceneContext.getInstance().isSingleDev()) {
                    this.setColor(row, UIManager.getColor("Table.rolloverColor"));
                    this.addRelatedDevNode(dev);
                } else {
                    this.mainLayout.getDeviceTable().addRowSelectionInterval(size, size);
                }
            }
        } else {
            this.mainLayout.getDeviceTableModel().addRow(oldRows);
        }
    }

    @Override
    public void fireNodeDelete(com.huawei.ism.tool.obase.entity.DevNode dev) {
    }

    @Override
    public void fireNodeModify(com.huawei.ism.tool.obase.entity.DevNode device) {
        this.initData();
    }

    private TableRow<DevNode, String> createTableRow(DevNode dev) {
        DefaultTableRow row = new DefaultTableRow(this.mainLayout.getTableColumn(), (Object)dev, (Object)dev.getDeviceSerialNumber());
        int i = 0;
        if (dev.isHyperMetro()) {
            IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(dev.getDeviceType().toString(), (Icon)ResourceUtil.getImage((String)"hyperMetroIcon.png"));
            String sns = dev.getRemoteSNs().toString();
            sns = sns.substring(sns.indexOf(91) + 1, sns.indexOf(93));
            sns = this.cutTooLongSns2Lines(sns);
            cell.setTips(ResourceUtil.getStringWithParams((String)"devicemanager.layout.hypermetro.device.tips", (Object[])new Object[]{sns}));
            row.setValueAt(i++, (Object)cell);
        } else {
            row.setValueAt(i++, (Object)new IsmTableCell.TextCell(dev.getDeviceType().toString()));
        }
        String deviceName = dev.getDeviceName();
        row.setValueAt(i++, (Object)new IsmTableCell.TextCell(deviceName));
        row.setValueAt(i++, (Object)new IsmTableCell.TextCell(dev.getProductVersion()));
        row.setValueAt(i++, (Object)new IsmTableCell.TextCell(new IpAddressStrategy(dev.getIp()).toString()));
        row.setValueAt(i++, (Object)new IsmTableCell.TextCell(this.getUsername(dev)));
        Object changeOperateCell = this.getHyperlinkCell(dev);
        row.setValueAt(i++, changeOperateCell);
        this.snRow.put(dev.getDeviceSerialNumber(), (TableRow)row);
        return row;
    }

    private String getUsername(DevNode dev) {
        if (dev.isFusionCompute()) {
            return dev.getAdminUser().getUserName();
        }
        if (dev.getLoginUser() == null) {
            return "";
        }
        return dev.getLoginUser().getUserName();
    }

    @NotNull
    private Object getHyperlinkCell(DevNode dev) {
        String changeOperate = ResourceUtil.getString((String)"scene.devicetable.head.modify");
        IsmTableCell.HyperlinkCell hyperlinkCell = new IsmTableCell.HyperlinkCell(changeOperate, (ActionListener)new ModifyOperateAction(this, dev.getDeviceSerialNumber()));
        if (ItDeviceType.A800_NODE.equals((Object)dev.getItDeviceType())) {
            return this.findDmeWithA800(dev).map(node -> new IsmTableCell.HyperlinkCell(changeOperate, event -> this.showModifyDmeUi((AiDevNode)node))).orElse(hyperlinkCell);
        }
        if (!(dev.isFusionCube() || dev.isFusionStorage() || dev.isFusionCompute())) {
            return hyperlinkCell;
        }
        com.huawei.ism.tool.obase.entity.DevNode devNode = DefaultNodeProviderImpl.getInstance().findDevNode(dev.getDeviceSerialNumber());
        if (Objects.isNull(devNode)) {
            return hyperlinkCell;
        }
        if (devNode.isNeedAuthClusterNodes()) {
            String string = ResourceUtil.getString((String)"scene.devicetable.head.config");
            return new IsmTableCell.HyperlinkCell(string, (ActionListener)new AuthClusterNodes(this, devNode));
        }
        if (DeviceAddUtil.isReplaceCertScene()) {
            return "N/A";
        }
        return hyperlinkCell;
    }

    private void showModifyDmeUi(AiDevNode dmeWithA800) {
        new ModifyAiNodeDialog((Window)this, dmeWithA800).setVisible(true);
    }

    private Optional<AiDevNode> findDmeWithA800(DevNode dev) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(node -> node instanceof AiDevNode).map(AiDevNode.class::cast).filter(node -> ScenePreparedMainJDialog.isA800Match(dev, node)).findFirst();
    }

    private static boolean isA800Match(DevNode dev, AiDevNode node) {
        return node.getA800Nodes().stream().anyMatch(a800 -> a800.getDeviceSerialNumber().endsWith(dev.getDeviceSerialNumber()));
    }

    private String cutTooLongSns2Lines(String sns) {
        String[] snsList = sns.split(",");
        String snsParsed = "";
        for (int poi = 0; poi < snsList.length; ++poi) {
            snsParsed = poi != 0 && poi % 3 == 0 ? snsParsed + snsList[poi] + ",<br/>" : (poi + 1 == snsList.length ? snsParsed + snsList[poi] : snsParsed + snsList[poi] + ",");
        }
        return snsParsed;
    }

    private boolean needDoCascadeOp(DevNode dev, TableRow<DevNode, String> row) {
        if (dev.isHyperMetro()) {
            for (TableRow tableRow : this.mainLayout.getDeviceTable().getMarkedRows()) {
                DevNode selectDev = (DevNode)tableRow.getUserObject();
                String sn = selectDev.getDeviceSerialNumber();
                if (!dev.getRemoteSNs().contains(sn)) continue;
                return true;
            }
        }
        return false;
    }

    public void setHelpActionCallBack(IHelpActionCallBack helpActionCallBack) {
        this.rootPaneUI.setHelpActionCallBack(helpActionCallBack);
    }

    public List<String> getSupportDevTypeList() {
        return this.supportDevTypeList;
    }

    public void setSupportDevTypeList(List<String> supportDevTypeList) {
        this.supportDevTypeList = supportDevTypeList;
    }

    public Map<String, String> getSupportDevTypeAndVersMap() {
        return this.supportDevTypeAndVersMap;
    }

    public void setSupportDevTypeAndVersMap(Map<String, String> supportDevTypeAndVersMap) {
        this.supportDevTypeAndVersMap = supportDevTypeAndVersMap;
    }

    public Map<String, TableRow> getSnRow() {
        return this.snRow;
    }

    public List<DevNode> getRelatedDevNode() {
        return this.relatedDevNode;
    }

    public void addRelatedDevNode(DevNode dev) {
        if (!this.relatedDevNode.contains(dev)) {
            this.relatedDevNode.add(dev);
        }
    }

    public void showAddDevLink() {
        this.mainLayout.getAddDeviceLabel().setVisible(true);
        this.mainLayout.getDescriptionLabelA().setVisible(true);
    }

    private void setColor(TableRow tableRow, Color col) {
        for (int i = 0; i < tableRow.getColumnCount(); ++i) {
            if (!(tableRow.getValueAt(i) instanceof IsmTableCell)) continue;
            IsmTableCell cell = (IsmTableCell)tableRow.getValueAt(i);
            cell.setColor(col);
        }
    }
}

