/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.component;

import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AuthInfoInputPanel
extends JPanel {
    private final String portLabelDesc = ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.sshport");
    private final JComponent portLabel = UiMethod.createRequiredLabel((String)(this.portLabelDesc + ":"), (boolean)true);
    private final IsmTextField portInput = UiMethod.getSshPortFiled();
    private final String usernameLabelDesc = ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devusername");
    private final JComponent usernameLabel = UiMethod.createRequiredLabel((String)(this.usernameLabelDesc + ":"), (boolean)true);
    private final IsmTextField usernameInput = IsmTextField.getNameTextField((String)".*", (String)"", (int)60, (int)0);
    private final String pwdLabelDesc = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.pwd");
    private final JComponent pwdLabel = UiMethod.createRequiredLabel((String)(this.pwdLabelDesc + ":"), (boolean)true);
    private final IsmPasswordField pwdInput = UiMethod.getPasswordFiled();

    public AuthInfoInputPanel() {
        this.initUi();
        this.initVerifier();
    }

    private void initVerifier() {
        this.portInput.addInputValidator((InputValidator)new NotEmptyInputValidator());
        this.portInput.setInputValueName(this.portLabelDesc);
        this.usernameInput.addInputValidator((InputValidator)new NotEmptyInputValidator());
        this.usernameInput.setInputValueName(this.usernameLabelDesc);
        this.pwdInput.addInputValidator((InputValidator)new NotEmptyInputValidator());
        this.pwdInput.setInputValueName(this.pwdLabelDesc);
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createViewComponent(), "West");
    }

    private JComponent createViewComponent() {
        Box protCom = UCD.buildHBoxLeft((Component[])new Component[]{this.portLabel, this.portInput});
        Box userCom = UCD.buildHBoxLeft((Component[])new Component[]{this.usernameLabel, this.usernameInput});
        Box pwdCom = UCD.buildHBoxLeft((Component[])new Component[]{this.pwdLabel, this.pwdInput});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{userCom, pwdCom, protCom});
    }

    public void validInput() throws ToolException {
        String errorDesc;
        StringBuilder errorMsg = new StringBuilder();
        for (IsmTextField ismTextField : Arrays.asList(this.usernameInput, this.portInput)) {
            String error = ismTextField.validateInput();
            if (StringUtils.isNULLStr((String)error)) continue;
            errorMsg.append(error).append(System.lineSeparator());
        }
        String pwdError = this.pwdInput.validateInput();
        if (!StringUtils.isNULLStr((String)pwdError)) {
            errorMsg.append(pwdError);
        }
        if (!(errorDesc = errorMsg.toString()).isEmpty()) {
            throw new ToolException(errorDesc, false);
        }
    }

    public void setLabelSize(Dimension size) {
        UiMethod.setComponentSize((Dimension)size, (Component[])new Component[]{this.usernameLabel, this.portLabel, this.pwdLabel});
    }

    public void setLabelSize(List<JComponent> components) {
        ArrayList<JComponent> copyComponents = new ArrayList<JComponent>(components);
        copyComponents.add(this.usernameLabel);
        copyComponents.add(this.portLabel);
        copyComponents.add(this.pwdLabel);
        UiMethod.setComponentSameMaxWidthSize((JComponent[])copyComponents.toArray(new JComponent[0]));
    }

    public void setFieldSize(Dimension size) {
        UiMethod.setComponentSize((Dimension)size, (Component[])new Component[]{this.usernameInput, this.portInput, this.pwdInput});
    }

    public User buildLoginInfo() {
        return new User(this.usernameInput.getText(), new String(this.pwdInput.getPassword()), Integer.parseInt(this.portInput.getText()));
    }

    public void setDefaultPort(String port) {
        this.portInput.setText(port);
    }

    public void setUsernameDefault(String username) {
        this.usernameInput.setText(username);
    }
}

