/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.component;

import com.huawei.ism.tool.devicemanager.ui.dialog.component.AuthInfoInputPanel;
import com.huawei.ism.tool.obase.config.validate.IpInputValidator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.wizard.YesAndNoRadioPanel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class LoginInfoInputPanel
extends JPanel {
    private final String ipLabelDesc = ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip");
    private final JComponent ipLabel = UiMethod.createRequiredLabel((String)(this.ipLabelDesc + ":"), (boolean)true);
    private final IsmTextField ipInput = UiMethod.createIpv4v6TextField();
    private final AuthInfoInputPanel authInfoInputPanel = new AuthInfoInputPanel();
    private final JLabel certificateLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.certificate"));
    private final YesAndNoRadioPanel yesAndNoButtonPanel = new YesAndNoRadioPanel();

    public LoginInfoInputPanel() {
        this.initUi();
        this.initData();
        this.initSize();
    }

    private void initData() {
        this.ipInput.addInputValidator((InputValidator)new NotEmptyInputValidator());
        this.ipInput.addInputValidator((InputValidator)new IpInputValidator());
        this.ipInput.setInputValueName(this.ipLabelDesc);
    }

    private void initSize() {
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{this.certificateLabel, this.ipLabel});
        this.authInfoInputPanel.setLabelSize(this.certificateLabel.getMaximumSize());
        Dimension fieldSize = new Dimension(150, 21);
        this.authInfoInputPanel.setFieldSize(fieldSize);
        UiMethod.setComponentSize((Dimension)fieldSize, (Component[])new Component[]{this.ipInput});
    }

    private void initUi() {
        this.setLayout(new FlowLayout(0));
        this.add(UCD.buildVerticalBox(null, (Component[])new Component[]{this.createViewComponent(), this.creatCertComponent()}));
    }

    private JComponent creatCertComponent() {
        JLabel tipLabel = new JLabel(ResourceUtil.getImage((String)"question.png"));
        tipLabel.setToolTipText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.certificate.help"));
        return UCD.buildHBoxLeft((Component[])new Component[]{this.certificateLabel, tipLabel, this.yesAndNoButtonPanel, Box.createVerticalStrut(0)});
    }

    @NotNull
    private JComponent createViewComponent() {
        Box ipCom = UCD.buildHBoxLeft((Component[])new Component[]{this.ipLabel, this.ipInput});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{ipCom, this.authInfoInputPanel, Box.createVerticalStrut(0)});
    }

    public void validInput() throws ToolException {
        StringBuilder errorMsg = new StringBuilder();
        String error = this.ipInput.validateInput();
        if (!StringUtils.isNULLStr((String)error)) {
            errorMsg.append(error).append(System.lineSeparator());
        }
        try {
            this.authInfoInputPanel.validInput();
        }
        catch (ToolException e) {
            errorMsg.append(e.getErrorLocaleDescription());
        }
        String errorString = errorMsg.toString();
        if (!StringUtils.isNULLStr((String)errorString)) {
            throw new ToolException(errorString, false);
        }
    }

    public DevNode buildLoginNode() {
        DevNode devNode = new DevNode();
        devNode.setIp(this.ipInput.getText());
        devNode.setLoginUser(this.authInfoInputPanel.buildLoginInfo());
        devNode.setPort(devNode.getLoginUser().getPort());
        devNode.setVerifyCertificate(this.yesAndNoButtonPanel.isSelectedYes());
        return devNode;
    }

    public void setDefaultPort(String port) {
        this.authInfoInputPanel.setDefaultPort(port);
    }
}

