/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.component;

import com.huawei.ism.tool.devicemanager.observer.AuthTaskObserver;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.enums.NodeAuthState;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class ScrollTablePanel
extends JPanel
implements AuthTaskObserver {
    private final JButton batchAuthBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.zone.login"));
    private final String[] tableHeaderColumns = new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devtype"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devtname"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.state")};
    private final DefaultTableModel deviceTableModel = new DefaultTableModel(this.tableHeaderColumns, new int[0]);
    private final IsmTable dataTable = new IsmTable((TableModel)this.deviceTableModel, true);

    public ScrollTablePanel() {
        this.initUi();
        this.batchAuthBtn.setEnabled(false);
    }

    public void setTableData(List<? extends DevNode> showDevices) {
        this.dataTable.removeAll();
        this.deviceTableModel.removeAll();
        ArrayList<DefaultTableRow> datas = new ArrayList<DefaultTableRow>();
        for (DevNode devNode : showDevices) {
            DefaultTableRow nodeRow = new DefaultTableRow(this.deviceTableModel.getColumnCount(), (Object)devNode, (Object)devNode);
            this.setRowValue((TableRow<DevNode, DevNode>)nodeRow, devNode);
            datas.add(nodeRow);
        }
        this.deviceTableModel.addRows(datas);
        this.dataTable.markTableRows(showDevices.toArray());
        this.batchAuthBtn.setEnabled(true);
    }

    public void bindListener(ActionListener actionListener) {
        this.batchAuthBtn.addActionListener(actionListener);
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.add((Component)UCD.buildVerticalBox(null, (Component[])new Component[]{this.createTopPanel(), this.createMiddlePanel()}), "North");
    }

    private JComponent createTopPanel() {
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.batchAuthBtn})});
    }

    private void setRowValue(TableRow<DevNode, DevNode> nodeRow, DevNode zoneNode) {
        int index = 0;
        nodeRow.setValueAt(index++, (Object)zoneNode.getIp());
        nodeRow.setValueAt(index++, (Object)zoneNode.getProductModel());
        nodeRow.setValueAt(index++, (Object)zoneNode.getDeviceName());
        nodeRow.setValueAt(index, (Object)this.getAuthStatus(zoneNode));
    }

    private String getAuthStatus(DevNode node) {
        return node.getLoginUser() != null ? NodeAuthState.SUCCESS.getDesc() : NodeAuthState.UN_AUTH.getDesc();
    }

    private JComponent createDataTableCom() {
        ToolUCD.setStandardFont((JComponent[])new JComponent[]{this.dataTable.getTableHeader()});
        TableScrollPane tableScrollPane = new TableScrollPane(this.dataTable, true, true, true);
        UiMethod.setComponentSize((Dimension)new Dimension(415, 370), (Component[])new Component[]{tableScrollPane});
        JComponent tableComponent = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(2), tableScrollPane});
        tableComponent.setBorder(new TitledBorder(ResourceUtil.getString((String)"devicemanager.layout.devicemgr.labelname")));
        return tableComponent;
    }

    private JComponent createMiddlePanel() {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), this.createDataTableCom()});
    }

    public void updateTableRow(TaskResult.Result result, Object identifier) {
        if (identifier instanceof DevNode && TaskResult.Result.FAILED.equals((Object)result)) {
            ((DevNode)identifier).setLoginUser(null);
        }
        this.dataTable.getAllRows().stream().filter(row -> row.getIdentifier().equals(identifier)).forEach(row -> row.setValueAt(row.getColumnCount() - 1, (Object)this.getAuthStatus(result)));
    }

    private String getAuthStatus(TaskResult.Result result) {
        return TaskResult.Result.SUCCESS.equals((Object)result) ? NodeAuthState.SUCCESS.getDesc() : NodeAuthState.FAIL.getDesc();
    }

    @Override
    public void notifyResult(TaskResult result) {
        this.updateTableRow(result.getResult(), result.getResultObject());
    }

    public List<DevNode> getSelectNodes() {
        return this.dataTable.getMarkedRows().stream().map(TableRow::getIdentifier).filter(DevNode.class::isInstance).map(DevNode.class::cast).collect(Collectors.toList());
    }

    public boolean hasNoAuthRow() {
        return this.dataTable.getAllRows().stream().map(TableRow::getIdentifier).filter(DevNode.class::isInstance).map(DevNode.class::cast).anyMatch(node -> Objects.isNull(node.getLoginUser()));
    }

    public IsmTable getDataTable() {
        return this.dataTable;
    }
}

