/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.layout.aistorage;

import com.huawei.ism.tool.devicemanager.enums.LoginStep;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.AiStorageAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.component.AuthInfoInputPanel;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.util.AsyncBatchAuthUtil;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDmePanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ModifyDmePanel.class);
    private final JLabel modelDescLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devtype"));
    private final JLabel modelShow = new JLabel();
    private final JLabel ipDescLabel = UiMethod.createLabel((String)ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip"));
    private final JLabel ipShow = new JLabel();
    private final AuthInfoInputPanel authPanel = new AuthInfoInputPanel();
    private final JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"device.adddialog.proxysetting.create.okbtn"), (char)'O');
    private final JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"device.adddialog.proxysetting.create.cancelbtn"), (char)'C');
    private final AiDevNode aiDevNode;

    public ModifyDmePanel(Window parent, AiDevNode aiDevNode) {
        this.aiDevNode = aiDevNode;
        this.initUi();
        this.initData();
        this.bindListener(parent);
    }

    private void initData() {
        this.ipShow.setText(this.aiDevNode.getIp());
        this.modelShow.setText(this.aiDevNode.getProductModel());
        this.authPanel.setUsernameDefault(this.aiDevNode.getLoginUser().getUserName());
        this.authPanel.setDefaultPort(String.valueOf(this.aiDevNode.getPort()));
    }

    private void bindListener(Window parent) {
        this.okBtn.addActionListener(e -> this.doDmeAuth(parent));
        this.cancelBtn.addActionListener(e -> {
            log.info("user cancel modify option for node :{}", (Object)this.aiDevNode.getIp());
            parent.dispose();
        });
    }

    private void doDmeAuth(Window parent) {
        log.info("confirm login :{} node dme", (Object)this.aiDevNode.getIp());
        try {
            this.authPanel.validInput();
            AiDevNode modifyNode = this.buildModifyNode();
            log.info("start modify :{} dme", (Object)this.aiDevNode.getIp());
            if (!AsyncBatchAuthUtil.authDme(parent, modifyNode)) {
                log.info("auth dme failed");
                return;
            }
            log.info("node:{} dme login success", (Object)this.aiDevNode.getIp());
            this.showA800Auth(parent, modifyNode);
            this.updateNodeProperties(modifyNode);
            LogUtils.addOperaLog("operalog.name.moddevice", (DevNode)this.aiDevNode);
            parent.dispose();
        }
        catch (ToolException e) {
            TaskResult taskResult = new TaskResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
            LogUtils.addOperaLog("operalog.name.moddevice", (DevNode)this.aiDevNode, taskResult, e.getErrorId());
            log.error("node modify login failed :{}", (Object)this.aiDevNode.getIp(), (Object)e);
            DialogUtils.showInfoDialog((Window)parent, (String)e.getErrorLocaleDescription());
        }
    }

    @NotNull
    private AiDevNode buildModifyNode() {
        AiDevNode modifyNode = new AiDevNode();
        modifyNode.setIp(this.aiDevNode.getIp());
        modifyNode.setPort(this.aiDevNode.getPort());
        modifyNode.setLoginUser(this.authPanel.buildLoginInfo());
        return modifyNode;
    }

    private void showA800Auth(Window parent, AiDevNode modifyNode) throws ToolException {
        log.info("show zone and om login ui for node:{}", (Object)this.aiDevNode.getIp());
        AiStorageAddDialog a800AuthDialog = new AiStorageAddDialog(parent, ModifyDmePanel.getStepList(this.aiDevNode));
        a800AuthDialog.setZoneData(modifyNode.getA800Nodes());
        a800AuthDialog.setOmData(modifyNode.getOmNodes());
        a800AuthDialog.setVisible(true);
        log.info("zone and om login ui for node:{} closed", (Object)this.aiDevNode.getIp());
    }

    @NotNull
    private static List<LoginStep> getStepList(AiDevNode aiDevNode) throws ToolException {
        if (DeviceAddUtil.isSceneSupportA800Only()) {
            if (!aiDevNode.getA800Nodes().isEmpty()) {
                return Collections.singletonList(LoginStep.ZONE_LOGIN);
            }
            throw new ToolException("no.a800.found");
        }
        if (DeviceAddUtil.isSceneSupportOmOnly()) {
            if (!aiDevNode.getOmNodes().isEmpty()) {
                return Collections.singletonList(LoginStep.OM_LOGIN);
            }
            throw new ToolException("no.om.found");
        }
        return Arrays.asList(LoginStep.ZONE_LOGIN, LoginStep.OM_LOGIN);
    }

    private void updateNodeProperties(AiDevNode modifyNode) throws ToolException {
        this.aiDevNode.setLoginUser(modifyNode.getLoginUser());
        this.aiDevNode.setA800Nodes(modifyNode.getA800Nodes());
        this.aiDevNode.setOmNodes(modifyNode.getOmNodes());
        DefaultNodeProviderImpl.getInstance().modifyDevice((DevNode)this.aiDevNode);
    }

    private void initUi() {
        JComponent centerBox = this.buildCenterCom();
        Box bottom = UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.cancelBtn});
        this.setLayout(new FlowLayout(0));
        this.add(UCD.buildVerticalBox(null, (Component[])new Component[]{centerBox, Box.createHorizontalStrut(0), bottom}));
    }

    @NotNull
    private JComponent buildCenterCom() {
        Dimension fieldSize = new Dimension(150, 21);
        this.authPanel.setFieldSize(fieldSize);
        this.authPanel.setLabelSize(Arrays.asList(this.modelDescLabel, this.ipDescLabel));
        Box modelBox = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.modelDescLabel, this.modelShow});
        Box ipBox = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.ipDescLabel, this.ipShow});
        return UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), modelBox, ipBox, this.authPanel, Box.createVerticalStrut(0)})});
    }

    public JButton getDefaultButton() {
        return this.okBtn;
    }
}

