/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener;

import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.service.implement.MgrIpCheckService;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.FcvSelectControllerEnclosureJDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.HyperMetroDevTipsDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.ScenePreparedMainJDialog;
import com.huawei.ism.tool.devicemanager.ui.former.GetTooolSupportList;
import com.huawei.ism.tool.devicemanager.ui.former.SceneProductParser;
import com.huawei.ism.tool.devicemanager.ui.former.XmlFormer;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.SceneDeviceSelectVerifyUtil;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.devicemanager.utils.DevCfgUtil;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.devicemanager.utils.SceneParser;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ISceneService;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataConstant;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.framework.pubservice.service.ISceneCfmCheckService;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.json.JSONObject;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import utils.Products;

public class ConfirmAction
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ConfirmAction.class);
    private static final String NODE_DISABLE_STEP_LIST = "disabledStepList";
    private static final String UPGRADE_STRING = "Upgrade";
    private static ScenePreparedMainJDialog dialog = null;
    private static final String UPGEVAL_DETAIL_FILE_PATH = "//tools//upgradeEvaluation//sceneEvalDetails.xml";
    private static final String UPGEVAL_PROCESS_RESULT_KEY = "processResult";
    private static final String UPGEVAL_LAST_PROCESS_TIME_KEY = "endTime";
    private static final String UPGEVAL_DEVICE_KEY = "device";
    private static final String UPGEVAL_DEVICE_SN_IP_KEY = "SN_IP";
    private static final String UPGEVAL_DEVICE_RESULT_KEY = "Result";
    private static final String UPGEVAL_RESULT_PASS = "Passed";
    private static final String UPGEVAL_RESULT_FAILED = "Failed";
    private static final int TOOL_VALID_PROCESS_DAY_DISTANCE = 1;
    private static final int NUM_OF_SECONDS_ONE_DAY = 86400000;
    private static final String[] PREPARE_CMD = new String[]{"show controller general", "show host general", "show initiator initiator_type=iSCSI", "show ib_initiator general", "show initiator initiator_type=FC"};
    private static final String EXP_SCENE_LIMIT = "app.scene.limit.login.socket.ssh";
    private static final String PATCH_SCENE_LIMIT = "app.scene.limit.login.socket";
    private Map<String, String> limitMessage = new HashMap<String, String>();
    private Map<String, String> cmdKeyMap = new HashMap<String, String>();

    public ConfirmAction(ScenePreparedMainJDialog scenePreparedMainJDialog) {
        dialog = scenePreparedMainJDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.cmdKeyMap.put("show controller general", "_controllerInfo");
            this.cmdKeyMap.put("show ib_initiator general", "_ibInitiatorInfo");
            this.cmdKeyMap.put("show initiator initiator_type=iSCSI", "_iSCSIInitiatorInfo");
            this.cmdKeyMap.put("show initiator initiator_type=FC", "_FCInitiatorInfo");
            this.cmdKeyMap.put("show host general", "_HostInfo");
            this.doConfirm();
        }
        catch (Exception e1) {
            LOGGER.error("sceneXml prepared failed", (Throwable)e1);
        }
    }

    public static List<String> getUnSupportIps(List<DevNode> devs) {
        return devs.stream().filter(devNode -> Objects.nonNull(devNode.getPriKey())).map(DevNode::getIp).collect(Collectors.toList());
    }

    public static HyperMetroDevTipsDialog openHyperMetroDevTipsDialog(Map<DevNode, String> data, Map<DevNode, List<List<String>>> data4Nas) {
        HyperMetroDevTipsDialog multiInfoDialog = null;
        try {
            multiInfoDialog = new HyperMetroDevTipsDialog(dialog, data, data4Nas);
            multiInfoDialog.setVisible(true);
        }
        catch (Exception e) {
            LOGGER.error("Show HyperMetroDevTipsDialog error", (Throwable)e);
        }
        return multiInfoDialog;
    }

    private boolean needSelectSence() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (sceneJson == null) {
            return false;
        }
        String mainScene = sceneJson.get("mainScene").toString();
        return !"Routine Maintain".equalsIgnoreCase(mainScene) && !"Opening Delivery".equalsIgnoreCase(mainScene);
    }

    private List<DevNode> checkFcvSelected(List<DevNode> devs) {
        List<DevNode> fcvDevNodes;
        ArrayList<DevNode> checkedDevs = new ArrayList<DevNode>();
        ArrayList<DevNode> allFcvDevNodes = new ArrayList<DevNode>();
        for (DevNode devNode : devs) {
            if (devNode.isComputeStorage() && devNode.getComputeStorageDevNode() != null) {
                allFcvDevNodes.add(devNode);
                continue;
            }
            checkedDevs.add(devNode);
        }
        if (!allFcvDevNodes.isEmpty() && (fcvDevNodes = ConfirmAction.getFcvManagedDevNodes(checkedDevs, allFcvDevNodes)).isEmpty()) {
            return fcvDevNodes;
        }
        return checkedDevs;
    }

    private static List<DevNode> getFcvManagedDevNodes(List<DevNode> checkedDevs, List<DevNode> allFcvDevNodes) {
        List<DevNode> allFcvStorageDevList = allFcvDevNodes.stream().flatMap(devNode -> devNode.getComputeStorageDevNode().getStorageNodesInfo().stream().map(stringStringMap -> EntityUtils.convertMapToOldDevNode((DevNode)devNode, (Map)stringStringMap))).collect(Collectors.toList());
        FcvSelectControllerEnclosureJDialog fcvDialog = new FcvSelectControllerEnclosureJDialog((Window)dialog, allFcvStorageDevList);
        fcvDialog.setHelpActionCallBack(new FcvSelectControllerEnclosureJDialog.OpenHelpCallBack(fcvDialog));
        fcvDialog.setVisible(true);
        if (fcvDialog.getStorageDevNodeList().isEmpty()) {
            return fcvDialog.getStorageDevNodeList();
        }
        checkedDevs.addAll(fcvDialog.getStorageDevNodeList());
        return checkedDevs;
    }

    private void doConfirm() {
        boolean limitPatch;
        List<String> ips;
        boolean condtionSVP;
        List<DevNode> devs = this.getSelectedDevNode();
        List<DevNode> relatedDevs = dialog.getRelatedDevNode();
        ArrayList<DevNode> needDevs = new ArrayList<DevNode>();
        if (this.doSomeJudgement(devs, needDevs)) {
            return;
        }
        if (this.needSelectSence() && (devs = this.checkFcvSelected(devs)).isEmpty()) {
            return;
        }
        boolean bl = condtionSVP = !LocalHostUtil.isRunInSvp() && DeviceSceneContext.getInstance().isSingleDev();
        if (this.judgeCondtionSVP(devs, condtionSVP)) {
            return;
        }
        if (Collections.singletonList("ReplacingCertificates").equals(DeviceSceneContext.getInstance().getToolList()) && !CollectionUtil.isEmpty(ips = ConfirmAction.getUnSupportIps(devs))) {
            DialogUtils.showInfoDialog((JDialog)dialog, (String)ResourceUtil.getStringWithParams((String)"scene.remind.select.limit.replace.cert", (Object[])new Object[]{String.join((CharSequence)",", ips)}));
            return;
        }
        if (ConfirmAction.isNeedTip(devs)) {
            DialogUtils.showInfoDialog((JDialog)dialog, (String)ResourceUtil.getString((String)"scene.remind.select.not.cur.svp.dev"));
            return;
        }
        boolean limitExpansion = this.isExpansion() && this.condtionLoginExp(devs);
        boolean bl2 = limitPatch = this.isHotPatch() && this.condtionLoginPatch(devs);
        if (this.limitEAndP(limitExpansion, limitPatch)) {
            return;
        }
        HashMap<DevNode, String> data = new HashMap();
        Map<DevNode, List<List<String>>> data4Nas = new HashMap<DevNode, List<List<String>>>();
        if (DeviceSceneContext.getInstance().isCurrentSceneSupportsHyperMetro()) {
            data = ConfirmAction.needOpenHyperMetroDevTipsDialog(devs, relatedDevs);
        }
        if (DeviceSceneContext.getInstance().isCurrentSceneSupportsNas()) {
            data4Nas = ConfirmAction.needOpenDoradoNasDevTipsDialog(devs, relatedDevs);
        }
        if (this.judgeDataIsEmpty(data, data4Nas)) {
            return;
        }
        this.createXML(devs, relatedDevs);
    }

    private static boolean isNeedTip(List<DevNode> devs) {
        return DeviceSceneContext.getInstance().isSingleDev() && null != DeviceSceneContext.getInstance().getCurSvpNode() && !DeviceSceneContext.getInstance().getCurSvpNode().getDeviceSerialNumber().equals(devs.get(0).getDeviceSerialNumber());
    }

    private boolean doSomeJudgement(List<DevNode> devs, List<DevNode> needDevs) {
        if (this.judgeDevsIsEmpty(devs)) {
            return true;
        }
        if (DeviceAddUtil.overMaxSelectDev(devs)) {
            DialogUtils.showInfoDialog((JDialog)dialog, (String)ResourceUtil.getStringWithParams((String)"scene.max.select.dev.over", (Object[])new Object[]{DeviceAddUtil.getCurrentMaxConfig()}));
            return true;
        }
        if (this.judgeUpgarade(devs)) {
            return true;
        }
        this.getNoDebugPwdDevs(devs, needDevs);
        if (this.judgeNeedDevsIsEmpty(needDevs)) {
            return true;
        }
        VerifyResult verify = SceneDeviceSelectVerifyUtil.verify(devs, dialog);
        if (!verify.isVerifySuccess()) {
            if (!StringUtils.isNULLStr((String)verify.getMsg())) {
                DialogUtils.showInfoDialog((JDialog)dialog, (String)verify.getMsg());
            }
            return true;
        }
        return false;
    }

    private boolean judgeDataIsEmpty(Map<DevNode, String> data, Map<DevNode, List<List<String>>> data4Nas) {
        HyperMetroDevTipsDialog hydevTipsdialog;
        if (!(data.isEmpty() && data4Nas.isEmpty() || null == (hydevTipsdialog = ConfirmAction.openHyperMetroDevTipsDialog(data, data4Nas)) || hydevTipsdialog.isOkPerformed())) {
            dialog.showAddDevLink();
            return true;
        }
        return false;
    }

    private void createXML(List<DevNode> devs, List<DevNode> relatedDevs) {
        XmlFormer xmlFormer = new XmlFormer();
        List<Map<String, String>> listMap = xmlFormer.injectDeviceData(devs);
        HashMap<String, String> disableMap = new HashMap<String, String>();
        TaskResult result = SceneXmlData.getInstance().writeDevData2File(devs, listMap);
        TaskResult relatedResult = new TaskResult();
        relatedResult = this.getTaskResult(relatedDevs, xmlFormer, relatedResult);
        if (!this.checkMgrIpOnExpansion()) {
            return;
        }
        ISceneService getSceneContextService = (ISceneService)PublicServiceManage.getInstance().getService(ISceneService.class);
        this.initSceneStep(devs, disableMap);
        getSceneContextService.setSuccessDevCount(devs.size());
        this.judgeResult(devs, result, relatedResult);
    }

    private boolean judgeCondtionSVP(List<DevNode> devs, boolean condtionSVP) {
        if (condtionSVP && DeviceTypeUtil.hasSVPModule((com.huawei.ism.tool.obase.entity.DevNode)EntityUtils.toOldDev((DevNode)devs.get(0)))) {
            DialogUtils.showInfoDialog((JDialog)dialog, (String)ResourceUtil.getString((String)"scene.remind.select.svp.dev.in.single.mode"));
            return true;
        }
        return false;
    }

    private boolean judgeNeedDevsIsEmpty(List<DevNode> needDevs) {
        if (!needDevs.isEmpty()) {
            StringBuilder strBuilder = new StringBuilder();
            for (DevNode devNode : needDevs) {
                strBuilder.append(devNode.getIp()).append(", ");
            }
            String ipStr = strBuilder.toString();
            ipStr = ipStr.substring(0, ipStr.lastIndexOf(44));
            DialogUtils.showInfoDialog((JDialog)dialog, (String)ResourceUtil.getStringWithParams((String)"scene.remind.debugpsw.null", (Object[])new Object[]{ipStr}));
            return true;
        }
        return false;
    }

    private boolean judgeUpgarade(List<DevNode> devs) {
        if (this.isUpgrade() && this.hasNoUnitDev(devs)) {
            DialogUtils.showInfoDialog((JDialog)dialog, (String)ResourceUtil.getString((String)"scene.remind.selectdevice.tips"));
            return true;
        }
        return false;
    }

    private boolean judgeDevsIsEmpty(List<DevNode> devs) {
        if (devs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)dialog, (String)ResourceUtil.getString((String)"scene.remind.selectnodevice"));
            return true;
        }
        return false;
    }

    private boolean limitEAndP(boolean limitExpansion, boolean limitPatch) {
        if (limitExpansion) {
            DialogUtils.showBatchInfoDialog((Window)dialog, (String)ResourceUtil.getString((String)"scene.remind.select.limit.subscene"), this.limitMessage);
            return true;
        }
        if (limitPatch) {
            DialogUtils.showBatchInfoDialog((Window)dialog, (String)ResourceUtil.getString((String)"scene.remind.select.limit.subscene"), this.limitMessage);
            return true;
        }
        return false;
    }

    private TaskResult getTaskResult(List<DevNode> relatedDevs, XmlFormer xmlFormer, TaskResult relatedResult) {
        if (relatedDevs.isEmpty()) {
            relatedResult.setResult(TaskResult.Result.SUCCESS);
            return relatedResult;
        }
        List<Map<String, String>> relatedListMap = xmlFormer.injectDeviceData(relatedDevs);
        return SceneXmlData.getInstance().writeDevData2File(relatedDevs, relatedListMap, new File(SceneUtils.getSceneFilePath((String)"sceneRelatedDeviceList.xml")));
    }

    private void judgeResult(List<DevNode> devs, TaskResult result, TaskResult relatedResult) {
        if (result.getResult() == TaskResult.Result.SUCCESS && relatedResult.getResult() == TaskResult.Result.SUCCESS) {
            DefaultNodeProviderImpl.getInstance().removeNodeObserver(dialog.getClass());
            DeviceSceneContext.getInstance().fireToolStopped();
            DeviceSceneContext.getInstance().getScenePreparedMainJDialog().dispose();
            LoggerFactory.getLogger(this.getClass()).info("scene prepared ok.");
            SceneDataExchange.getInstance().saveKV("prepareDevCountResult", "devCount:" + devs.size());
        } else {
            LOGGER.error("scene prepared failed");
            DialogUtils.showInfoDialog((JDialog)dialog, (String)ResourceUtil.getString((String)"scene.remind.writeData.failed"));
        }
    }

    public boolean checkMgrIpOnExpansion() {
        HashMap<String, ScenePreparedMainJDialog> context = new HashMap<String, ScenePreparedMainJDialog>();
        context.put("parentWindow", dialog);
        String subScene = GetTooolSupportList.getNeededSceneID();
        List<ISceneCfmCheckService> checkList = DeviceSceneContext.getInstance().getSceneCheckServices(subScene);
        if (checkList == null || checkList.isEmpty()) {
            return true;
        }
        for (ISceneCfmCheckService iSceneCfmCheckService : checkList) {
            if (iSceneCfmCheckService.check((Window)dialog, context)) continue;
            return false;
        }
        return true;
    }

    private boolean condtionLoginExp(List<DevNode> devs) {
        boolean result = false;
        this.limitMessage.clear();
        if (!devs.isEmpty()) {
            for (DevNode dev : devs) {
                if (dev.getSocks5Proxy() == null && dev.getSshForwardList().isEmpty()) continue;
                result = true;
                this.limitMessage.put(dev.getIp(), ResourceUtil.getString((String)"scene.remind.select.limit.exp.tips"));
            }
        }
        return result;
    }

    private boolean condtionLoginPatch(List<DevNode> devs) {
        boolean result = false;
        this.limitMessage.clear();
        if (!devs.isEmpty()) {
            for (DevNode dev : devs) {
                if (dev.getSocks5Proxy() == null) continue;
                result = true;
                this.limitMessage.put(dev.getIp(), ResourceUtil.getString((String)"scene.remind.select.limit.patch.tips"));
            }
        }
        return result;
    }

    private boolean isHotPatch() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        String subScene = "";
        String patchLimitScene = ApplicationContext.getInstance().getAppConfigNoExcept(PATCH_SCENE_LIMIT);
        if (null == sceneJson) {
            LOGGER.error("Sence para(JSONObject) is null.");
        } else {
            subScene = sceneJson.get("subScene").toString();
        }
        if (patchLimitScene != null) {
            return patchLimitScene.contains(subScene);
        }
        return false;
    }

    private boolean isExpansion() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        String subScene = "";
        String expLimitScene = ApplicationContext.getInstance().getAppConfigNoExcept(EXP_SCENE_LIMIT);
        if (null == sceneJson) {
            LOGGER.error("Sence para(JSONObject) is null.");
        } else {
            subScene = sceneJson.get("subScene").toString();
        }
        if (expLimitScene != null) {
            return expLimitScene.contains(subScene);
        }
        return false;
    }

    public static Map<DevNode, List<List<String>>> needOpenDoradoNasDevTipsDialog(List<DevNode> devs, List<DevNode> needDevs) {
        HashMap<DevNode, List<List<String>>> data = new HashMap<DevNode, List<List<String>>>();
        ArrayList<DevNode> allDevs = new ArrayList<DevNode>();
        if (needDevs != null) {
            allDevs.addAll(needDevs);
        }
        allDevs.addAll(devs);
        List<String> allSns = ConfirmAction.initAllSn(allDevs);
        for (DevNode dev : devs) {
            if (!dev.getDeviceType().toString().contains("Dorado") || dev.getProductVersion().compareTo("V300R002C10") < 0) continue;
            ArrayList snipLists = new ArrayList();
            if (dev.getRelatedSNIPs() != null) {
                for (Map.Entry entry : dev.getRelatedSNIPs().entrySet()) {
                    ArrayList<Object> snipList = new ArrayList<Object>();
                    if (allSns.contains(entry.getKey())) continue;
                    snipList.add(entry.getValue());
                    if (dev.getDeviceType().toString().equalsIgnoreCase("Dorado NAS")) {
                        snipList.add("Dorado");
                    } else {
                        snipList.add("Dorado NAS");
                    }
                    snipList.add(entry.getKey());
                    snipLists.add(snipList);
                }
            }
            if (snipLists.isEmpty()) continue;
            data.put(dev, snipLists);
        }
        return data;
    }

    public static Map<DevNode, String> needOpenHyperMetroDevTipsDialog(List<DevNode> devs, List<DevNode> needDevs) {
        HashMap<DevNode, String> data = new HashMap<DevNode, String>();
        ArrayList<DevNode> allDevs = new ArrayList<DevNode>();
        allDevs.addAll(needDevs);
        allDevs.addAll(devs);
        List<String> allSns = ConfirmAction.initAllSn(allDevs);
        for (DevNode dev : devs) {
            if (!dev.isHyperMetro()) continue;
            StringBuffer snStr = new StringBuffer();
            for (String remoteSn : dev.getRemoteSNs()) {
                if (allSns.contains(remoteSn)) continue;
                snStr.append(remoteSn).append(",");
            }
            if (StringUtils.isNULLStr((String)snStr.toString())) continue;
            data.put(dev, snStr.toString().substring(0, snStr.length() - 1));
        }
        return data;
    }

    private static List<String> initAllSn(List<DevNode> allDevs) {
        ArrayList<String> sns = new ArrayList<String>();
        for (DevNode dev : allDevs) {
            sns.add(dev.getDeviceSerialNumber());
        }
        return sns;
    }

    private void initSceneStep(List<DevNode> devs, Map<String, String> disableMap) {
        ArrayList<Map<String, String>> sceneData = new ArrayList<Map<String, String>>();
        String subScene = GetTooolSupportList.getNeededSceneID();
        String svpVersion = LocalHostUtil.getSvpVersion();
        boolean isUniondevice = SceneParser.isIsuniondevice();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("subScene:" + subScene + " svpVersion:" + svpVersion + " ,isUniondevice:" + isUniondevice);
        }
        try {
            String disableAction = null;
            if (isUniondevice) {
                disableAction = this.dailyChecksDisableAction(devs);
                if (null == disableAction) {
                    return;
                }
                this.disableDeal(disableMap, sceneData, disableAction);
            }
            if (!UPGRADE_STRING.equals(subScene)) {
                return;
            }
            String productVersion = null;
            for (DevNode devNode : devs) {
                String devType = devNode.getDeviceType().toString();
                productVersion = devNode.getProductVersion();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("devType:" + devType + " productVersion:" + productVersion);
                }
                if ((!devType.contains("Dorado") || productVersion.compareTo("V300R001") < 0) && productVersion.compareTo("V300R006C10") < 0) continue;
                disableAction = "RestartControllers";
                break;
            }
            if (!StringUtils.isNULLStr((String)svpVersion) && !StringUtils.isNULLStr(productVersion) && svpVersion.compareTo(productVersion) > 0) {
                disableAction = StringUtils.isNULLStr((String)disableAction) ? "" : disableAction + ",";
                disableAction = disableAction + "Upadate";
            }
            if (this.ifUpgEvalStepDisable(devs)) {
                disableAction = StringUtils.isNULLStr((String)disableAction) ? "" : disableAction + ",";
                disableAction = disableAction + "upgradeEvaluation";
            }
            this.disableDeal(disableMap, sceneData, disableAction);
        }
        catch (Exception e) {
            LOGGER.error("init step error", (Throwable)e);
        }
    }

    private String dailyChecksDisableAction(List<DevNode> devs) {
        String disableAction = null;
        List<String> toolList = DeviceSceneContext.getInstance().getToolList();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("get scene tool list:" + toolList);
        }
        Map<String, Map<String, ArrayList<String>>> toolSupportMap = SceneProductParser.getSceneToolSupportMap();
        for (String stepTool : toolList) {
            Map<String, ArrayList<String>> toolSupport = toolSupportMap.get(stepTool);
            boolean needDisable = true;
            for (DevNode devNode : devs) {
                String devType = devNode.getDeviceType().toString();
                String productVersion = devNode.getProductVersion();
                boolean isSupport = false;
                ArrayList<String> devTypeSuppoutList = toolSupport.get(devType);
                isSupport = this.isSupportDevice(productVersion, devTypeSuppoutList);
                if (!isSupport) continue;
                needDisable = false;
                break;
            }
            if (!needDisable) continue;
            char[] cs = stepTool.toCharArray();
            cs[0] = (char)(cs[0] - 32);
            disableAction = StringUtils.isNULLStr(disableAction) ? "" : disableAction + ",";
            disableAction = disableAction + String.valueOf(cs);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("the scene step need disable:" + stepTool);
        }
        return disableAction;
    }

    private boolean isSupportDevice(String productVersion, ArrayList<String> devTypeSuppoutList) {
        boolean isSupport = false;
        if (null != devTypeSuppoutList) {
            for (String string : devTypeSuppoutList) {
                if (!Products.contains((String)productVersion, (String)string)) continue;
                isSupport = true;
                break;
            }
        }
        return isSupport;
    }

    private void disableDeal(Map<String, String> disableMap, List<Map<String, String>> sceneData, String disableAction) throws ToolException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("disableAction:" + disableAction);
        }
        if (!StringUtils.isNULLStr((String)disableAction)) {
            disableMap.put(NODE_DISABLE_STEP_LIST, disableAction);
            sceneData.add(disableMap);
        }
        if (!sceneData.isEmpty()) {
            SceneEnvironmentImpl.getInstance().initSceneEnvir();
            SceneEnvironmentImpl.getInstance().finishedSceneTask(sceneData);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("generate file result:" + new File(SceneDataConstant.SCENE_DATA_XML_TB_PATH).exists());
            }
        }
    }

    private void getNoDebugPwdDevs(List<DevNode> devs, List<DevNode> needDevs) {
        for (DevNode devNode : devs) {
            if (!DevCfgUtil.isNeedDebusPsw(devNode) || !StringUtils.isNULLStr((String)devNode.getDeveloperPwd().trim())) continue;
            needDevs.add(devNode);
        }
    }

    private List<DevNode> getSelectedDevNode() {
        ArrayList<DevNode> selectedDevs = new ArrayList<DevNode>();
        DevNode devNode = null;
        int[] rowIndexs = dialog.getMainLayout().getDeviceTable().getSelectedRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            return selectedDevs;
        }
        for (int index : rowIndexs) {
            index = dialog.getMainLayout().getDeviceTable().convertRowIndexToModel(index);
            TableRow row = dialog.getMainLayout().getDeviceTableModel().getRow(index);
            devNode = (DevNode)row.getUserObject();
            selectedDevs.add(devNode);
        }
        return selectedDevs;
    }

    private boolean isUpgrade() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        String mainScene = "";
        if (null == sceneJson) {
            LOGGER.error("Sence para(JSONObject) is null.");
        } else {
            mainScene = sceneJson.get("mainScene").toString();
        }
        return UPGRADE_STRING.equals(mainScene);
    }

    private boolean hasNoUnitDev(List<DevNode> devs) {
        boolean result = false;
        if (!devs.isEmpty()) {
            result = this.hasNoUnitDevType(devs);
            if (result) {
                return result;
            }
            result = this.hasNoUnitProVersion(devs);
        }
        return result;
    }

    private boolean hasNoUnitProVersion(List<DevNode> devs) {
        HashSet<String> set = new HashSet<String>();
        for (DevNode devNode : devs) {
            set.add(devNode.getProductVersion());
        }
        return 1 != set.size();
    }

    private boolean hasNoUnitDevType(List<DevNode> devs) {
        HashSet<String> set = new HashSet<String>();
        for (DevNode devNode : devs) {
            set.add(devNode.getDeviceType().toString());
        }
        return 1 != set.size();
    }

    private boolean ifUpgEvalStepDisable(List<DevNode> devs) {
        try {
            int days;
            Date dateNew;
            String workPath = ApplicationContext.getInstance().getWorkPath();
            String evalFilePath = workPath + UPGEVAL_DETAIL_FILE_PATH;
            File evalFile = new File(evalFilePath);
            if (!evalFile.exists()) {
                LOGGER.info("[UpgradeScene]: sceneEvalDetails.xml not exist!");
                return false;
            }
            ArrayList<String> addedDevSNIPList = new ArrayList<String>();
            ArrayList<String> addedDevSNList = new ArrayList<String>();
            this.traverseDevNode(devs, addedDevSNIPList, addedDevSNList);
            Document document = this.dealXML(evalFilePath);
            NodeList processNodeList = document.getElementsByTagName(UPGEVAL_PROCESS_RESULT_KEY);
            NodeList endTimeNodeList = document.getElementsByTagName(UPGEVAL_LAST_PROCESS_TIME_KEY);
            NodeList deviceNodeList = document.getElementsByTagName(UPGEVAL_DEVICE_KEY);
            if (processNodeList.getLength() != 1 || endTimeNodeList.getLength() != 1 || deviceNodeList.getLength() == 0) {
                return false;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Node endTimeNode = endTimeNodeList.item(0);
            String endTime = endTimeNode.getTextContent();
            Date dateOld = sdf.parse(endTime);
            if (this.upgradeSceneLog(dateOld, dateNew = new Date(), days = (int)(dateNew.getTime() - dateOld.getTime()) / 86400000)) {
                return false;
            }
            this.getDeviceInfo(addedDevSNIPList, addedDevSNList, deviceNodeList);
            if (addedDevSNIPList.isEmpty() || addedDevSNList.isEmpty()) {
                LOGGER.info("[UpgradeScene]: devices meet requirements");
                return true;
            }
            LOGGER.info("[UpgradeScene]: devices do not meet requirements");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("[UpgradeScene]: process error:" + e);
            return false;
        }
    }

    private boolean upgradeSceneLog(Date dateOld, Date dateNew, int days) {
        LOGGER.info("[UpgradeScene]: date range is:{}", (Object)days);
        if (dateNew.getTime() < dateOld.getTime() || days >= 1) {
            LOGGER.info("[UpgradeScene]: date does not meet requirements");
            return true;
        }
        return false;
    }

    private void traverseDevNode(List<DevNode> devs, List<String> addedDevSNIPList, List<String> addedDevSNList) {
        for (DevNode dev : devs) {
            String devSN = dev.getDeviceSerialNumber();
            String devIP = dev.getIp();
            addedDevSNIPList.add(devSN + "_" + devIP);
            addedDevSNList.add(devSN);
        }
    }

    private Document dealXML(String evalFilePath) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.newDocumentBuilder().parse(evalFilePath);
    }

    private void getDeviceInfo(List<String> addedDevSNIPList, List<String> addedDevSNList, NodeList deviceNodeList) {
        for (int index = 0; index < deviceNodeList.getLength(); ++index) {
            Node devNode = deviceNodeList.item(index);
            NamedNodeMap attrs = devNode.getAttributes();
            String devSNIPConfig = null;
            String devEvalResult = null;
            for (int j = 0; j < attrs.getLength(); ++j) {
                if (attrs.item(j).getNodeName().equals(UPGEVAL_DEVICE_SN_IP_KEY)) {
                    devSNIPConfig = attrs.item(j).getNodeValue();
                    continue;
                }
                if (!attrs.item(j).getNodeName().equals(UPGEVAL_DEVICE_RESULT_KEY)) continue;
                devEvalResult = attrs.item(j).getNodeValue();
            }
            if (!UPGEVAL_RESULT_PASS.equals(devEvalResult)) continue;
            if (devSNIPConfig == null) {
                return;
            }
            String devSNInConfig = devSNIPConfig.split("_")[0];
            if (LocalHostUtil.isRunInSvp() && addedDevSNList.contains(devSNInConfig)) {
                addedDevSNList.remove(devSNInConfig);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("[UpgradeScene]: In SVP: Device is passed, need delete " + devSNIPConfig);
                continue;
            }
            if (!addedDevSNIPList.contains(devSNIPConfig)) continue;
            addedDevSNIPList.remove(devSNIPConfig);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("[UpgradeScene]: device is passed, need delete " + devSNIPConfig);
        }
    }

    static {
        DeviceSceneContext.getInstance().addSceneDevConfirmService("Expansion Controller", MgrIpCheckService.getInstance());
    }
}

