/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener.verify;

import com.huawei.ism.tool.devicemanager.ui.listener.verify.A800SceneJudge;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmAuthVerifier
extends A800SceneJudge {
    private static final Logger log = LoggerFactory.getLogger(OmAuthVerifier.class);

    @Override
    public VerifyResult verify(JDialog parent, String scene, List<DevNode> selectedNodes) {
        log.info("start verify nodes:{} at scene: {}", (Object)selectedNodes.stream().map(DevNode::getIp).collect(Collectors.joining(",")), (Object)scene);
        VerifyResult verifyResult = new VerifyResult();
        if (DeviceAddUtil.isSceneSupportA800Only()) {
            return verifyResult;
        }
        if (OmAuthVerifier.hasOmNotAuth(selectedNodes)) {
            verifyResult.setVerifySuccess(false);
            verifyResult.setMsg(ResourceUtil.getString((String)"has.no.auth.oms"));
        }
        return verifyResult;
    }

    private static boolean hasOmNotAuth(List<DevNode> selectedNodes) {
        return selectedNodes.stream().filter(node -> ItDeviceType.A800_OM.equals((Object)node.getItDeviceType())).anyMatch(node -> node.getLoginUser() == null);
    }
}

