/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.mainframe;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.AddDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.DelDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceUpdateAction;
import com.huawei.ism.tool.devicemanager.ui.action.DownLoadAction;
import com.huawei.ism.tool.devicemanager.ui.action.ImportDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.action.ModifyDeviceAction;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.ui.component.AbstractBasePanel;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class DeviceManagementPanel
extends AbstractBasePanel
implements INodeObserver {
    public static final int SNS_LIST_MAX_LENTH = 3;
    private static final long serialVersionUID = 1L;
    private AddDeviceAction addDeviceAction;
    private ModifyDeviceAction modifyAction;
    private DelDeviceAction deleDeviceAction;
    private ImportDeviceAction importDeviceAction;
    private DownLoadAction downLoadAction;
    private DeviceUpdateAction deviceUpdateAction;
    private List<DevNode> deviceList = new ArrayList<DevNode>();
    private IsmTable deviceTable;
    private JFrame parentFrame = null;
    private DefaultTableModel tableModel;
    private List<ToolAction> rightMouseActions = new ArrayList<ToolAction>();

    public DeviceManagementPanel(JFrame parentFrame) {
        super(false);
        this.parentFrame = parentFrame;
        this.addFunctionBtn();
        this.initTableModelData();
    }

    private void addFunctionBtn() {
        this.addDeviceAction = new AddDeviceAction(this);
        this.modifyAction = new ModifyDeviceAction(this);
        this.deleDeviceAction = new DelDeviceAction(this);
        this.importDeviceAction = new ImportDeviceAction(this);
        this.deviceUpdateAction = new DeviceUpdateAction(this);
        this.downLoadAction = new DownLoadAction(this.getParentJFrame());
        this.addDeviceAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.add"));
        this.modifyAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.modify"));
        this.deleDeviceAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.dele"));
        this.importDeviceAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.import"));
        this.deviceUpdateAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.update"));
        this.downLoadAction.putValue("Name", ResourceUtil.getString((String)"devicemanager.layout.device.import.downloadtemplate"));
        this.downLoadAction.putValue("isToolHyperLinkLabel", "true");
        this.addDeviceAction.putValue("Icon", ResourceUtil.getImage((String)"device_add.png"));
        this.modifyAction.putValue("Icon", ResourceUtil.getImage((String)"device_modify.png"));
        this.deleDeviceAction.putValue("Icon", ResourceUtil.getImage((String)"device_remove.png"));
        this.importDeviceAction.putValue("Icon", ResourceUtil.getImage((String)"device_import.png"));
        this.downLoadAction.putValue("Icon", ResourceUtil.getImage((String)"device_down_template.png"));
        this.deviceUpdateAction.putValue("Icon", ResourceUtil.getImage((String)"device_update.png"));
        this.setRolloverButton(false);
        this.setButtonPanelBackground(Color.WHITE);
        this.addButton(new ToolAction[]{this.addDeviceAction, this.modifyAction, this.deleDeviceAction, this.deviceUpdateAction, this.importDeviceAction, this.downLoadAction});
        this.rightMouseActions.add(this.modifyAction);
        this.rightMouseActions.add(this.deleDeviceAction);
    }

    protected JComponent getTopComponent() {
        String[] tableHeader = this.getTableHeader();
        this.tableModel = new DefaultTableModel(tableHeader, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        ToolUCD.setStandardFont((JComponent[])new JComponent[]{this.deviceTable.getTableHeader()});
        TableColumn firstColumn = this.deviceTable.getColumnModel().getColumn(0);
        firstColumn.setPreferredWidth(200);
        firstColumn.setMaxWidth(280);
        firstColumn.setMinWidth(200);
        return new TableScrollPane(this.deviceTable, true, true, true);
    }

    @NotNull
    protected String[] getTableHeader() {
        return new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devtype"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.productversion"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devtname"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devsn"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devusername"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.sshport")};
    }

    private void initTableModelData() {
        List<DevNode> nodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        for (DevNode node : nodes) {
            this.addDevice(node);
        }
    }

    public Object getSelectObj() {
        int selectRow = this.deviceTable.getSelectedRow();
        if (-1 != selectRow) {
            int modelIndex = this.deviceTable.convertRowIndexToModel(selectRow);
            return this.tableModel.getRow(modelIndex);
        }
        return null;
    }

    protected void initListeners() {
        this.tableModel.fireTableDataChanged();
        this.deviceTable.setUpdateSelectionOnSort(true);
        this.deviceTable.addMouseListener((MouseListener)new TableMouseAdapter());
        ListSelectionModel listModel = this.deviceTable.getSelectionModel();
        listModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                DeviceManagementPanel.this.updateButtons();
            }
        });
    }

    public void updateButtons() {
        List allMarketRows = this.deviceTable.getMarkedRows();
        List btnList = this.getBtnList();
        for (JButton btn : btnList) {
            ToolAction btnAction = (ToolAction)btn.getAction();
            Object rows = this.getSelectObj();
            btnAction.setSelectObject(rows);
            if (this.modifyAction == btnAction) {
                btn.setEnabled(allMarketRows.size() == 1);
            } else {
                btn.setEnabled(btnAction.isAvailable());
            }
            if (btnAction != this.deviceUpdateAction) continue;
            btn.setEnabled(!allMarketRows.isEmpty());
        }
    }

    protected TableRow createRow(DevNode deviceNode) {
        int headerColumns = this.tableModel.getAllColumnCount();
        DefaultTableRow row = new DefaultTableRow(headerColumns, (Object)deviceNode);
        int i = 0;
        if (deviceNode.isHyperMetro()) {
            IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(deviceNode.getDeviceType().toString(), (Icon)ResourceUtil.getImage((String)"hyperMetroIcon.png"));
            String sns = deviceNode.getRemoteSNs().toString();
            sns = sns.substring(sns.indexOf(91) + 1, sns.indexOf(93));
            sns = this.cutTooLongSns2Lines(sns);
            cell.setTips(ResourceUtil.getStringWithParams((String)"devicemanager.layout.hypermetro.device.tips", (Object[])new Object[]{sns}));
            row.setValueAt(i++, (Object)cell);
        } else {
            row.setValueAt(i++, (Object)deviceNode.getDeviceType());
        }
        row.setValueAt(i++, (Object)deviceNode.getProductVersion());
        row.setValueAt(i++, (Object)deviceNode.getDeviceName());
        row.setValueAt(i++, (Object)new IpAddressStrategy(deviceNode.getIp()));
        row.setValueAt(i++, (Object)deviceNode.getDeviceSerialNumber());
        row.setValueAt(i++, (Object)deviceNode.getLoginUser().getUserName());
        row.setValueAt(i++, (Object)deviceNode.getPort());
        return row;
    }

    private String cutTooLongSns2Lines(String sns) {
        String[] snsList = sns.split(",");
        String snsParsed = "";
        for (int poi = 0; poi < snsList.length; ++poi) {
            snsParsed = poi != 0 && poi % 3 == 0 ? snsParsed + snsList[poi] + ",<br/>" : (poi + 1 == snsList.length ? snsParsed + snsList[poi] : snsParsed + snsList[poi] + ",");
        }
        return snsParsed;
    }

    public void addDevice(DevNode device) {
        if (device instanceof AiDevNode) {
            return;
        }
        this.deviceTable.getRowSorter().setSortKeys(new ArrayList());
        List oldRows = this.tableModel.getAllRows();
        this.tableModel.removeRow(oldRows.toArray(new TableRow[oldRows.size()]));
        TableRow row = this.createRow(device);
        oldRows.add(0, row);
        this.tableModel.addRow(oldRows.toArray(new TableRow[oldRows.size()]));
        this.deviceList.add(device);
    }

    public int addDeviceList(Collection<DevNode> devsList) {
        this.deviceTable.getRowSorter().setSortKeys(new ArrayList());
        List oldRows = this.tableModel.getAllRows();
        int count = 0;
        ArrayList<TableRow> addedRows = new ArrayList<TableRow>();
        for (DevNode device : devsList) {
            TableRow row = this.createRow(device);
            addedRows.add(row);
        }
        this.tableModel.removeRow(oldRows.toArray(new TableRow[oldRows.size()]));
        oldRows.addAll(0, addedRows);
        devsList.addAll(devsList);
        this.tableModel.addRow(oldRows.toArray(new TableRow[oldRows.size()]));
        return count;
    }

    public void clearDevice() {
        this.deviceList.clear();
        this.tableModel.removeAll();
        this.deviceTable.removeAll();
    }

    public boolean isContainsDevice(String sn) {
        for (DevNode device : this.deviceList) {
            if (!sn.equals(device.getDeviceSerialNumber())) continue;
            return true;
        }
        return false;
    }

    public void updateDevice(DevNode device) {
        TableRow row = this.tableModel.getTableRowBy((Object)device);
        if (null == row) {
            return;
        }
        int i = 0;
        if (device.isHyperMetro()) {
            IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(device.getDeviceType().toString(), (Icon)ResourceUtil.getImage((String)"hyperMetroIcon.png"));
            String sns = device.getRemoteSNs().toString();
            sns = sns.substring(sns.indexOf(91) + 1, sns.indexOf(93));
            sns = this.cutTooLongSns2Lines(sns);
            cell.setTips(ResourceUtil.getStringWithParams((String)"devicemanager.layout.hypermetro.device.tips", (Object[])new Object[]{sns}));
            row.setValueAt(i++, (Object)cell);
        } else {
            row.setValueAt(i++, (Object)device.getDeviceType());
        }
        row.setValueAt(i++, (Object)device.getProductVersion());
        row.setValueAt(i++, (Object)device.getDeviceName());
        row.setValueAt(i++, (Object)new IpAddressStrategy(device.getIp()));
        row.setValueAt(i++, (Object)device.getDeviceSerialNumber());
        row.setValueAt(i++, (Object)device.getLoginUser().getUserName());
        row.setValueAt(i++, (Object)device.getPort());
        this.tableModel.fireTableDataChanged();
    }

    public void removeDevices(List<TableRow> rows) {
        if (null != rows) {
            this.tableModel.removeRow(rows.toArray(new TableRow[rows.size()]));
            for (TableRow row : rows) {
                this.deviceList.remove(row.getIdentifier());
            }
            this.updateButtons();
        }
    }

    public void removeNode(DevNode node) {
        int rowCount = this.tableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = this.tableModel.getRow(i);
            Object obj = row.getIdentifier();
            if (!(obj instanceof DevNode)) continue;
            DevNode nodeInTable = (DevNode)obj;
            if (!node.getDevKey().equals(nodeInTable.getDevKey())) continue;
            this.tableModel.removeRow(new TableRow[]{row});
            this.deviceList.remove(row.getIdentifier());
            return;
        }
    }

    public Collection<DevNode> getDeviceList() {
        return this.deviceList;
    }

    public JFrame getParentJFrame() {
        return this.parentFrame;
    }

    @Override
    public void fireNodeAdd(DevNode dev) throws ToolException {
        this.addDevice(dev);
        this.updateButtons();
    }

    @Override
    public void fireNodeModify(DevNode dev) throws ToolException {
        if (dev instanceof AiDevNode) {
            return;
        }
        this.updateDevice(dev);
    }

    @Override
    public void fireNodeDelete(DevNode dev) throws ToolException {
        if (dev instanceof AiDevNode) {
            return;
        }
        this.removeNode(dev);
        this.updateButtons();
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public void refreshDevList() {
        this.tableModel.removeAll();
        TableRow row = null;
        for (DevNode node : this.deviceList) {
            row = this.createRow(node);
            this.tableModel.addRow(new TableRow[]{row});
        }
    }

    private class TableMouseAdapter
    extends MouseAdapter {
        private TableMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            int row = DeviceManagementPanel.this.deviceTable.rowAtPoint(mouseEvent.getPoint());
            DeviceManagementPanel.this.deviceTable.setRowSelectionInterval(row, row);
            JPopupMenu popmenu = new JPopupMenu();
            for (ToolAction action : DeviceManagementPanel.this.rightMouseActions) {
                popmenu.add((Action)action);
            }
            popmenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

