/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.analyze;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.diskanalyze.analyze.AnalyzeThread;
import com.huawei.ism.tool.diskanalyze.analyze.DiskDomainScorer;
import com.huawei.ism.tool.diskanalyze.analyze.FinalThread;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeItemResult;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeStatus;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeSummary;
import com.huawei.ism.tool.diskanalyze.rule.AnalyzeItem;
import com.huawei.ism.tool.diskanalyze.rule.CheckPoint;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import com.huawei.ism.tool.diskanalyze.rule.Rule;
import com.huawei.ism.tool.diskanalyze.rule.RuleManager;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.diskanalyze.worktaker.IProgressListener;
import com.huawei.ism.tool.diskanalyze.worktaker.IReportWorktaker;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class AnalyzeEngine {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AnalyzeEngine.class);
    private static final AnalyzeEngine INSTANCE = new AnalyzeEngine();
    private IReportWorktaker wtk = (IReportWorktaker)WorktakerUtil.getWorktaker(IReportWorktaker.class);
    private int deviceCount = 0;
    private List<AnalyzeDevice> adList = null;
    private IProgressListener iProgressListener = null;
    private int allDiskNum;
    private int nowDiskNum = 0;
    private int nowFinalDiskNum = 0;
    private int deadThreadNum = 0;

    private AnalyzeEngine() {
    }

    private int getDiskNumAlldev(List<String> uuidList) {
        int num = 0;
        List<AnalyzeDevice> devList = DiskAnalyzeContext.getInstance().getSelectAnalyzeDeviceList(uuidList);
        for (AnalyzeDevice analyzeDevice : devList) {
            num += this.getDiskNumAdev(analyzeDevice);
        }
        return num;
    }

    private int getDiskNumAdev(AnalyzeDevice ad) {
        int num = ad.getSucceedDisk();
        if (0 != num) {
            return num;
        }
        int subNum = 0;
        List<String> smartList = ad.getSmartList();
        if (null == smartList || smartList.isEmpty()) {
            return subNum;
        }
        for (String smartFile : smartList) {
            subNum = this.getSmartFileSum(ad, subNum, smartFile);
        }
        return subNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getSmartFileSum(AnalyzeDevice ad, int subNum, String smartFile) {
        InputStream in = DiskHealthAssistant.getInstance().getTxtInputStream(smartFile, ad);
        BufferedReader reader = null;
        String line = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String key = "Device Model";
            while (null != (line = reader.readLine())) {
                if (!line.contains(key)) continue;
                ++subNum;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("getDiskNumAdev Read error ");
            StreamUtils.closeStream(null, (InputStream)in);
            StreamUtils.closeResource(null, (Closeable)reader);
        }
        catch (IOException e2) {
            LOGGER.error("getDiskNumAdev Read error ");
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, (InputStream)in);
                    StreamUtils.closeResource(null, reader);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, (InputStream)in);
            StreamUtils.closeResource(null, (Closeable)reader);
        }
        StreamUtils.closeStream(null, (InputStream)in);
        StreamUtils.closeResource(null, (Closeable)reader);
        return subNum;
    }

    public static AnalyzeEngine getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalyzeDevice getNextAnalyzeDevice(Object lock) {
        Object object = lock;
        synchronized (object) {
            if (this.deviceCount >= this.adList.size()) {
                return null;
            }
            AnalyzeDevice ad = this.adList.get(this.deviceCount);
            ++this.deviceCount;
            return ad;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadQuit(Object lock) {
        Object object = lock;
        synchronized (object) {
            ++this.deadThreadNum;
        }
    }

    public void startAnalyze(IProgressListener progressListener, List<String> uuidList) {
        DiskAnalyzeContext.getInstance().setAnalyzeStatus(AnalyzeStatus.ING_ANALYZE);
        this.deadThreadNum = 0;
        this.allDiskNum = this.getDiskNumAlldev(uuidList);
        this.iProgressListener = progressListener;
        this.nowDiskNum = 0;
        this.initSycData(uuidList);
        int threadCount = Integer.valueOf(ResourceUtil.getString((String)"analyze.thread.count"));
        DiskAnalyzeContext.getInstance().initUserOpData(uuidList);
        for (int i = 0; i < threadCount; ++i) {
            ToolThreadFactory.newDefaultThread((Runnable)new AnalyzeThread(i)).start();
        }
        ToolThreadFactory.newDefaultThread((Runnable)new FinalThread(threadCount, uuidList)).start();
    }

    private synchronized void initSycData(List<String> uuidList) {
        this.deviceCount = 0;
        this.adList = DiskAnalyzeContext.getInstance().getSelectAnalyzeDeviceList(uuidList);
    }

    private void writeAnalyzeSummary(List<String> uuidList) {
        AnalyzeSummary analyzeSummary = DiskAnalyzeContext.getInstance().getAnalyzeSummary();
        List<AnalyzeDevice> devList = DiskAnalyzeContext.getInstance().getSelectAnalyzeDeviceList(uuidList);
        analyzeSummary.setTotalDeviceNum(devList.size());
        int succeedDevNum = 0;
        int totalDiskNum = 0;
        int riskTotal = 0;
        int midRiskNum = 0;
        int failedDiskNum = 0;
        int failedDevNum = 0;
        int collectDiskNum = 0;
        for (AnalyzeDevice analyzeDevice : devList) {
            if (analyzeDevice.isAnalyzeSuccess()) {
                analyzeDevice.getDiskList().removeAll(analyzeDevice.getFailedDiskList());
                ++succeedDevNum;
                this.calcDiskInfo(analyzeDevice);
                DiskDomainScorer.score(analyzeDevice);
                failedDiskNum += analyzeDevice.getFailedDiskList().size();
                riskTotal += analyzeDevice.getRiskDiskList().size();
                midRiskNum += analyzeDevice.getMinRiskDiskList().size();
                collectDiskNum += analyzeDevice.getCollectDiskList().size();
                totalDiskNum += analyzeDevice.getDiskList().size();
                continue;
            }
            ++failedDevNum;
        }
        analyzeSummary.setSuccessDeviceNum(succeedDevNum);
        analyzeSummary.setTotalDiskNum(totalDiskNum);
        analyzeSummary.setFailedDiskNum(failedDiskNum);
        analyzeSummary.setRiskDiskNum(riskTotal);
        analyzeSummary.setMidRiskDiskNum(midRiskNum);
        analyzeSummary.setFailedDeviceNum(failedDevNum);
        analyzeSummary.setCollectDiskNum(collectDiskNum);
    }

    private void makeAllDevFinalScore(List<String> uuidList) {
        this.nowFinalDiskNum = 0;
        List<AnalyzeDevice> devList = DiskAnalyzeContext.getInstance().getSelectAnalyzeDeviceList(uuidList);
        for (AnalyzeDevice analyzeDevice : devList) {
            if (!analyzeDevice.isAnalyzeSuccess()) continue;
            this.makeOneDevFinalScore(analyzeDevice);
        }
    }

    private void makeOneDevFinalScore(AnalyzeDevice ad) {
        List<AnalyzeDisk> diskList = ad.getDiskList();
        for (AnalyzeDisk disk : diskList) {
            if (!disk.isAnalyzeSuc()) continue;
            this.makeOneDiskFinalScore(ad, disk);
        }
    }

    private void makeOneDiskFinalScore(AnalyzeDevice ad, AnalyzeDisk analyzeDisk) {
        int n;
        Rule analyzeRule;
        DiskType type = analyzeDisk.getType();
        if (type.toString().contains("NearLine SAS") || type.toString().contains("NL SAS")) {
            type = DiskType.SAS;
        }
        if (!this.countRelativeCk(ad, analyzeDisk, analyzeRule = RuleManager.getInstance().getRule(type))) {
            return;
        }
        Map<String, Integer> checkPointScores = analyzeDisk.getCheckPointScores();
        HashMap<String, Integer> itemScoreMap = new HashMap<String, Integer>();
        this.setMaxInCk(itemScoreMap, checkPointScores, analyzeRule);
        ArrayList<AnalyzeItemResult> resultList = new ArrayList<AnalyzeItemResult>();
        for (String string : analyzeRule.getItemIdList()) {
            if (!itemScoreMap.containsKey(string)) continue;
            AnalyzeItem analyzeItem = analyzeRule.getItemById(string);
            AnalyzeItemResult analyzeItemResult = new AnalyzeItemResult();
            analyzeItemResult.setRule(analyzeItem);
            analyzeItemResult.setRiskLevel((Integer)itemScoreMap.get(string));
            resultList.add(analyzeItemResult);
        }
        analyzeDisk.setResultList(resultList);
        ArrayList<Integer> riskLevels = new ArrayList<Integer>();
        for (AnalyzeItemResult itemResult : resultList) {
            riskLevels.add(itemResult.getRiskLevel());
        }
        boolean bl = false;
        try {
            n = analyzeRule.getCombineLogic().getCombinedScore(riskLevels);
        }
        catch (RuntimeException e) {
            LOGGER.error("[makeOneDiskFinalScore]  getCombinedScore error");
        }
        catch (Exception e) {
            LOGGER.error("[makeOneDiskFinalScore]  getCombinedScore error");
        }
        analyzeDisk.setScore(n);
        ++this.nowFinalDiskNum;
        this.freshScoresProgress();
    }

    private boolean countRelativeCk(AnalyzeDevice ad, AnalyzeDisk analyzeDisk, Rule analyzeRule) {
        int ckScore;
        String ckId;
        Map<String, Integer> checkPointScores = analyzeDisk.getCheckPointScores();
        HashMap<String, Integer> ckScoresToBeChange = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : checkPointScores.entrySet()) {
            ckId = entry.getKey();
            ckScore = entry.getValue();
            CheckPoint ck = analyzeRule.getCheckPointById(ckId);
            CheckPointValue ckValue = analyzeDisk.getCheckPointValue(ckId);
            int scoreRelative = 0;
            try {
                List<CheckPointValue> othersCkValue = this.getOthersCkValue(ad, ckId, analyzeDisk);
                scoreRelative = ck.getCheckLogic().getRelativeRisk(ckValue, othersCkValue, analyzeDisk.getVender());
            }
            catch (NumberFormatException e) {
                analyzeDisk.setAnalyzeSuc(false);
                this.setAnalyzeFailedReason(ad, analyzeDisk, ck);
                return false;
            }
            catch (RuntimeException e) {
                analyzeDisk.setAnalyzeSuc(false);
                this.setAnalyzeFailedReason(ad, analyzeDisk, ck);
                return false;
            }
            catch (Exception e) {
                analyzeDisk.setAnalyzeSuc(false);
                this.setAnalyzeFailedReason(ad, analyzeDisk, ck);
                return false;
            }
            int ckFinalScore = scoreRelative + ckScore;
            if (ckFinalScore > 10) {
                ckFinalScore = 10;
            }
            if (0 == scoreRelative) continue;
            ckScoresToBeChange.put(ckId, ckFinalScore);
        }
        if (!ckScoresToBeChange.isEmpty()) {
            for (Map.Entry<String, Integer> entry : ckScoresToBeChange.entrySet()) {
                ckId = entry.getKey();
                ckScore = entry.getValue();
                analyzeDisk.updateCheckPointScore(ckId, ckScore);
            }
        }
        return true;
    }

    private void setAnalyzeFailedReason(AnalyzeDevice ad, AnalyzeDisk analyzeDisk, CheckPoint ck) {
        ArrayList<String> reason = new ArrayList<String>();
        reason.add("3");
        reason.add("");
        reason.add(ck.getBelongItemId());
        analyzeDisk.setFailedReason(reason);
        ad.getFailedDiskList().add(analyzeDisk);
    }

    private List<CheckPointValue> getOthersCkValue(AnalyzeDevice ad, String ckId, AnalyzeDisk analyzeDisk) {
        ArrayList<CheckPointValue> othersCkValue = new ArrayList<CheckPointValue>();
        List<AnalyzeDisk> diskList = ad.getDiskList();
        for (AnalyzeDisk disk : diskList) {
            if (!disk.isAnalyzeSuc() || !analyzeDisk.getModel().equals(disk.getModel()) || analyzeDisk.getSn().equals(disk.getSn()) || disk.getCheckPointValue(ckId) == null) continue;
            othersCkValue.add(disk.getCheckPointValue(ckId));
        }
        return othersCkValue;
    }

    private void setMaxInCk(Map<String, Integer> itemScoreMap, Map<String, Integer> checkPointScores, Rule analyzeRule) {
        for (Map.Entry<String, Integer> entry : checkPointScores.entrySet()) {
            String ckId = entry.getKey();
            int ckScore = entry.getValue();
            CheckPoint ck = analyzeRule.getCheckPointById(ckId);
            String itemId = ck.getBelongItemId();
            if (itemScoreMap.containsKey(itemId)) {
                this.compareScoreAndexc(itemScoreMap, itemId, ckScore);
                continue;
            }
            itemScoreMap.put(itemId, ckScore);
        }
    }

    private void compareScoreAndexc(Map<String, Integer> itemScoreMap, String itemId, int ckScore) {
        if (ckScore > itemScoreMap.get(itemId)) {
            itemScoreMap.put(itemId, ckScore);
        }
    }

    public void calcDiskInfo(AnalyzeDevice analyzeDevice) {
        for (AnalyzeDisk analyzeDisk : analyzeDevice.getDiskList()) {
            if (!analyzeDisk.isAnalyzeSuc()) continue;
            if (analyzeDisk.getScore() == -1) {
                analyzeDevice.getCollectDiskList().add(analyzeDisk);
                analyzeDisk.setBgColor("#ffef00");
                continue;
            }
            if (this.isSpecialHitachi(analyzeDisk)) {
                this.specialHitachiResetScore(analyzeDisk, analyzeDisk.getScore());
            }
            if (analyzeDisk.getScore() <= 30) {
                analyzeDevice.getRiskDiskList().add(analyzeDisk);
                analyzeDisk.setBgColor("#ff6a6a");
                continue;
            }
            if (analyzeDisk.getScore() > 60) continue;
            analyzeDevice.getMinRiskDiskList().add(analyzeDisk);
            analyzeDisk.setBgColor("#ff9000");
        }
    }

    public void freshProgress() {
        int scroeTimePerDisk = Integer.parseInt(ResourceUtil.getString((String)"analyze.disk.scoredisktime"));
        int analyzeTimePerDisk = Integer.parseInt(ResourceUtil.getString((String)"analyze.disk.analyzeonedisktime"));
        int allPreTime = scroeTimePerDisk + analyzeTimePerDisk;
        int progressNum = this.nowDiskNum * 50 / this.allDiskNum;
        this.iProgressListener.refreshProgress(progressNum, allPreTime * this.allDiskNum - analyzeTimePerDisk * this.nowDiskNum);
    }

    private void freshScoresProgress() {
        int scroeTimePerDisk = Integer.parseInt(ResourceUtil.getString((String)"analyze.disk.scoredisktime"));
        int progressNum = this.nowFinalDiskNum * 50 / this.allDiskNum + 50;
        this.iProgressListener.refreshProgress(progressNum, scroeTimePerDisk * this.allDiskNum - this.nowFinalDiskNum * scroeTimePerDisk);
    }

    public void finalFresh(List<String> uuidList) {
        this.makeAllDevFinalScore(uuidList);
        this.writeAnalyzeSummary(uuidList);
        this.iProgressListener.finishAnalyze(DiskAnalyzeContext.getInstance().getAnalyzeSummary());
        this.iProgressListener.refreshProgress(100, 0);
        DiskAnalyzeContext.getInstance().setAnalyzeStatus(AnalyzeStatus.AFTER_ANALYZE);
    }

    public IReportWorktaker getWtk() {
        return this.wtk;
    }

    public int getDeadThreadNum() {
        return this.deadThreadNum;
    }

    public int getNowDiskNum() {
        return this.nowDiskNum;
    }

    public void setNowDiskNum(int nowDiskNum) {
        this.nowDiskNum = nowDiskNum;
    }

    private boolean isSpecialHitachi(AnalyzeDisk disk) {
        if ("HUS156060VLS600".equals(disk.getModel()) && "A760,A510".contains(disk.getFirmwareVersion())) {
            return true;
        }
        return "HUS156060VLF400".equals(disk.getModel()) && "fT02,F510".contains(disk.getFirmwareVersion());
    }

    private void specialHitachiResetScore(AnalyzeDisk disk, int score) {
        if (score > 60 && score <= 80) {
            disk.setScore(60);
        }
        if (score > 30 && score < 60) {
            disk.setScore(30);
        }
    }
}

