/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.analyze;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.diskanalyze.analyze.AnalyzeEngine;
import com.huawei.ism.tool.diskanalyze.analyze.DiskAnalyzeBuffer;
import com.huawei.ism.tool.diskanalyze.analyze.DiskVender;
import com.huawei.ism.tool.diskanalyze.analyze.IDiskLoader;
import com.huawei.ism.tool.diskanalyze.analyze.loader.DiskLoaderFactory;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.rule.CheckPoint;
import com.huawei.ism.tool.diskanalyze.rule.CheckPointValue;
import com.huawei.ism.tool.diskanalyze.rule.DiskType;
import com.huawei.ism.tool.diskanalyze.rule.ICheckLogic;
import com.huawei.ism.tool.diskanalyze.rule.Rule;
import com.huawei.ism.tool.diskanalyze.rule.RuleManager;
import com.huawei.ism.tool.diskanalyze.rule.exception.InvalidNumberException;
import com.huawei.ism.tool.diskanalyze.rule.logic.MutilEqual;
import com.huawei.ism.tool.diskanalyze.rule.parser.HssdD5ValueParser;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AnalyzeThread.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AnalyzeThread.class);
    protected static final String TEM_CEL = "Temperature_Celsius";
    protected static final String UDMA_CRC_ERR_COUNT = "UDMA_CRC_Error_Count";
    protected static final String AIRFLOW_TEM = "Airflow_Temperature";
    protected static final String AVAILABLE_SPARE_THRESHOLD = "available_spare_threshold";
    protected static final AnalyzeEngine ANALYZE_ENGINE = AnalyzeEngine.getInstance();
    public static final ConcurrentHashMap<String, String> HAVEDHA = new ConcurrentHashMap();
    protected String threadname = "";
    protected static final Object LOCK = new Object();
    protected static final String DORADO = "Dorado";
    public static final String POH_SATA = "Power_On_Hours";
    public static final String POH_NVMESSD = "power_on_hours";
    public static final String POH_SAS = "power on time";
    public static final String START_DHA = "Start Health Mark";
    public static final int MAGICNUMBER_8041 = 8041;
    public static final int MAGICNUMBER_16801 = 16801;
    public static final int MAGICNUMBER_25561 = 25561;
    public static final int MAGICNUMBER_34321 = 34321;
    public static final int MAGICNUMBER_87601 = 87601;
    public static final Map<String, String> POHMAP = new ConcurrentHashMap<String, String>();
    private String[] huaweiVender = new String[]{"HUAWEI", "HUASAI", "HUASY"};
    private String[] ssdModeLimit = new String[]{"HSSD-D3", "HSSD-D5", "HSSD-D6", "HSSD-D7", "HW", "HSSD-D8"};
    private static final Map<String, String> PURCHASED_SSD_MODEL_VENDOR_MAP = new HashMap<String, String>();
    private int[][] valueSpanSAS = new int[][]{{0, 8041, 68}, {8041, 16801, 60}, {16801, 25561, 56}, {25561, 34321, 51}, {34321, 87601, 41}};
    private int[][] valueSpanSATA = new int[][]{{0, 8041, 68}, {8041, 16801, 65}, {16801, 25561, 60}, {25561, 34321, 58}, {34321, 87601, 52}};
    private List<String> usedKeys = new ArrayList<String>();

    public AnalyzeThread(int number) {
        this.threadname = "Tread Name [AnalyzeThread_" + number + ']';
    }

    protected AnalyzeThread() {
    }

    @Override
    public void run() {
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadname);
        int analyzeSum = 0;
        while (true) {
            AnalyzeDevice ad;
            if (null == (ad = ANALYZE_ENGINE.getNextAnalyzeDevice(LOCK))) break;
            try {
                IDiskLoader loader = DiskLoaderFactory.getInstance().getDiskLoader(ad.getDeviceInfo().getDeviceType());
                if (null == loader) continue;
                List<String> smartTxt = loader.loadSmartFiles(ad);
                ad.setSmartList(smartTxt);
                loader.loadBasicInfo(ad);
                this.analyzeDiskHealth(ad);
            }
            catch (StringIndexOutOfBoundsException e) {
                LOGGER.error("loadBasicInfo StringIndexOutOfBoundsException");
                ad.setAnalyzeSuccess(false);
                LOGGER.info(String.format(Locale.ENGLISH, "Analyze complete >> Analyze to device %s end][Failed", ad.getDeviceInfo().getIp()));
                continue;
            }
            catch (RuntimeException e) {
                LOGGER.error("loadBasicInfo RuntimeException");
                ad.setAnalyzeSuccess(false);
                LOGGER.info(String.format(Locale.ENGLISH, "Analyze complete >> Analyze to device %s end][Failed", ad.getDeviceInfo().getIp()));
                continue;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "Analyze complete >> Analyze to device %s end][Success", ad.getDeviceInfo().getIp()));
            ad.setAnalyzeSuccess(true);
            ++analyzeSum;
        }
        LOGGER.info(String.format(Locale.ENGLISH, "%s has analyzed devices sum total is %d", this.threadname, analyzeSum));
        ANALYZE_ENGINE.threadQuit(LOCK);
        Thread.currentThread().setName(oldName);
    }

    protected void analyzeDiskHealth(AnalyzeDevice ad) {
        LOGGER.info(String.format(Locale.ENGLISH, "%s begin to analyzeDiskHealth, device:%s", this.threadname, ad.getUuid()));
        for (String smartTxt : ad.getSmartList()) {
            this.analyzeOneSmartFile(smartTxt, ad);
        }
    }

    /*
     * Exception decompiling
     */
    protected void analyzeOneSmartFile(String smartFile, AnalyzeDevice ad) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleOnOneLine(AnalyzeDevice ad, DiskAnalyzeBuffer feildBuffer, String line) {
        if (line.contains("Device Model") && feildBuffer.isHasHeadInfo()) {
            this.meetAnalyzeTime(line, feildBuffer, ad);
        } else if (feildBuffer.isHasHeadInfo()) {
            this.setDiskInfo(feildBuffer, line, ad);
        } else if (line.contains("Device Model") && !feildBuffer.isHasHeadInfo()) {
            this.meetHeadfirstTime(line, feildBuffer, ad);
        }
    }

    protected boolean handleOnTxtEnd(AnalyzeDevice ad, DiskAnalyzeBuffer feildBuffer, String line) {
        if (null == line) {
            feildBuffer.setTxtIsOver(true);
        }
        if (feildBuffer.isTxtIsOver() && feildBuffer.isHasHeadInfo()) {
            this.meetAnalyzeTime(line, feildBuffer, ad);
            return true;
        }
        return false;
    }

    protected String getStartLineAndNext(DiskAnalyzeBuffer feildBuffer) {
        String startSrt = "";
        if (feildBuffer.getStartLineIndex() >= feildBuffer.getStartLine().size()) {
            return null;
        }
        int n = feildBuffer.getStartLineIndex();
        startSrt = feildBuffer.getStartLine().get(n);
        feildBuffer.setStartLineIndex(++n);
        return startSrt;
    }

    protected void meetHeadfirstTime(String line, DiskAnalyzeBuffer feildBuffer, AnalyzeDevice ad) {
        feildBuffer.addDiskInfo(line);
        feildBuffer.setHasInfoSign(true);
        String[] modelStr = line.split(":");
        feildBuffer.getAnalyzeDisk().setModel(modelStr[1].trim());
        ad.addDiskList(feildBuffer.getAnalyzeDisk());
    }

    protected void meetAnalyzeTime(String line, DiskAnalyzeBuffer feildBuffer, AnalyzeDevice ad) {
        this.analyzeOneDisk(feildBuffer, ad);
        feildBuffer.clear();
        this.refreshUI();
        if (null == line) {
            return;
        }
        feildBuffer.addDiskInfo(line);
        this.addDevModolToDisk(feildBuffer, line, ad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUI() {
        Object object = LOCK;
        synchronized (object) {
            int nowDiskNum = ANALYZE_ENGINE.getNowDiskNum() + 1;
            ANALYZE_ENGINE.setNowDiskNum(nowDiskNum);
            ANALYZE_ENGINE.freshProgress();
        }
    }

    protected void setDiskInfo(DiskAnalyzeBuffer feildBuffer, String line, AnalyzeDevice ad) {
        if (line.trim().equals(START_DHA)) {
            feildBuffer.setBufferOk(false);
        }
        if (feildBuffer.isBufferOk()) {
            return;
        }
        feildBuffer.addDiskInfo(line);
        if (line.contains("Firmware Version")) {
            feildBuffer.getAnalyzeDisk().setFirmwareVersion(line.split(":")[1].trim());
        }
        this.getPOH(line, ad, feildBuffer);
        if (feildBuffer.isDynamicCK() && feildBuffer.isDynamicFeild()) {
            if (line.contains(TEM_CEL) || line.contains(UDMA_CRC_ERR_COUNT) || line.contains(AIRFLOW_TEM)) {
                return;
            }
            this.handleOnDynamicCk(feildBuffer, line);
            return;
        }
        if (null != feildBuffer.getAnalyzeRule() && feildBuffer.isDynamicCK() && (feildBuffer.getAnalyzeRule().isItemsBegin(line) || line.contains(START_DHA))) {
            feildBuffer.setDynamicFeild(true);
            return;
        }
        this.setNoDynamicDiskInfo(line, feildBuffer, ad);
    }

    protected void handleOnDynamicCk(DiskAnalyzeBuffer feildBuffer, String line) {
        if (feildBuffer.getAnalyzeRule().isItemsEnd(line) || line.startsWith("***")) {
            feildBuffer.setDynamicFeild(false);
            feildBuffer.setBufferOk(true);
            return;
        }
        if (null != feildBuffer.getStartStr() && line.contains(feildBuffer.getStartStr())) {
            this.buildCkMap(feildBuffer);
            return;
        }
        this.buildDynamicCkMap(feildBuffer, line);
    }

    protected void setNoDynamicDiskInfo(String line, DiskAnalyzeBuffer feildBuffer, AnalyzeDevice ad) {
        if (line.contains("Serial Number")) {
            String[] snStr = line.split(":");
            feildBuffer.getAnalyzeDisk().setSn(snStr[1].trim());
            this.addSlotAndEnNo(feildBuffer.getAnalyzeDisk(), ad, snStr[1].trim());
            this.setDiskTypeInfo(feildBuffer, line, ad);
            String manu = ad.getSnManufacturer().get(feildBuffer.getAnalyzeDisk().getSn());
            feildBuffer.getAnalyzeDisk().setVender(manu);
        } else if (null != feildBuffer.getStartStr() && line.contains(feildBuffer.getStartStr())) {
            if (line.contains(AVAILABLE_SPARE_THRESHOLD)) {
                return;
            }
            this.buildCkMap(feildBuffer);
        }
    }

    protected void buildCkMap(DiskAnalyzeBuffer feildBuffer) {
        int n = feildBuffer.getDiskInfo().size() - 1;
        Set<CheckPoint> ck = feildBuffer.getAnalyzeRule().getCheckPointSet(feildBuffer.getStartStr());
        for (CheckPoint checkPoint : ck) {
            feildBuffer.getIndexOfCK().put(checkPoint.getId(), n);
        }
        String nextString = this.getStartLineAndNext(feildBuffer);
        if (nextString != null) {
            feildBuffer.setStartStr(nextString);
        }
    }

    protected void buildDynamicCkMap(DiskAnalyzeBuffer feildBuffer, String line) {
        int n = feildBuffer.getDiskInfo().size() - 1;
        String ckId = feildBuffer.getAnalyzeRule().registerCheckPoint(line);
        feildBuffer.getIndexOfCK().put(ckId, n);
    }

    protected void setDiskTypeInfo(DiskAnalyzeBuffer feildBuffer, String line, AnalyzeDevice ad) {
        DiskType diskType = DiskType.SAS;
        String nowDiskType = ad.getSnType().get(feildBuffer.getAnalyzeDisk().getSn());
        String vendor = ad.getSnManufacturer().get(feildBuffer.getAnalyzeDisk().getSn());
        String diskModel = feildBuffer.getAnalyzeDisk().getModel();
        feildBuffer.getAnalyzeDisk().setRealDiskType(nowDiskType);
        if (nowDiskType != null) {
            if (nowDiskType.contains(DiskType.SATA.toString())) {
                diskType = DiskType.SATA;
            } else if (nowDiskType.contains(DiskType.NVME.toString())) {
                diskType = DiskType.NVME;
            } else if (nowDiskType.contains(DiskType.QLC.toString())) {
                diskType = DiskType.QLC;
            } else if (nowDiskType.contains(DiskType.HSSD.toString()) && DiskHealthAssistant.checkStr(vendor, this.huaweiVender)) {
                diskType = DiskType.HSSD;
            } else if (nowDiskType.contains(DiskType.FC.toString())) {
                diskType = DiskType.FC;
            } else if (nowDiskType.equals(DiskType.SCM.toString())) {
                diskType = DiskType.SCM;
            } else if (PURCHASED_SSD_MODEL_VENDOR_MAP.containsKey(diskModel)) {
                diskType = DiskType.SSD;
            } else if (nowDiskType.equals(DiskType.SSD.toString())) {
                diskType = DiskType.SSD;
            }
        } else {
            LOGGER.info("get diskType is null");
        }
        Rule anaRule = RuleManager.getInstance().getRule(diskType);
        feildBuffer.setAnalyzeRule(anaRule);
        if (null != nowDiskType) {
            if (nowDiskType.contains(DiskType.NEAR_LINE_SAS.toString())) {
                diskType = DiskType.NEAR_LINE_SAS;
            } else if (nowDiskType.contains(DiskType.NLSAS.toString()) || nowDiskType.contains("NL_SAS")) {
                diskType = DiskType.NLSAS;
            }
        }
        feildBuffer.getAnalyzeDisk().setType(diskType);
        feildBuffer.setStartLine(feildBuffer.getAnalyzeRule().getStartLineList());
        feildBuffer.setStartStr(this.getStartLineAndNext(feildBuffer));
        if (line.contains("Informational Exceptions log page")) {
            int n = feildBuffer.getDiskInfo().size() - 1;
            Set<CheckPoint> ck = feildBuffer.getAnalyzeRule().getCheckPointSet(feildBuffer.getStartStr());
            for (CheckPoint checkPoint : ck) {
                feildBuffer.getIndexOfCK().put(checkPoint.getId(), n);
            }
            feildBuffer.setStartStr(this.getStartLineAndNext(feildBuffer));
        }
        feildBuffer.setDynamicCK(feildBuffer.getAnalyzeRule().isEnableDynamic());
    }

    protected void addDevModolToDisk(DiskAnalyzeBuffer feildBuffer, String line, AnalyzeDevice ad) {
        AnalyzeDisk newAnalyzeDisk = new AnalyzeDisk();
        feildBuffer.setAnalyzeDisk(newAnalyzeDisk);
        String[] modelStr = line.split(":");
        feildBuffer.getAnalyzeDisk().setModel(modelStr[1].trim());
        ad.addDiskList(feildBuffer.getAnalyzeDisk());
    }

    protected void addSlotAndEnNo(AnalyzeDisk analyzeDisk, AnalyzeDevice ad, String sn) {
        Map<String, KeyValue<String, String>> enclosureSlotMap = ad.getEnclosureSlotInfo();
        if (ad.getDeviceInfo().isDstorage()) {
            this.addDStorageSlotAndEnNo(analyzeDisk, enclosureSlotMap, sn);
            return;
        }
        KeyValue<String, String> enclosureSlot = enclosureSlotMap.get(sn);
        if (null == enclosureSlot) {
            analyzeDisk.setEnclosureNo("");
            analyzeDisk.setSlotNo("");
            return;
        }
        analyzeDisk.setEnclosureNo((String)enclosureSlot.getKey());
        analyzeDisk.setSlotNo((String)enclosureSlot.getValue());
    }

    void addDStorageSlotAndEnNo(AnalyzeDisk analyzeDisk, Map<String, KeyValue<String, String>> enclosureSlotMap, String sn) {
        String enclosureSlotKey = this.getEnclosureSlotKey(enclosureSlotMap, sn);
        if (StringUtils.isNULLStr((String)enclosureSlotKey)) {
            analyzeDisk.setEnclosureNo("");
            analyzeDisk.setSlotNo("");
            log.error("No enclosureSlot information about the hard disk whose SN is {}.", (Object)sn);
            return;
        }
        KeyValue<String, String> enclosureSlot = enclosureSlotMap.get(enclosureSlotKey);
        analyzeDisk.setEnclosureNo((String)enclosureSlot.getKey());
        analyzeDisk.setSlotNo((String)enclosureSlot.getValue());
        this.usedKeys.add(enclosureSlotKey);
    }

    @NotNull
    private String getEnclosureSlotKey(Map<String, KeyValue<String, String>> enclosureSlotMap, String sn) {
        return enclosureSlotMap.keySet().stream().filter(key -> key.contains(sn)).filter(key -> !this.usedKeys.contains(key)).findFirst().orElse("");
    }

    protected void analyzeOneDisk(DiskAnalyzeBuffer feildBuffer, AnalyzeDevice ad) {
        this.checkNull(feildBuffer);
        List<String> diskInfo = feildBuffer.getDiskInfo();
        AnalyzeDisk analyzeDisk = feildBuffer.getAnalyzeDisk();
        Map<String, Integer> indexOfCK = feildBuffer.getIndexOfCK();
        HashMap<String, Integer> checkPointScores = new HashMap<String, Integer>();
        HashMap<String, CheckPointValue> checkPointValues = new HashMap<String, CheckPointValue>();
        Rule analyzeRule = feildBuffer.getAnalyzeRule();
        List<String> startLineList = analyzeRule.getStartLineList();
        analyzeDisk.setAnalyzeSuc(true);
        String manu = ad.getSnManufacturer().get(feildBuffer.getAnalyzeDisk().getSn());
        String versionType = ad.getDevTypeVersion();
        if (null != versionType) {
            boolean flag;
            boolean isHuawei = DiskHealthAssistant.checkStr(manu, this.huaweiVender);
            boolean bl = flag = analyzeDisk.getType() == DiskType.HSSD && !DiskHealthAssistant.checkStr(analyzeDisk.getModel(), this.ssdModeLimit);
            if (flag) {
                this.setHSSDFailReason(analyzeDisk, ad);
                return;
            }
            boolean bl2 = flag = analyzeDisk.getType() == DiskType.NVME && !isHuawei;
            if (flag) {
                this.setNVMeSSDFailReason(analyzeDisk, ad);
                return;
            }
        }
        this.addCkFailedMethod(analyzeDisk, indexOfCK, analyzeRule, startLineList, checkPointScores);
        if (this.addCheckPointScoresMap(feildBuffer, ad, diskInfo, analyzeDisk, indexOfCK, checkPointScores, checkPointValues, analyzeRule)) {
            return;
        }
        try {
            this.reCalcSpecialDiskRisk(analyzeDisk, analyzeRule, checkPointScores, checkPointValues, ad.getDeviceInfo().getDeviceType().toString(), analyzeDisk.getVender());
        }
        catch (Exception e) {
            LOGGER.error("recalc special disk risk failed.", (Throwable)e);
        }
        analyzeDisk.setCheckPointScores(checkPointScores);
        analyzeDisk.setCheckPointValues(checkPointValues);
    }

    private boolean addCheckPointScoresMap(DiskAnalyzeBuffer feildBuffer, AnalyzeDevice ad, List<String> diskInfo, AnalyzeDisk analyzeDisk, Map<String, Integer> indexOfCK, Map<String, Integer> checkPointScores, Map<String, CheckPointValue> checkPointValues, Rule analyzeRule) {
        for (Map.Entry<String, Integer> ckLineEntry : indexOfCK.entrySet()) {
            String id = ckLineEntry.getKey();
            int startIndex = ckLineEntry.getValue();
            CheckPoint checkPoint = analyzeRule.getCheckPointById(id);
            String[] infos = diskInfo.toArray(new String[0]);
            try {
                this.addCheckPointValue(ad, analyzeDisk, checkPointScores, checkPointValues, id, startIndex, checkPoint, infos);
            }
            catch (NumberFormatException e) {
                analyzeDisk.setAnalyzeSuc(false);
                LOGGER.info("data form is error......");
                this.setAnalyzeFailedReason(feildBuffer, ad, analyzeDisk, checkPoint, "3");
                return true;
            }
            catch (Exception e) {
                analyzeDisk.setAnalyzeSuc(false);
                LOGGER.info("err......");
                this.setAnalyzeFailedReason(feildBuffer, ad, analyzeDisk, checkPoint, "3");
                return true;
            }
        }
        return false;
    }

    private void setAnalyzeFailedReason(DiskAnalyzeBuffer feildBuffer, AnalyzeDevice ad, AnalyzeDisk analyzeDisk, CheckPoint checkPoint, String failedReasonCkInvalid) {
        ArrayList<String> reason = new ArrayList<String>();
        reason.add(failedReasonCkInvalid);
        reason.add(feildBuffer.getStartStr());
        reason.add(checkPoint.getBelongItemId());
        analyzeDisk.setFailedReason(reason);
        ad.getFailedDiskList().add(analyzeDisk);
    }

    protected void reCalcSpecialDiskRisk(AnalyzeDisk disk, Rule analyzeRule, Map<String, Integer> checkPointScores, Map<String, CheckPointValue> checkPointValues, String devType, String vender) throws InvalidNumberException {
        if (this.specialDisk(disk)) {
            int writeVal;
            LOGGER.info("recalc special disk value and score.");
            String verifyIndex = "";
            String writeIndex = "";
            String dhaIndex = "10";
            if (disk.getType() == DiskType.SAS) {
                verifyIndex = "4.1";
                writeIndex = "3.1";
            } else {
                verifyIndex = "5.1";
                writeIndex = "4.1";
            }
            if (checkPointScores.containsKey(dhaIndex)) {
                checkPointScores.put(dhaIndex, 0);
            }
            CheckPointValue verify = checkPointValues.get(verifyIndex);
            CheckPointValue write = checkPointValues.get(writeIndex);
            int verifyVal = Integer.valueOf(verify.getValue());
            if (verifyVal >= (writeVal = Integer.valueOf(write.getValue()).intValue())) {
                verify.setValue(String.valueOf(verifyVal - writeVal));
                write.setValue("0");
                LOGGER.info(String.format(Locale.ENGLISH, "reset verify value : %d", verifyVal - writeVal));
            } else {
                verify.setValue("0");
                write.setValue(String.valueOf(writeVal - verifyVal));
                LOGGER.info(String.format(Locale.ENGLISH, "reset write value : %d", writeVal - verifyVal));
            }
            this.reCalcRisk(analyzeRule, verifyIndex, writeIndex, dhaIndex, verify, write, checkPointScores, devType, vender);
        }
    }

    protected void reCalcRisk(Rule analyzeRule, String verifyIndex, String writeIndex, String dhaIndex, CheckPointValue verify, CheckPointValue write, Map<String, Integer> checkPointScores, String devType, String vender) throws InvalidNumberException {
        CheckPoint verifyCheckPoint = analyzeRule.getCheckPointById(verifyIndex);
        CheckPoint writeCheckPoint = analyzeRule.getCheckPointById(writeIndex);
        Integer verifyRiskNum = verifyCheckPoint.getCheckLogic().getRiskLevel(devType, vender, verify);
        Integer writeRiskNum = writeCheckPoint.getCheckLogic().getRiskLevel(devType, vender, write);
        LOGGER.info(String.format(Locale.ENGLISH, "reset verifyRiskNum : %s writeRiskNum : %s", verifyRiskNum, writeRiskNum));
        checkPointScores.put(verifyIndex, verifyRiskNum);
        checkPointScores.put(writeIndex, writeRiskNum);
    }

    protected boolean specialDisk(AnalyzeDisk disk) {
        String model = disk.getModel();
        String fw = disk.getFirmwareVersion();
        return "HUS156060VLS600".equalsIgnoreCase(model) && "A8F0".equalsIgnoreCase(fw) && disk.getType() == DiskType.SAS || "HUS156060VLF400".equalsIgnoreCase(model) && "F8F0".equalsIgnoreCase(fw) && disk.getType() == DiskType.FC;
    }

    protected void addCkFailedMethod(AnalyzeDisk analyzeDisk, Map<String, Integer> indexOfCK, Rule analyzeRule, List<String> startLineList, Map<String, Integer> checkPointScores) {
        for (String startLine : startLineList) {
            Set<CheckPoint> ck = analyzeRule.getCheckPointSet(startLine);
            this.recordNoDataCkInfo(startLine, analyzeDisk, indexOfCK, ck, checkPointScores);
        }
    }

    protected void checkNull(DiskAnalyzeBuffer feildBuffer) {
        String manu = feildBuffer.getAnalyzeDisk().getVender();
        if (StringUtils.isNULLStr((String)manu)) {
            feildBuffer.getAnalyzeDisk().setVender(DiskVender.getInstance().getVendor(feildBuffer.getAnalyzeDisk().getModel()));
        }
    }

    protected void recordNoDataCkInfo(String startLine, AnalyzeDisk analyzeDisk, Map<String, Integer> indexOfCK, Set<CheckPoint> ck, Map<String, Integer> checkPointScores) {
        DiskType type = analyzeDisk.getType();
        for (CheckPoint checkPoint : ck) {
            if (indexOfCK.containsKey(checkPoint.getId())) continue;
            if (type == DiskType.SAS || type == DiskType.SATA || type == DiskType.NLSAS) {
                checkPointScores.put(checkPoint.getId(), -1);
            }
            LOGGER.warn("Can not find start line {} fow ck {} value in disk {} ", new Object[]{startLine, checkPoint.getId(), analyzeDisk.getSn()});
        }
    }

    protected void addCheckPointValue(AnalyzeDevice ad, AnalyzeDisk analyzeDisk, Map<String, Integer> checkPointScores, Map<String, CheckPointValue> checkPointValues, String id, int startIndex, CheckPoint checkPoint, String[] infos) throws InvalidNumberException {
        boolean hssdFlag;
        CheckPointValue ckValue = null;
        int riskLevel = 0;
        boolean bl = hssdFlag = analyzeDisk.getModel().contains("HSSD-D5") || analyzeDisk.getModel().contains("HSSD-D6");
        if (hssdFlag && checkPoint.getId().equals("1.1")) {
            ckValue = new HssdD5ValueParser().getValue(infos, startIndex);
            if (ckValue != null) {
                riskLevel = this.getD5Score(ckValue, ad);
            }
        } else if ((analyzeDisk.getType() == DiskType.NVME || analyzeDisk.getType().equals((Object)DiskType.SCM) || analyzeDisk.getType().equals((Object)DiskType.QLC)) && "4.1".equals(checkPoint.getId())) {
            ckValue = checkPoint.getValueParser().getValue(infos, startIndex);
            if (ckValue != null) {
                riskLevel = this.getCERiskLevel(ckValue, ad);
            }
        } else {
            ckValue = checkPoint.getValueParser().getValue(infos, startIndex);
            if (ckValue != null) {
                ICheckLogic logic;
                if ("10".equals(id)) {
                    if ("N/A".equals(ckValue.getValue().trim())) {
                        ckValue.setValue("100");
                        HAVEDHA.put(analyzeDisk.getSn() + "N/A", analyzeDisk.getSn());
                        LOGGER.info(String.format(Locale.ENGLISH, "This disk don't have DHA :%s", analyzeDisk.getSn()));
                        POHMAP.put(ad.getUuid() + analyzeDisk.getSn(), "0");
                    }
                    this.setDiskTypeDhaThreshold(POHMAP.get(ad.getUuid() + analyzeDisk.getSn()), analyzeDisk.getType(), ckValue);
                    ckValue.setWorst(ckValue.getValue().trim());
                }
                riskLevel = (logic = checkPoint.getCheckLogic()) instanceof MutilEqual ? ((MutilEqual)logic).getMutilRiskLevel(analyzeDisk, ckValue) : checkPoint.getCheckLogic().getRiskLevel(ad.getDeviceInfo().getDeviceType().toString(), analyzeDisk.getVender(), ckValue);
            }
        }
        if ("2.1".equals(id) && analyzeDisk.getType().equals((Object)DiskType.SATA) && ckValue != null) {
            int rawRiskLevle = checkPoint.getCheckLogic().getRawRiskLevel(ad.getDeviceInfo().getDeviceType().toString(), analyzeDisk.getVender(), ckValue);
            riskLevel = riskLevel > rawRiskLevle ? riskLevel : rawRiskLevle;
        }
        checkPointScores.put(checkPoint.getId(), riskLevel);
        checkPointValues.put(checkPoint.getId(), ckValue);
    }

    protected int getCERiskLevel(CheckPointValue ckValue, AnalyzeDevice ad) throws InvalidNumberException {
        int value = Integer.parseInt(ckValue.getValue());
        if (value < 0) {
            throw new InvalidNumberException(ResourceUtil.getString((String)"diskhealthanalyze.exception.desc"));
        }
        if (value != 0) {
            String devType = ad.getDevTypeVersion();
            if (devType != null && devType.contains(DORADO)) {
                return 1;
            }
            return 10;
        }
        return 0;
    }

    protected int getD5Score(CheckPointValue ckValue, AnalyzeDevice ad) {
        boolean doradoResult;
        Long asc = Long.parseLong(ckValue.getValue(), 16);
        Long ascq = Long.parseLong(ckValue.getAscqValue(), 16);
        int ascValue = asc.intValue();
        int ascqValue = ascq.intValue();
        String deviceType = ad.getDeviceInfo().getDeviceType().toString();
        boolean oceanStorRusult = ascValue == 0 || ascValue == 11 && ascqValue == 1;
        boolean bl = doradoResult = ascValue == 93 && ascqValue == 109 || oceanStorRusult;
        if (deviceType.contains(DORADO) && doradoResult || oceanStorRusult) {
            return 0;
        }
        return 10;
    }

    protected void setHSSDFailReason(AnalyzeDisk analyzeDisk, AnalyzeDevice ad) {
        analyzeDisk.setAnalyzeSuc(false);
        ArrayList<String> reason = new ArrayList<String>();
        reason.add("1");
        analyzeDisk.setFailedReason(reason);
        ad.getFailedDiskList().add(analyzeDisk);
    }

    protected void setNVMeSSDFailReason(AnalyzeDisk analyzeDisk, AnalyzeDevice ad) {
        analyzeDisk.setAnalyzeSuc(false);
        ArrayList<String> reason = new ArrayList<String>();
        reason.add(String.valueOf(4));
        analyzeDisk.setFailedReason(reason);
        ad.getFailedDiskList().add(analyzeDisk);
    }

    public void setDiskTypeDhaThreshold(String poh, DiskType diskType, CheckPointValue ckVal) {
        block5: {
            double pohValue;
            block6: {
                block4: {
                    pohValue = Double.parseDouble(poh);
                    if (pohValue >= 87601.0) {
                        ckVal.setThreshold("0");
                    }
                    if (pohValue < 0.0) {
                        ckVal.setThreshold("0");
                        LOGGER.info("The value of POH is abnormal !!");
                    }
                    if (!this.judgeDiskType(diskType)) break block4;
                    for (int i = 0; i < this.valueSpanSAS.length; ++i) {
                        if (!(pohValue >= (double)this.valueSpanSAS[i][0]) || !(pohValue < (double)this.valueSpanSAS[i][1])) continue;
                        ckVal.setThreshold(Integer.toString(this.valueSpanSAS[i][2]));
                    }
                    break block5;
                }
                if (!DiskType.FC.equals((Object)diskType)) break block6;
                ckVal.setThreshold("0");
                break block5;
            }
            if (!DiskType.SATA.equals((Object)diskType)) break block5;
            for (int i = 0; i < this.valueSpanSATA.length; ++i) {
                if (!(pohValue >= (double)this.valueSpanSATA[i][0]) || !(pohValue < (double)this.valueSpanSATA[i][1])) continue;
                ckVal.setThreshold(Integer.toString(this.valueSpanSATA[i][2]));
            }
        }
    }

    public void getPOH(String line, AnalyzeDevice ad, DiskAnalyzeBuffer feildBuffer) {
        String[] strings;
        if (StringUtils.startIgnoreCase((String)line, (String)POH_SAS) && (strings = line.split(":")).length >= 2) {
            POHMAP.put(ad.getUuid() + feildBuffer.getAnalyzeDisk().getSn(), strings[1].trim());
            feildBuffer.getAnalyzeDisk().setPowerOnTime(strings[1].trim());
        }
        if (line.contains(POH_SATA)) {
            String[] pohLine;
            ArrayList<String> columns = new ArrayList<String>();
            for (String l : pohLine = line.split(" ")) {
                if (l.length() <= 0 || " ".equals(l)) continue;
                columns.add(l);
            }
            POHMAP.put(ad.getUuid() + feildBuffer.getAnalyzeDisk().getSn(), (String)columns.get(9));
            feildBuffer.getAnalyzeDisk().setPowerOnTime((String)columns.get(9));
        }
        if (line.startsWith(POH_NVMESSD) && line.contains(":")) {
            String[] pohline = line.split(":");
            POHMAP.put(ad.getUuid() + feildBuffer.getAnalyzeDisk().getSn(), pohline[1].trim());
            feildBuffer.getAnalyzeDisk().setPowerOnTime(pohline[1].trim());
        }
    }

    public boolean judgeDiskType(DiskType diskType) {
        return DiskType.SAS.equals((Object)diskType) || DiskType.HSSD.equals((Object)diskType) || DiskType.NEAR_LINE_SAS.equals((Object)diskType) || DiskType.NVME.equals((Object)diskType) || DiskType.NLSAS.equals((Object)diskType) || DiskType.SCM.equals((Object)diskType) || DiskType.QLC.equals((Object)diskType);
    }

    static {
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("HUSMM1640ASS204", "HITACHI");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("HUSMM1680ASS201", "HITACHI");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("HUSMM1680ASS204", "HITACHI");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("HUSMM8080ASS204", "HITACHI");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("LT0900RO", "SANDISK");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("LT1800RO", "SANDISK");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("SDLLOCDR036T5CHW", "SANDISK");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("SDLL1HLR076T5CHS", "HITACHI");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("SDLL1DLR960G5CHS", "HITACHI");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("SDLL1CLR020T5CHS", "HITACHI");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("SDLL1MLR038T5CHS", "HITACHI");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("MZILT7T6HMLA/007", "SAMSUNG");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("MZILT30THMLA/007", "SAMSUNG");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("MZILT3T8HALS/007", "SAMSUNG");
        PURCHASED_SSD_MODEL_VENDOR_MAP.put("MZILT15THMLA/007", "SAMSUNG");
    }
}

